/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.nativecode.JpegTranscoder;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class ResizeAndRotateProducer
implements Producer<EncodedImage> {
    private static final String PRODUCER_NAME = "ResizeAndRotateProducer";
    private static final String ORIGINAL_SIZE_KEY = "Original size";
    private static final String REQUESTED_SIZE_KEY = "Requested size";
    private static final String FRACTION_KEY = "Fraction";
    @VisibleForTesting
    static final int DEFAULT_JPEG_QUALITY = 85;
    @VisibleForTesting
    static final int MAX_JPEG_SCALE_NUMERATOR = 8;
    @VisibleForTesting
    static final int MIN_TRANSFORM_INTERVAL_MS = 100;
    private static final float ROUNDUP_FRACTION = 0.6666667f;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<EncodedImage> mInputProducer;

    public ResizeAndRotateProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<EncodedImage> inputProducer) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mInputProducer.produceResults(new TransformingConsumer(consumer, context), context);
    }

    private static TriState shouldTransform(ImageRequest request, EncodedImage encodedImage) {
        if (encodedImage == null || encodedImage.getImageFormat() == ImageFormat.UNKNOWN) {
            return TriState.UNSET;
        }
        if (encodedImage.getImageFormat() != ImageFormat.JPEG) {
            return TriState.NO;
        }
        return TriState.valueOf((ResizeAndRotateProducer.getRotationAngle(request, encodedImage) != 0 || ResizeAndRotateProducer.shouldResize(ResizeAndRotateProducer.getScaleNumerator(request, encodedImage)) ? 1 : 0) != 0);
    }

    @VisibleForTesting
    static float determineResizeRatio(ResizeOptions resizeOptions, int width, int height) {
        if (resizeOptions == null) {
            return 1.0f;
        }
        float widthRatio = (float)resizeOptions.width / (float)width;
        float heightRatio = (float)resizeOptions.height / (float)height;
        float ratio = Math.max(widthRatio, heightRatio);
        if ((float)width * ratio > 2048.0f) {
            ratio = 2048.0f / (float)width;
        }
        if ((float)height * ratio > 2048.0f) {
            ratio = 2048.0f / (float)height;
        }
        return ratio;
    }

    @VisibleForTesting
    static int roundNumerator(float maxRatio) {
        return (int)(0.6666667f + maxRatio * 8.0f);
    }

    private static int getScaleNumerator(ImageRequest imageRequest, EncodedImage encodedImage) {
        int heightAfterRotation;
        ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        if (resizeOptions == null) {
            return 8;
        }
        int rotationAngle = ResizeAndRotateProducer.getRotationAngle(imageRequest, encodedImage);
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270;
        int widthAfterRotation = swapDimensions ? encodedImage.getHeight() : encodedImage.getWidth();
        float ratio = ResizeAndRotateProducer.determineResizeRatio(resizeOptions, widthAfterRotation, heightAfterRotation = swapDimensions ? encodedImage.getWidth() : encodedImage.getHeight());
        int numerator = ResizeAndRotateProducer.roundNumerator(ratio);
        if (numerator > 8) {
            return 8;
        }
        return numerator < 1 ? 1 : numerator;
    }

    private static int getRotationAngle(ImageRequest imageRequest, EncodedImage encodedImage) {
        if (!imageRequest.getAutoRotateEnabled()) {
            return 0;
        }
        int rotationAngle = encodedImage.getRotationAngle();
        Preconditions.checkArgument((rotationAngle == 0 || rotationAngle == 90 || rotationAngle == 180 || rotationAngle == 270 ? 1 : 0) != 0);
        return rotationAngle;
    }

    private static boolean shouldResize(int numerator) {
        return numerator < 8;
    }

    private class TransformingConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;
        private boolean mIsCancelled;
        private final JobScheduler mJobScheduler;

        public TransformingConsumer(final Consumer<EncodedImage> consumer, ProducerContext producerContext) {
            super(consumer);
            this.mIsCancelled = false;
            this.mProducerContext = producerContext;
            JobScheduler.JobRunnable job = new JobScheduler.JobRunnable(){

                @Override
                public void run(EncodedImage encodedImage, boolean isLast) {
                    TransformingConsumer.this.doTransform(encodedImage, isLast);
                }
            };
            this.mJobScheduler = new JobScheduler(ResizeAndRotateProducer.this.mExecutor, job, 100);
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (TransformingConsumer.this.mProducerContext.isIntermediateResultExpected()) {
                        TransformingConsumer.this.mJobScheduler.scheduleJob();
                    }
                }

                @Override
                public void onCancellationRequested() {
                    TransformingConsumer.this.mJobScheduler.clearJob();
                    TransformingConsumer.this.mIsCancelled = true;
                    consumer.onCancellation();
                }
            });
        }

        @Override
        protected void onNewResultImpl(@Nullable EncodedImage newResult, boolean isLast) {
            if (this.mIsCancelled) {
                return;
            }
            if (newResult == null) {
                if (isLast) {
                    this.getConsumer().onNewResult(null, true);
                }
                return;
            }
            TriState shouldTransform = ResizeAndRotateProducer.shouldTransform(this.mProducerContext.getImageRequest(), newResult);
            if (!isLast && shouldTransform == TriState.UNSET) {
                return;
            }
            if (shouldTransform != TriState.YES) {
                this.getConsumer().onNewResult(newResult, isLast);
                return;
            }
            if (!this.mJobScheduler.updateJob(newResult, isLast)) {
                return;
            }
            if (isLast || this.mProducerContext.isIntermediateResultExpected()) {
                this.mJobScheduler.scheduleJob();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTransform(EncodedImage encodedImage, boolean isLast) {
            this.mProducerContext.getListener().onProducerStart(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME);
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            PooledByteBufferOutputStream outputStream = ResizeAndRotateProducer.this.mPooledByteBufferFactory.newOutputStream();
            Map<String, String> extraMap = null;
            EncodedImage ret = null;
            InputStream is = null;
            try {
                int numerator = ResizeAndRotateProducer.getScaleNumerator(imageRequest, encodedImage);
                extraMap = this.getExtraMap(encodedImage, imageRequest, numerator);
                is = encodedImage.getInputStream();
                JpegTranscoder.transcodeJpeg(is, outputStream, ResizeAndRotateProducer.getRotationAngle(imageRequest, encodedImage), numerator, 85);
                CloseableReference ref = CloseableReference.of((Closeable)outputStream.toByteBuffer());
                try {
                    ret = new EncodedImage((CloseableReference<PooledByteBuffer>)ref);
                    ret.setImageFormat(ImageFormat.JPEG);
                    try {
                        ret.parseMetaData();
                        this.mProducerContext.getListener().onProducerFinishWithSuccess(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME, extraMap);
                        this.getConsumer().onNewResult(ret, isLast);
                    }
                    finally {
                        EncodedImage.closeSafely(ret);
                    }
                }
                finally {
                    CloseableReference.closeSafely((CloseableReference)ref);
                }
            }
            catch (Exception e) {
                try {
                    this.mProducerContext.getListener().onProducerFinishWithFailure(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME, e, extraMap);
                    this.getConsumer().onFailure(e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(is);
                    outputStream.close();
                    throw throwable;
                }
                Closeables.closeQuietly((InputStream)is);
                outputStream.close();
                return;
            }
            Closeables.closeQuietly((InputStream)is);
            outputStream.close();
        }

        private Map<String, String> getExtraMap(EncodedImage encodedImage, ImageRequest imageRequest, int numerator) {
            if (!this.mProducerContext.getListener().requiresExtraMap(this.mProducerContext.getId())) {
                return null;
            }
            String originalSize = encodedImage.getWidth() + "x" + encodedImage.getHeight();
            String requestedSize = imageRequest.getResizeOptions() != null ? imageRequest.getResizeOptions().width + "x" + imageRequest.getResizeOptions().height : "Unspecified";
            String fraction = numerator > 0 ? numerator + "/8" : "";
            return ImmutableMap.of((Object)ResizeAndRotateProducer.ORIGINAL_SIZE_KEY, (Object)originalSize, (Object)ResizeAndRotateProducer.REQUESTED_SIZE_KEY, (Object)requestedSize, (Object)ResizeAndRotateProducer.FRACTION_KEY, (Object)fraction, (Object)"queueTime", (Object)String.valueOf(this.mJobScheduler.getQueuedTime()));
        }
    }
}

