/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import com.facebook.common.logging.FLog;
import com.facebook.imageutils.StreamProcessor;
import java.io.IOException;
import java.io.InputStream;

class TiffUtil {
    private static final Class<?> TAG = TiffUtil.class;
    public static final int TIFF_BYTE_ORDER_BIG_END = 1296891946;
    public static final int TIFF_BYTE_ORDER_LITTLE_END = 1229531648;
    public static final int TIFF_TAG_ORIENTATION = 274;
    public static final int TIFF_TYPE_SHORT = 3;

    TiffUtil() {
    }

    public static int getAutoRotateAngleFromOrientation(int orientation) {
        switch (orientation) {
            case 1: {
                return 0;
            }
            case 3: {
                return 180;
            }
            case 6: {
                return 90;
            }
            case 8: {
                return 270;
            }
        }
        FLog.i(TAG, (String)"Unsupported orientation");
        return 0;
    }

    public static int readOrientationFromTIFF(InputStream is, int length) throws IOException {
        TiffHeader tiffHeader = new TiffHeader();
        length = TiffUtil.readTiffHeader(is, length, tiffHeader);
        int toSkip = tiffHeader.firstIfdOffset - 8;
        if (length == 0 || toSkip > length) {
            return 0;
        }
        is.skip(toSkip);
        length -= toSkip;
        length = TiffUtil.moveToTiffEntryWithTag(is, length, tiffHeader.isLittleEndian, 274);
        return TiffUtil.getOrientationFromTiffEntry(is, length, tiffHeader.isLittleEndian);
    }

    private static int readTiffHeader(InputStream is, int length, TiffHeader tiffHeader) throws IOException {
        if (length <= 8) {
            return 0;
        }
        tiffHeader.byteOrder = StreamProcessor.readPackedInt(is, 4, false);
        length -= 4;
        if (tiffHeader.byteOrder != 1229531648 && tiffHeader.byteOrder != 1296891946) {
            FLog.e(TAG, (String)"Invalid TIFF header");
            return 0;
        }
        tiffHeader.isLittleEndian = tiffHeader.byteOrder == 1229531648;
        tiffHeader.firstIfdOffset = StreamProcessor.readPackedInt(is, 4, tiffHeader.isLittleEndian);
        if (tiffHeader.firstIfdOffset < 8 || tiffHeader.firstIfdOffset - 8 > (length -= 4)) {
            FLog.e(TAG, (String)"Invalid offset");
            return 0;
        }
        return length;
    }

    private static int moveToTiffEntryWithTag(InputStream is, int length, boolean isLittleEndian, int tagToFind) throws IOException {
        if (length < 14) {
            return 0;
        }
        int numEntries = StreamProcessor.readPackedInt(is, 2, isLittleEndian);
        length -= 2;
        while (numEntries-- > 0 && length >= 12) {
            int tag = StreamProcessor.readPackedInt(is, 2, isLittleEndian);
            length -= 2;
            if (tag == tagToFind) {
                return length;
            }
            is.skip(10L);
            length -= 10;
        }
        return 0;
    }

    private static int getOrientationFromTiffEntry(InputStream is, int length, boolean isLittleEndian) throws IOException {
        if (length < 10) {
            return 0;
        }
        int type = StreamProcessor.readPackedInt(is, 2, isLittleEndian);
        if (type != 3) {
            return 0;
        }
        int count = StreamProcessor.readPackedInt(is, 4, isLittleEndian);
        if (count != 1) {
            return 0;
        }
        int value = StreamProcessor.readPackedInt(is, 2, isLittleEndian);
        int padding = StreamProcessor.readPackedInt(is, 2, isLittleEndian);
        return value;
    }

    private static class TiffHeader {
        boolean isLittleEndian;
        int byteOrder;
        int firstIfdOffset;

        private TiffHeader() {
        }
    }
}

