/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.backends.pipeline;

import android.content.Context;
import android.net.Uri;
import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.drawee.backends.pipeline.PipelineDraweeController;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerFactory;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.Set;
import javax.annotation.Nullable;

public class PipelineDraweeControllerBuilder
extends AbstractDraweeControllerBuilder<PipelineDraweeControllerBuilder, ImageRequest, CloseableReference<CloseableImage>, ImageInfo> {
    private final ImagePipeline mImagePipeline;
    private final PipelineDraweeControllerFactory mPipelineDraweeControllerFactory;

    public PipelineDraweeControllerBuilder(Context context, PipelineDraweeControllerFactory pipelineDraweeControllerFactory, ImagePipeline imagePipeline, Set<ControllerListener> boundControllerListeners) {
        super(context, boundControllerListeners);
        this.mImagePipeline = imagePipeline;
        this.mPipelineDraweeControllerFactory = pipelineDraweeControllerFactory;
    }

    public PipelineDraweeControllerBuilder setUri(Uri uri) {
        return (PipelineDraweeControllerBuilder)super.setImageRequest((Object)ImageRequest.fromUri((Uri)uri));
    }

    public PipelineDraweeControllerBuilder setUri(@Nullable String uriString) {
        return (PipelineDraweeControllerBuilder)super.setImageRequest((Object)ImageRequest.fromUri((String)uriString));
    }

    protected PipelineDraweeController obtainController() {
        PipelineDraweeController controller;
        DraweeController oldController = this.getOldController();
        if (oldController instanceof PipelineDraweeController) {
            controller = (PipelineDraweeController)oldController;
            controller.initialize((Supplier<DataSource<CloseableReference<CloseableImage>>>)this.obtainDataSourceSupplier(), PipelineDraweeControllerBuilder.generateUniqueControllerId(), this.getCallerContext());
        } else {
            controller = this.mPipelineDraweeControllerFactory.newController((Supplier<DataSource<CloseableReference<CloseableImage>>>)this.obtainDataSourceSupplier(), PipelineDraweeControllerBuilder.generateUniqueControllerId(), this.getCallerContext());
        }
        return controller;
    }

    protected DataSource<CloseableReference<CloseableImage>> getDataSourceForRequest(ImageRequest imageRequest, Object callerContext, boolean bitmapCacheOnly) {
        if (bitmapCacheOnly) {
            return this.mImagePipeline.fetchImageFromBitmapCache(imageRequest, callerContext);
        }
        return this.mImagePipeline.fetchDecodedImage(imageRequest, callerContext);
    }

    protected PipelineDraweeControllerBuilder getThis() {
        return this;
    }
}

