/*
 * Decompiled with CFR 0.152.
 */
package com.jeepeng.react.xgpush;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.tencent.android.tpush.XGIOperateCallback;
import com.tencent.android.tpush.XGLocalMessage;
import com.tencent.android.tpush.XGPushConfig;
import com.tencent.android.tpush.XGPushManager;
import com.tencent.android.tpush.encrypt.Rijndael;

public class PushModule
extends ReactContextBaseJavaModule
implements ActivityEventListener,
LifecycleEventListener {
    public static final String MODULE_NAME = "XGPushManager";
    private Context reactContext;

    public PushModule(ReactApplicationContext reactContext) {
        super(reactContext);
        reactContext.addActivityEventListener((ActivityEventListener)this);
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
        this.reactContext = reactContext;
        this.registerReceivers();
    }

    public String getName() {
        return MODULE_NAME;
    }

    private void sendEvent(String eventName, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    private void registerReceivers() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("XGPushNotificationOnRegisterResult");
        intentFilter.addAction("XGPushNotificationOnTextMessage");
        intentFilter.addAction("XGPushNotificationOnClicked");
        intentFilter.addAction("XGPushNotificationOnShowed");
        this.reactContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                WritableMap params = Arguments.createMap();
                switch (intent.getAction()) {
                    case "XGPushNotificationOnRegisterResult": {
                        intent.getBundleExtra("notification");
                        String token = intent.getStringExtra("token");
                        params.putString("deviceToken", token);
                        PushModule.this.sendEvent("remoteNotificationsRegistered", params);
                        break;
                    }
                    case "XGPushNotificationOnTextMessage": {
                        String title = intent.getStringExtra("title");
                        String content = intent.getStringExtra("content");
                        String customContent = intent.getStringExtra("custom_content");
                        params.putString("title", title);
                        params.putString("content", content);
                        params.putString("custom_content", customContent);
                        PushModule.this.sendEvent("messageReceived", params);
                        break;
                    }
                    case "XGPushNotificationOnShowed": {
                        params.putString("title", intent.getStringExtra("title"));
                        params.putString("content", intent.getStringExtra("content"));
                        params.putString("custom_content", intent.getStringExtra("custom_content"));
                        PushModule.this.sendEvent("remoteNotificationReceived", params);
                        break;
                    }
                    case "XGPushNotificationOnClicked": {
                        params.putString("title", intent.getStringExtra("title"));
                        params.putString("content", intent.getStringExtra("content"));
                        params.putString("custom_content", intent.getStringExtra("custom_content"));
                        params.putBoolean("clicked", true);
                        PushModule.this.sendEvent("remoteNotificationReceived", params);
                        break;
                    }
                }
            }
        }, intentFilter);
    }

    @ReactMethod
    public void enableDebug(boolean isDebug) {
        XGPushConfig.enableDebug((Context)this.reactContext, (boolean)isDebug);
    }

    @ReactMethod
    public void isEnableDebug(Promise promise) {
        promise.resolve((Object)XGPushConfig.isEnableDebug((Context)this.reactContext));
    }

    @ReactMethod
    public void startApp(int accessId, String accessKey) {
        XGPushConfig.setAccessId((Context)this.reactContext, (long)accessId);
        XGPushConfig.setAccessKey((Context)this.reactContext, (String)accessKey);
    }

    @ReactMethod
    public void registerPush(String account, final Promise promise) {
        if (account != null && !"".equals(account)) {
            XGPushManager.registerPush((Context)this.reactContext, (String)account, (XGIOperateCallback)new XGIOperateCallback(){

                public void onSuccess(Object date, int flag) {
                    promise.resolve(date);
                }

                public void onFail(Object data, int errCode, String msg) {
                    promise.reject(String.valueOf(errCode), msg);
                }
            });
        } else {
            XGPushManager.registerPush((Context)this.reactContext, (XGIOperateCallback)new XGIOperateCallback(){

                public void onSuccess(Object date, int flag) {
                    promise.resolve(date);
                }

                public void onFail(Object data, int errCode, String msg) {
                    promise.reject(String.valueOf(errCode), msg);
                }
            });
        }
    }

    @ReactMethod
    public void unRegisterPush(final Promise promise) {
        XGPushManager.unregisterPush((Context)this.reactContext, (XGIOperateCallback)new XGIOperateCallback(){

            public void onSuccess(Object data, int flag) {
                WritableMap map = Arguments.createMap();
                map.putString("data", (String)data);
                map.putInt("flag", flag);
                promise.resolve((Object)map);
            }

            public void onFail(Object data, int errCode, String msg) {
                promise.reject(String.valueOf(errCode), msg);
            }
        });
    }

    @ReactMethod
    public void setTag(String tagName) {
        XGPushManager.setTag((Context)this.reactContext, (String)tagName);
    }

    @ReactMethod
    public void deleteTag(String tagName) {
        XGPushManager.deleteTag((Context)this.reactContext, (String)tagName);
    }

    @ReactMethod
    public void addLocalNotification(String title, String content) {
        XGLocalMessage message = new XGLocalMessage();
        message.setTitle(title);
        message.setContent(content);
        Log.i((String)MODULE_NAME, (String)title);
        Log.i((String)MODULE_NAME, (String)content);
        XGPushManager.addLocalNotification((Context)this.reactContext, (XGLocalMessage)message);
    }

    @ReactMethod
    public String getToken() {
        return XGPushConfig.getToken((Context)this.reactContext);
    }

    @ReactMethod
    public void setAccessId(String accessId) {
        try {
            XGPushConfig.setAccessId((Context)this.reactContext, (long)Long.parseLong(accessId));
        }
        catch (NumberFormatException exception) {
            exception.printStackTrace();
        }
    }

    @ReactMethod
    public long getAccessId() {
        return XGPushConfig.getAccessId((Context)this.reactContext);
    }

    @ReactMethod
    public void setAccessKey(String accessKey) {
        XGPushConfig.setAccessKey((Context)this.reactContext, (String)accessKey);
    }

    @ReactMethod
    public String getAccessKey() {
        return XGPushConfig.getAccessKey((Context)this.reactContext);
    }

    @ReactMethod
    public void getInitialNotification(Promise promise) {
        WritableMap params = Arguments.createMap();
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            Intent intent = activity.getIntent();
            try {
                if (intent != null && intent.hasExtra("protect")) {
                    String title = Rijndael.decrypt((String)intent.getStringExtra("title"));
                    String content = Rijndael.decrypt((String)intent.getStringExtra("content"));
                    String customContent = Rijndael.decrypt((String)intent.getStringExtra("custom_content"));
                    params.putString("title", title);
                    params.putString("content", content);
                    params.putString("custom_content", customContent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        promise.resolve((Object)params);
    }

    public void onHostResume() {
        XGPushManager.onActivityStarted((Activity)this.getCurrentActivity());
    }

    public void onHostPause() {
        XGPushManager.onActivityStoped((Activity)this.getCurrentActivity());
    }

    public void onHostDestroy() {
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
    }

    public void onNewIntent(Intent intent) {
    }
}

