/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.network.OkHttpCallUtil;
import com.facebook.react.devsupport.DebugServerException;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.InspectorPackagerConnection;
import com.facebook.react.devsupport.MultipartStreamReader;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.FileIoHandler;
import com.facebook.react.packagerconnection.JSPackagerClient;
import com.facebook.react.packagerconnection.NotificationOnlyHandler;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.RequestOnlyHandler;
import com.facebook.react.packagerconnection.Responder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.json.JSONException;
import org.json.JSONObject;

public class DevServerHelper {
    public static final String RELOAD_APP_EXTRA_JS_PROXY = "jsproxy";
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    private static final String BUNDLE_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s&hot=%s&minify=%s";
    private static final String RESOURCE_URL_FORMAT = "http://%s/%s";
    private static final String SOURCE_MAP_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s&hot=%s&minify=%s".replaceFirst("\\.bundle", ".map");
    private static final String LAUNCH_JS_DEVTOOLS_COMMAND_URL_FORMAT = "http://%s/launch-js-devtools";
    private static final String ONCHANGE_ENDPOINT_URL_FORMAT = "http://%s/onchange";
    private static final String WEBSOCKET_PROXY_URL_FORMAT = "ws://%s/debugger-proxy?role=client";
    private static final String PACKAGER_STATUS_URL_FORMAT = "http://%s/status";
    private static final String HEAP_CAPTURE_UPLOAD_URL_FORMAT = "http://%s/jscheapcaptureupload";
    private static final String INSPECTOR_DEVICE_URL_FORMAT = "http://%s/inspector/device?name=%s";
    private static final String PACKAGER_OK_STATUS = "packager-status:running";
    private static final int LONG_POLL_KEEP_ALIVE_DURATION_MS = 120000;
    private static final int LONG_POLL_FAILURE_DELAY_MS = 5000;
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    private final DevInternalSettings mSettings;
    private final OkHttpClient mClient;
    private final Handler mRestartOnChangePollingHandler;
    private boolean mOnChangePollingEnabled;
    @Nullable
    private JSPackagerClient mPackagerClient;
    @Nullable
    private InspectorPackagerConnection mInspectorPackagerConnection;
    @Nullable
    private OkHttpClient mOnChangePollingClient;
    @Nullable
    private OnServerContentChangeListener mOnServerContentChangeListener;
    @Nullable
    private Call mDownloadBundleFromURLCall;

    public DevServerHelper(DevInternalSettings settings) {
        this.mSettings = settings;
        this.mClient = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.mRestartOnChangePollingHandler = new Handler();
    }

    public void openPackagerConnection(final PackagerCommandListener commandListener) {
        if (this.mPackagerClient != null) {
            FLog.w((String)"React", (String)"Packager connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... backgroundParams) {
                HashMap<String, RequestHandler> handlers = new HashMap<String, RequestHandler>();
                handlers.put("reload", new NotificationOnlyHandler(){

                    @Override
                    public void onNotification(@Nullable Object params) {
                        commandListener.onPackagerReloadCommand();
                    }
                });
                handlers.put("captureHeap", new RequestOnlyHandler(){

                    @Override
                    public void onRequest(@Nullable Object params, Responder responder) {
                        commandListener.onCaptureHeapCommand(responder);
                    }
                });
                handlers.put("pokeSamplingProfiler", new RequestOnlyHandler(){

                    @Override
                    public void onRequest(@Nullable Object params, Responder responder) {
                        commandListener.onPokeSamplingProfilerCommand(responder);
                    }
                });
                handlers.putAll(new FileIoHandler().handlers());
                DevServerHelper.this.mPackagerClient = new JSPackagerClient("devserverhelper", DevServerHelper.this.mSettings.getPackagerConnectionSettings(), handlers);
                DevServerHelper.this.mPackagerClient.init();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void closePackagerConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mPackagerClient != null) {
                    DevServerHelper.this.mPackagerClient.close();
                    DevServerHelper.this.mPackagerClient = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void openInspectorConnection() {
        if (this.mInspectorPackagerConnection != null) {
            FLog.w((String)"React", (String)"Inspector connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                DevServerHelper.this.mInspectorPackagerConnection = new InspectorPackagerConnection(DevServerHelper.this.getInspectorDeviceUrl());
                DevServerHelper.this.mInspectorPackagerConnection.connect();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void openInspector(String id2) {
        if (this.mInspectorPackagerConnection != null) {
            this.mInspectorPackagerConnection.sendOpenEvent(id2);
        }
    }

    public void closeInspectorConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mInspectorPackagerConnection != null) {
                    DevServerHelper.this.mInspectorPackagerConnection.closeQuietly();
                    DevServerHelper.this.mInspectorPackagerConnection = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public static String getReloadAppAction(Context context) {
        return context.getPackageName() + RELOAD_APP_ACTION_SUFFIX;
    }

    public String getWebsocketProxyURL() {
        return String.format(Locale.US, WEBSOCKET_PROXY_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public String getHeapCaptureUploadUrl() {
        return String.format(Locale.US, HEAP_CAPTURE_UPLOAD_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public String getInspectorDeviceUrl() {
        return String.format(Locale.US, INSPECTOR_DEVICE_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), AndroidInfoHelpers.getFriendlyDeviceName());
    }

    private static String getHostForJSProxy() {
        return "localhost:8081";
    }

    private boolean getDevMode() {
        return this.mSettings.isJSDevModeEnabled();
    }

    private boolean getJSMinifyMode() {
        return this.mSettings.isJSMinifyEnabled();
    }

    private boolean getHMR() {
        return this.mSettings.isHotModuleReplacementEnabled();
    }

    private static String createBundleURL(String host, String jsModulePath, boolean devMode, boolean hmr, boolean jsMinify) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, host, jsModulePath, devMode, hmr, jsMinify);
    }

    private static String createResourceURL(String host, String resourcePath) {
        return String.format(Locale.US, RESOURCE_URL_FORMAT, host, resourcePath);
    }

    public String getDevServerBundleURL(String jsModulePath) {
        return DevServerHelper.createBundleURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), jsModulePath, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public void downloadBundleFromURL(final BundleDownloadCallback callback, final File outputFile, String bundleURL) {
        Request request = new Request.Builder().url(bundleURL).addHeader("Accept", "multipart/mixed").build();
        this.mDownloadBundleFromURLCall = (Call)Assertions.assertNotNull((Object)this.mClient.newCall(request));
        this.mDownloadBundleFromURLCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (DevServerHelper.this.mDownloadBundleFromURLCall == null || DevServerHelper.this.mDownloadBundleFromURLCall.isCanceled()) {
                    DevServerHelper.this.mDownloadBundleFromURLCall = null;
                    return;
                }
                DevServerHelper.this.mDownloadBundleFromURLCall = null;
                callback.onFailure(DebugServerException.makeGeneric("Could not connect to development server.", "URL: " + call.request().url().toString(), e));
            }

            public void onResponse(Call call, final Response response) throws IOException {
                if (DevServerHelper.this.mDownloadBundleFromURLCall == null || DevServerHelper.this.mDownloadBundleFromURLCall.isCanceled()) {
                    DevServerHelper.this.mDownloadBundleFromURLCall = null;
                    return;
                }
                DevServerHelper.this.mDownloadBundleFromURLCall = null;
                final String url = response.request().url().toString();
                String contentType = response.header("content-type");
                Pattern regex = Pattern.compile("multipart/mixed;.*boundary=\"([^\"]+)\"");
                Matcher match = regex.matcher(contentType);
                if (match.find()) {
                    String boundary = match.group(1);
                    MultipartStreamReader bodyReader = new MultipartStreamReader(response.body().source(), boundary);
                    boolean completed = bodyReader.readAllParts(new MultipartStreamReader.ChunkCallback(){

                        @Override
                        public void execute(Map<String, String> headers, Buffer body, boolean finished) throws IOException {
                            if (finished) {
                                int status = response.code();
                                if (headers.containsKey("X-Http-Status")) {
                                    status = Integer.parseInt(headers.get("X-Http-Status"));
                                }
                                DevServerHelper.this.processBundleResult(url, status, (BufferedSource)body, outputFile, callback);
                            } else {
                                if (!headers.containsKey("Content-Type") || !headers.get("Content-Type").equals("application/json")) {
                                    return;
                                }
                                try {
                                    JSONObject progress = new JSONObject(body.readUtf8());
                                    String status = null;
                                    if (progress.has("status")) {
                                        status = progress.getString("status");
                                    }
                                    Integer done = null;
                                    if (progress.has("done")) {
                                        done = progress.getInt("done");
                                    }
                                    Integer total = null;
                                    if (progress.has("total")) {
                                        total = progress.getInt("total");
                                    }
                                    callback.onProgress(status, done, total);
                                }
                                catch (JSONException e) {
                                    FLog.e((String)"React", (String)("Error parsing progress JSON. " + e.toString()));
                                }
                            }
                        }
                    });
                    if (!completed) {
                        callback.onFailure(new DebugServerException("Error while reading multipart response.\n\nResponse code: " + response.code() + "\n\n" + "URL: " + call.request().url().toString() + "\n\n"));
                    }
                } else {
                    DevServerHelper.this.processBundleResult(url, response.code(), Okio.buffer((Source)response.body().source()), outputFile, callback);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBundleResult(String url, int statusCode, BufferedSource body, File outputFile, BundleDownloadCallback callback) throws IOException {
        if (statusCode != 200) {
            String bodyString = body.readUtf8();
            DebugServerException debugServerException = DebugServerException.parse(bodyString);
            if (debugServerException != null) {
                callback.onFailure(debugServerException);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("The development server returned response error code: ").append(statusCode).append("\n\n").append("URL: ").append(url).append("\n\n").append("Body:\n").append(bodyString);
                callback.onFailure(new DebugServerException(sb.toString()));
            }
            return;
        }
        try (Sink output = null;){
            output = Okio.sink((File)outputFile);
            body.readAll(output);
            callback.onSuccess();
        }
    }

    public void cancelDownloadBundleFromURL() {
        if (this.mDownloadBundleFromURLCall != null) {
            this.mDownloadBundleFromURLCall.cancel();
            this.mDownloadBundleFromURLCall = null;
        }
    }

    public void isPackagerRunning(final PackagerStatusCallback callback) {
        String statusURL = DevServerHelper.createPackagerStatusURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
        Request request = new Request.Builder().url(statusURL).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                FLog.w((String)"React", (String)("The packager does not seem to be running as we got an IOException requesting its status: " + e.getMessage()));
                callback.onPackagerStatusFetched(false);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    FLog.e((String)"React", (String)("Got non-success http code from packager when requesting status: " + response.code()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    FLog.e((String)"React", (String)"Got null body response from packager when requesting status");
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                if (!DevServerHelper.PACKAGER_OK_STATUS.equals(body.string())) {
                    FLog.e((String)"React", (String)("Got unexpected response from packager when requesting status: " + body.string()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                callback.onPackagerStatusFetched(true);
            }
        });
    }

    private static String createPackagerStatusURL(String host) {
        return String.format(Locale.US, PACKAGER_STATUS_URL_FORMAT, host);
    }

    public void stopPollingOnChangeEndpoint() {
        this.mOnChangePollingEnabled = false;
        this.mRestartOnChangePollingHandler.removeCallbacksAndMessages(null);
        if (this.mOnChangePollingClient != null) {
            OkHttpCallUtil.cancelTag(this.mOnChangePollingClient, this);
            this.mOnChangePollingClient = null;
        }
        this.mOnServerContentChangeListener = null;
    }

    public void startPollingOnChangeEndpoint(OnServerContentChangeListener onServerContentChangeListener) {
        if (this.mOnChangePollingEnabled) {
            return;
        }
        this.mOnChangePollingEnabled = true;
        this.mOnServerContentChangeListener = onServerContentChangeListener;
        this.mOnChangePollingClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 120000L, TimeUnit.MINUTES)).connectTimeout(5000L, TimeUnit.MILLISECONDS).build();
        this.enqueueOnChangeEndpointLongPolling();
    }

    private void handleOnChangePollingResponse(boolean didServerContentChanged) {
        if (this.mOnChangePollingEnabled) {
            if (didServerContentChanged) {
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (DevServerHelper.this.mOnServerContentChangeListener != null) {
                            DevServerHelper.this.mOnServerContentChangeListener.onServerContentChanged();
                        }
                    }
                });
            }
            this.enqueueOnChangeEndpointLongPolling();
        }
    }

    private void enqueueOnChangeEndpointLongPolling() {
        Request request = new Request.Builder().url(this.createOnChangeEndpointUrl()).tag((Object)this).build();
        ((OkHttpClient)Assertions.assertNotNull((Object)this.mOnChangePollingClient)).newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (DevServerHelper.this.mOnChangePollingEnabled) {
                    FLog.d((String)"React", (String)"Error while requesting /onchange endpoint", (Throwable)e);
                    DevServerHelper.this.mRestartOnChangePollingHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DevServerHelper.this.handleOnChangePollingResponse(false);
                        }
                    }, 5000L);
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                DevServerHelper.this.handleOnChangePollingResponse(response.code() == 205);
            }
        });
    }

    private String createOnChangeEndpointUrl() {
        return String.format(Locale.US, ONCHANGE_ENDPOINT_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    private String createLaunchJSDevtoolsCommandUrl() {
        return String.format(Locale.US, LAUNCH_JS_DEVTOOLS_COMMAND_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public void launchJSDevtools() {
        Request request = new Request.Builder().url(this.createLaunchJSDevtoolsCommandUrl()).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
            }
        });
    }

    public String getSourceMapUrl(String mainModuleName) {
        return String.format(Locale.US, SOURCE_MAP_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public String getSourceUrl(String mainModuleName) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public String getJSBundleURLForRemoteDebugging(String mainModuleName) {
        return DevServerHelper.createBundleURL(DevServerHelper.getHostForJSProxy(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File downloadBundleResourceFromUrlSync(String resourcePath, File outputFile) {
        String resourceURL = DevServerHelper.createResourceURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), resourcePath);
        Request request = new Request.Builder().url(resourceURL).build();
        try {
            Response response = this.mClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                return null;
            }
            try (Sink output = null;){
                output = Okio.sink((File)outputFile);
                Okio.buffer((Source)response.body().source()).readAll(output);
            }
            return outputFile;
        }
        catch (Exception ex) {
            FLog.e((String)"React", (String)"Failed to fetch resource synchronously - resourcePath: \"%s\", outputFile: \"%s\"", (Object[])new Object[]{resourcePath, outputFile.getAbsolutePath(), ex});
            return null;
        }
    }

    public static interface PackagerCommandListener {
        public void onPackagerReloadCommand();

        public void onCaptureHeapCommand(@Nullable Responder var1);

        public void onPokeSamplingProfilerCommand(@Nullable Responder var1);
    }

    public static interface OnServerContentChangeListener {
        public void onServerContentChanged();
    }

    public static interface BundleDownloadCallback {
        public void onSuccess();

        public void onProgress(@Nullable String var1, @Nullable Integer var2, @Nullable Integer var3);

        public void onFailure(Exception var1);
    }
}

