/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.devsupport.interfaces.StackFrame;
import java.io.File;
import javax.annotation.Nullable;

public class StackTraceHelper {
    public static final String COLUMN_KEY = "column";
    public static final String LINE_NUMBER_KEY = "lineNumber";

    public static StackFrame[] convertJsStackTrace(@Nullable ReadableArray stack) {
        int size = stack != null ? stack.size() : 0;
        StackFrame[] result = new StackFrame[size];
        for (int i = 0; i < size; ++i) {
            ReadableMap frame = stack.getMap(i);
            String methodName = frame.getString("methodName");
            String fileName = frame.getString("file");
            int lineNumber = -1;
            if (frame.hasKey(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY)) {
                lineNumber = frame.getInt(LINE_NUMBER_KEY);
            }
            int columnNumber = -1;
            if (frame.hasKey(COLUMN_KEY) && !frame.isNull(COLUMN_KEY)) {
                columnNumber = frame.getInt(COLUMN_KEY);
            }
            result[i] = new StackFrameImpl(fileName, methodName, lineNumber, columnNumber);
        }
        return result;
    }

    public static StackFrame[] convertJavaStackTrace(Throwable exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        StackFrame[] result = new StackFrame[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new StackFrameImpl(stackTrace[i].getClassName(), stackTrace[i].getFileName(), stackTrace[i].getMethodName(), stackTrace[i].getLineNumber(), -1);
        }
        return result;
    }

    public static String formatFrameSource(StackFrame frame) {
        StringBuilder lineInfo = new StringBuilder();
        lineInfo.append(frame.getFileName());
        int line = frame.getLine();
        if (line > 0) {
            lineInfo.append(":").append(line);
            int column = frame.getColumn();
            if (column > 0) {
                lineInfo.append(":").append(column);
            }
        }
        return lineInfo.toString();
    }

    public static String formatStackTrace(String title, StackFrame[] stack) {
        StringBuilder stackTrace = new StringBuilder();
        stackTrace.append(title).append("\n");
        for (StackFrame frame : stack) {
            stackTrace.append(frame.getMethod()).append("\n").append("    ").append(StackTraceHelper.formatFrameSource(frame)).append("\n");
        }
        return stackTrace.toString();
    }

    public static class StackFrameImpl
    implements StackFrame {
        private final String mFile;
        private final String mMethod;
        private final int mLine;
        private final int mColumn;
        private final String mFileName;

        private StackFrameImpl(String file, String method, int line, int column) {
            this.mFile = file;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
            this.mFileName = new File(file).getName();
        }

        private StackFrameImpl(String file, String fileName, String method, int line, int column) {
            this.mFile = file;
            this.mFileName = fileName;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
        }

        @Override
        public String getFile() {
            return this.mFile;
        }

        @Override
        public String getMethod() {
            return this.mMethod;
        }

        @Override
        public int getLine() {
            return this.mLine;
        }

        @Override
        public int getColumn() {
            return this.mColumn;
        }

        @Override
        public String getFileName() {
            return this.mFileName;
        }
    }
}

