/*
 * Decompiled with CFR 0.152.
 */
package com.jeepeng.react.xgpush.receiver;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.tencent.android.tpush.XGPushBaseReceiver;
import com.tencent.android.tpush.XGPushClickedResult;
import com.tencent.android.tpush.XGPushRegisterResult;
import com.tencent.android.tpush.XGPushShowedResult;
import com.tencent.android.tpush.XGPushTextMessage;

public class MessageReceiver
extends XGPushBaseReceiver {
    public void onRegisterResult(Context context, int errorCode, XGPushRegisterResult xgPushRegisterResult) {
        if (errorCode == 0) {
            Intent intent = new Intent("XGPushNotificationOnRegisterResult");
            intent.putExtra("token", xgPushRegisterResult.getToken());
            context.sendBroadcast(intent);
        }
    }

    public void onUnregisterResult(Context context, int errorCode) {
    }

    public void onSetTagResult(Context context, int errorCode, String tagName) {
    }

    public void onDeleteTagResult(Context context, int errorCode, String tagName) {
    }

    public void onTextMessage(Context context, XGPushTextMessage xgPushTextMessage) {
        Intent intent = new Intent("XGPushNotificationOnTextMessage");
        intent.putExtra("title", xgPushTextMessage.getTitle());
        intent.putExtra("content", xgPushTextMessage.getContent());
        intent.putExtra("customContent", xgPushTextMessage.getCustomContent());
        context.sendBroadcast(intent);
    }

    public void onNotifactionClickedResult(Context context, XGPushClickedResult notification) {
        if (context == null || notification == null) {
            return;
        }
        if (notification.getActionType() == 0L) {
            Intent intent = new Intent("XGPushNotificationOnClicked");
            Bundle bundle = new Bundle();
            bundle.putString("content", notification.getContent());
            bundle.putString("title", notification.getTitle());
            bundle.putString("custom_content", notification.getCustomContent());
            intent.putExtra("notification", bundle);
            intent.putExtra("title", notification.getTitle());
            intent.putExtra("content", notification.getContent());
            intent.putExtra("custom_content", notification.getCustomContent());
            intent.putExtra("activity", notification.getActivityName());
            intent.putExtra("msgId", notification.getMsgId());
            intent.putExtra("notificationActionType", notification.getNotificationActionType());
            context.sendBroadcast(intent);
        } else if (notification.getActionType() == 2L) {
            // empty if block
        }
    }

    public void onNotifactionShowedResult(Context context, XGPushShowedResult xgPushShowedResult) {
        Intent intent = new Intent("XGPushNotificationOnShowed");
        Bundle bundle = new Bundle();
        bundle.putString("content", xgPushShowedResult.getContent());
        bundle.putString("title", xgPushShowedResult.getTitle());
        bundle.putString("custom_content", xgPushShowedResult.getCustomContent());
        intent.putExtra("notification", bundle);
        intent.putExtra("title", xgPushShowedResult.getTitle());
        intent.putExtra("content", xgPushShowedResult.getContent());
        intent.putExtra("custom_content", xgPushShowedResult.getCustomContent());
        intent.putExtra("activity", xgPushShowedResult.getActivity());
        intent.putExtra("msgId", xgPushShowedResult.getMsgId());
        intent.putExtra("notificationId", xgPushShowedResult.getNotifactionId());
        intent.putExtra("notificationActionType", xgPushShowedResult.getNotificationActionType());
        context.sendBroadcast(intent);
    }
}

