/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.android.tpush.service.channel.security;

import android.content.Context;
import android.content.SharedPreferences;
import com.tencent.android.tpush.a.a;
import com.tencent.android.tpush.encrypt.Rijndael;
import com.tencent.android.tpush.service.channel.security.d;
import com.tencent.android.tpush.service.channel.security.e;
import com.tencent.android.tpush.service.channel.security.g;
import com.tencent.android.tpush.service.e.h;
import java.io.File;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TpnsSecurity {
    private static boolean loadedTpnsSecuritySo = false;
    private static final String tpnsSecurityLibName = "tpnsSecurity";
    public static final String tpnsSecurityLibFullName = "libtpnsSecurity.so";
    protected long random;
    protected byte[] key;
    protected byte[] encKey;
    protected byte[] iv;
    protected long inc = 0L;
    protected long incRemote;
    private static final String DEVICE_ID_VERSION = "v1";
    private static final String DEVICE_ID_PREFIX = "deviceId_";
    private static final String DEVICE_ID_KEY_NAME = "deviceId_v1";
    private static final String SHAREPREFERENCE_FILE_NAME = "device_id";
    private static final String SETTINGS_DEVICE_ID_PREFIX = ".com.tencent.tpush.cache";
    private static final String SETTINGS_DEVICE_ID_KEY_NAME = ".com.tencent.tpush.cache.deviceId_v1";
    String modulusStr = "C0EF17C0E492C4D366E236902188EF567990289AF267DDC48134C78F3D5632BACB469E1961DD7D61EFEC6B045A138C4DC2E53CC850E796B20664B8F8F58B96F81C9827F7F0C3A15CC4B5BDB5DA2AED5D70E804765F6025613522779A381F5EF3A20A9B043ECA001DB50F873E1CDF335AD382AC66BE3E419CA8F67009BFF3253F";
    public static g tea;

    public static boolean checkTpnsSecurityLibSo(Context context) {
        if (loadedTpnsSecuritySo) {
            return true;
        }
        if (context != null) {
            String string = "";
            try {
                string = context.getDir("lib", 0).getParentFile().getAbsolutePath() + File.separator + "lib" + File.separator + tpnsSecurityLibFullName;
                System.load(string);
                loadedTpnsSecuritySo = true;
            }
            catch (Throwable throwable) {
                loadedTpnsSecuritySo = false;
                a.h("XGService", "can not load library from " + string + ",error:" + throwable);
            }
        }
        return loadedTpnsSecuritySo;
    }

    public long getRandom() {
        return this.random;
    }

    public byte[] getEncKey() {
        return this.encKey;
    }

    public long getInc() {
        return ++this.inc;
    }

    public void checkRemoteInc(long l2) {
        if (l2 <= this.incRemote) {
            throw new SecurityException("\u68c0\u67e5\u7684inc\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u8bb0\u5f55\u7684\u8fdc\u7aefinc");
        }
        this.incRemote = l2;
    }

    public void reset() {
        this.random = 0L;
    }

    public boolean needsUpdate() {
        return this.random == 0L;
    }

    public void update() {
        this.random = 0L;
        while (this.random == 0L) {
            this.random = (long)(Math.random() * 2.147483647E9);
        }
        this.iv = TpnsSecurity.generateIV(this.random);
        try {
            this.key = TpnsSecurity.generateAESKey();
            this.encKey = this.encryptByRSA(this.key);
        }
        catch (Throwable throwable) {
            a.c("XGService", "update error:", throwable);
        }
    }

    public byte[] decryptData(byte[] byArray) {
        try {
            return this.decryptByAES(byArray, this.random);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return byArray;
        }
    }

    public byte[] encryptData(byte[] byArray) {
        try {
            return this.encryptByAES(byArray, this.random);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return byArray;
        }
    }

    private static String toCharsString(byte[] byArray) {
        byte[] byArray2 = byArray;
        int n2 = byArray2.length;
        int n3 = n2 * 2;
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray2[i2];
            int n4 = by >> 4 & 0xF;
            cArray[i2 * 2] = (char)(n4 >= 10 ? 97 + n4 - 10 : 48 + n4);
            n4 = by & 0xF;
            cArray[i2 * 2 + 1] = (char)(n4 >= 10 ? 97 + n4 - 10 : 48 + n4);
        }
        return new String(cArray);
    }

    public static String oiSymmetryEncrypt2(String string) {
        String string2 = "";
        try {
            if (string == null || string.length() <= 0) {
                a.h("XGService", ">> oiSymmetryEncrypt2 \u52a0\u5bc6\u5185\u5bb9\u8f93\u5165\u4e3a\u7a7a");
                return "";
            }
            byte[] byArray = TpnsSecurity.oiSymmetryEncrypt2Byte(string);
            if (byArray == null) {
                a.h("XGService", ">> oiSymmetryEncrypt2 \u52a0\u5bc6\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32 inBuff:" + string);
                return "failed";
            }
            string2 = e.a(byArray);
            if (string2 == null) {
                a.h("XGService", ">> oiSymmetryEncrypt2 Base64\u7f16\u7801\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
                return "failed";
            }
        }
        catch (Throwable throwable) {
            a.c("XGService", ">> oiSymmetryEncrypt2 \u672a\u77e5\u9519\u8bef", throwable);
            return "failed";
        }
        return string2;
    }

    public static String oiSymmetryDecrypt2(String string) {
        byte[] byArray = "".getBytes();
        try {
            if (string == null || string.length() <= 0) {
                a.h("XGService", ">> oiSymmetryDecrypt2 \u89e3\u5bc6\u5185\u5bb9\u8f93\u5165\u4e3a\u7a7a");
                return "";
            }
            byte[] byArray2 = d.a(string);
            if (byArray2 == null || byArray2.length <= 0) {
                a.h("XGService", ">> oiSymmetryDecrypt2 \u89e3\u7801\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
                return "failed";
            }
            byArray = TpnsSecurity.oiSymmetryDecrypt2Byte(byArray2);
            if (byArray == null || byArray.length <= 0) {
                a.h("XGService", ">> oiSymmetryDecrypt2 \u89e3\u5bc6\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
                return "failed";
            }
        }
        catch (Throwable throwable) {
            a.c("XGService", ">> oiSymmetryEncrypt2 \u672a\u77e5\u9519\u8bef", throwable);
            return "failed";
        }
        return new String(byArray);
    }

    public static String generateLocalSocketServieName(Context context) {
        if (context != null) {
            try {
                return TpnsSecurity.generateLocalSocketServieNameNative(context);
            }
            catch (Throwable throwable) {
                a.c("XGService", "generateLocalSocketServieName \u672a\u77e5\u9519\u8bef", throwable);
            }
        }
        throw new SecurityException("generate local socket server name error");
    }

    public static String getBusinessDeviceId(Context context) {
        if (context == null) {
            throw new SecurityException("get device id error cause context is null");
        }
        String string = null;
        string = TpnsSecurity.getSettingsLocalDeviceId(context);
        if (string != null) {
            return string;
        }
        string = TpnsSecurity.getPreferenceLocalDeviceId(context);
        if (string != null) {
            TpnsSecurity.setSettingsLocalDeviceId(context, string);
            return string;
        }
        string = TpnsSecurity.getBusinessDeviceIdNative(context);
        TpnsSecurity.setPreferenceLocalDeviceId(context, string);
        TpnsSecurity.setSettingsLocalDeviceId(context, string);
        return string;
    }

    private static String getPreferenceLocalDeviceId(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHAREPREFERENCE_FILE_NAME, 0);
        if (!sharedPreferences.contains(com.tencent.android.tpush.encrypt.a.a(DEVICE_ID_KEY_NAME))) {
            return null;
        }
        String string = sharedPreferences.getString(com.tencent.android.tpush.encrypt.a.a(DEVICE_ID_KEY_NAME), null);
        if (string == null || string.trim().equals("")) {
            return null;
        }
        String string2 = Rijndael.decrypt(string);
        if (h.b(string2)) {
            return null;
        }
        return string2;
    }

    private static void setPreferenceLocalDeviceId(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHAREPREFERENCE_FILE_NAME, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(com.tencent.android.tpush.encrypt.a.a(DEVICE_ID_KEY_NAME), Rijndael.encrypt(string));
        editor.commit();
    }

    private static String getSettingsLocalDeviceId(Context context) {
        String string = com.tencent.android.tpush.service.e.e.a(context, SETTINGS_DEVICE_ID_KEY_NAME);
        if (string == null) {
            return null;
        }
        String string2 = Rijndael.decrypt(string);
        if (h.b(string2)) {
            return null;
        }
        return string2;
    }

    private static void setSettingsLocalDeviceId(Context context, String string) {
        com.tencent.android.tpush.service.e.e.a(context, SETTINGS_DEVICE_ID_KEY_NAME, Rijndael.encrypt(string));
    }

    public static String getEncryptAPKSignature(Context context) {
        if (context != null) {
            return TpnsSecurity.getEncryptAPKSignatureNative(context);
        }
        throw new SecurityException("get encrypt apk signature error");
    }

    public static native byte[] generateAESKey();

    public static byte[] java_generateAESKey() {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static native byte[] generateIV(long var0);

    public static byte[] java_generateIV(long l2) {
        byte[] byArray = new byte[16];
        for (int i2 = 0; i2 < 4; ++i2) {
            byte by;
            int n2 = i2 * 4;
            byArray[n2] = by = (byte)(l2 >> 8 * i2 & 0xFFL);
            byArray[n2 + 1] = by;
            byArray[n2 + 2] = by;
            byArray[n2 + 3] = by;
        }
        return byArray;
    }

    public native byte[] encryptByRSA(byte[] var1);

    public byte[] java_encryptByRSA(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(this.modulusStr, 16);
        BigInteger bigInteger2 = new BigInteger("010001", 16);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
        cipher.init(1, publicKey);
        return cipher.doFinal(byArray);
    }

    public native byte[] encryptByAES(byte[] var1, long var2);

    public byte[] java_encryptByAES(byte[] byArray, long l2) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        return cipher.doFinal(byArray);
    }

    public native byte[] decryptByAES(byte[] var1, long var2);

    public byte[] java_decryptByAES(byte[] byArray, long l2) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        return cipher.doFinal(byArray);
    }

    public static native byte[] oiSymmetryEncrypt2Byte(String var0);

    public static g getTEA() {
        if (tea == null) {
            tea = new g("0123456789abcdef".getBytes());
        }
        return tea;
    }

    public static byte[] java_oiSymmetryEncrypt2Byte(String string) {
        return TpnsSecurity.getTEA().a(string.getBytes());
    }

    public static native byte[] oiSymmetryDecrypt2Byte(byte[] var0);

    public static byte[] java_oiSymmetryDecrypt2Byte(byte[] byArray) {
        return TpnsSecurity.getTEA().b(byArray);
    }

    public static native String generateLocalSocketServieNameNative(Object var0);

    public static native String getBusinessDeviceIdNative(Object var0);

    public static native String getEncryptAPKSignatureNative(Object var0);

    static {
        try {
            System.loadLibrary(tpnsSecurityLibName);
            loadedTpnsSecuritySo = true;
        }
        catch (Throwable throwable) {
            a.c("XGService", "can not load library,error:", throwable);
            loadedTpnsSecuritySo = false;
        }
        tea = null;
    }
}

