/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.android.tpush;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.util.Log;
import com.jg.EType;
import com.jg.JgClassChecked;
import com.tencent.android.tpush.XGIOperateCallback;
import com.tencent.android.tpush.XGLocalMessage;
import com.tencent.android.tpush.XGPushClickedResult;
import com.tencent.android.tpush.XGPushConfig;
import com.tencent.android.tpush.XGPushNotifactionCallback;
import com.tencent.android.tpush.XGPushNotificationBuilder;
import com.tencent.android.tpush.XGPushTextMessage;
import com.tencent.android.tpush.a.a;
import com.tencent.android.tpush.aa;
import com.tencent.android.tpush.ab;
import com.tencent.android.tpush.ac;
import com.tencent.android.tpush.ad;
import com.tencent.android.tpush.ae;
import com.tencent.android.tpush.ag;
import com.tencent.android.tpush.ah;
import com.tencent.android.tpush.b.b;
import com.tencent.android.tpush.b.d;
import com.tencent.android.tpush.b.i;
import com.tencent.android.tpush.b.n;
import com.tencent.android.tpush.common.g;
import com.tencent.android.tpush.common.m;
import com.tencent.android.tpush.common.t;
import com.tencent.android.tpush.data.MessageId;
import com.tencent.android.tpush.encrypt.Rijndael;
import com.tencent.android.tpush.service.XGPushServiceV3;
import com.tencent.android.tpush.service.channel.protocol.TpnsPushMsg;
import com.tencent.android.tpush.service.channel.security.TpnsSecurity;
import com.tencent.android.tpush.service.e.h;
import com.tencent.android.tpush.service.s;
import com.tencent.android.tpush.u;
import com.tencent.android.tpush.v;
import com.tencent.android.tpush.x;
import com.tencent.android.tpush.y;
import com.tencent.android.tpush.z;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

@JgClassChecked(author=1, reviewer=3, lastDate="20150316", vComment={EType.RECEIVERCHECK, EType.INTENTCHECK}, fComment="\u786e\u8ba4\u5df2\u8fdb\u884c\u5b89\u5168\u6821\u9a8c")
public class XGPushManager {
    public static final int OPERATION_SUCCESS = 0;
    public static final int OPERATION_FAIL = 1;
    public static final int OPERATION_REQ_REGISTER = 100;
    public static final int OPERATION_REQ_UNREGISTER = 101;
    private static final String a = XGPushManager.class.getSimpleName();
    private static Context b = null;
    private static XGPushNotifactionCallback c = null;
    public static int enableService = -1;
    public static final String ENABLE_SERVICE_SUFFIX = ".enableService";
    private static Map d = new ConcurrentHashMap();

    private XGPushManager() {
    }

    public static Context getContext() {
        return b;
    }

    public static void setContext(Context context) {
        if (b == null && context != null) {
            b = context.getApplicationContext();
        }
    }

    public static void startPushService(Context context) {
        if (context != null) {
            XGPushManager.setContext(context);
            if (XGPushConfig.enableDebug) {
                com.tencent.android.tpush.a.a.e(a, context.getPackageName() + "call start Push Service");
            }
            t.g(context);
            if (t.c(context) == 0) {
                t.e(context);
            }
        }
    }

    static void a(Context context) {
        if (context != null) {
            if (XGPushConfig.enableDebug) {
                com.tencent.android.tpush.a.a.e(a, context.getPackageName() + " call stop Push Service");
            }
            Intent intent = new Intent();
            intent.setClass(context.getApplicationContext(), XGPushServiceV3.class);
            context.stopService(intent);
        }
    }

    public static int getServiceStatus(Context context) {
        if (context != null) {
            return t.c(context);
        }
        return 0;
    }

    public static void registerPush(Context context) {
        XGPushManager.registerPush(context, new u());
    }

    public static void registerPush(Context context, XGIOperateCallback xGIOperateCallback) {
        if (xGIOperateCallback == null) {
            throw new IllegalArgumentException("The callback parameter can not be null!");
        }
        XGPushManager.a(context, null, null, -1, null, xGIOperateCallback, -1L, null);
    }

    public static void registerPush(Context context, String string, XGIOperateCallback xGIOperateCallback) {
        if (xGIOperateCallback == null) {
            throw new IllegalArgumentException("The callback parameter can not be null!");
        }
        XGPushManager.registerPush(context, string, "0", 0, null, xGIOperateCallback);
    }

    public static void registerPush(Context context, String string) {
        if (context == null || string == null) {
            com.tencent.android.tpush.a.a.i("TPush", "the parameter context or account of registerPush is invalid.");
            return;
        }
        XGPushManager.registerPush(context, string, new x());
    }

    public static void registerPush(Context context, String string, String string2, int n2, String string3, XGIOperateCallback xGIOperateCallback) {
        if (xGIOperateCallback == null) {
            throw new IllegalArgumentException("The callback parameter can not be null!");
        }
        if (context == null || t.b(string) || t.b(string2) || n2 < 0) {
            xGIOperateCallback.onFail(null, 10001, "The context, account, ticket or ticketType is(are) invalid!");
            return;
        }
        XGPushManager.a(context, string, string2, n2, string3, xGIOperateCallback, -1L, null);
    }

    public static void unregisterPush(Context context) {
        if (context == null) {
            com.tencent.android.tpush.a.a.h("TPush", "the context of unregisterPush is null");
            return;
        }
        XGPushManager.unregisterPush(context, new y());
    }

    public static void unregisterPush(Context context, XGIOperateCallback xGIOperateCallback) {
        XGPushManager.a(context, xGIOperateCallback, XGPushConfig.getAccessId(context), XGPushConfig.getAccessKey(context));
    }

    static void a(Context context, XGIOperateCallback xGIOperateCallback, long l2, String string) {
        if (context == null) {
            XGPushManager.setContext(context);
            if (xGIOperateCallback != null) {
                xGIOperateCallback.onFail(null, 10001, "The context parameter can not be null!");
                return;
            }
            throw new IllegalArgumentException("The context parameter can not be null!");
        }
        Context context2 = context.getApplicationContext();
        g.a().a(new z(context2, xGIOperateCallback, l2, string));
    }

    public static void setTag(Context context, String string) {
        if (XGPushConfig.enableDebug) {
            com.tencent.android.tpush.a.a.e(a, "Action -> setTag with tag = " + string);
        }
        XGPushManager.a(context, string, 1, -1L);
    }

    public static void setKeyValueTag(Context context, String string, String string2) {
        if (context == null || string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0) {
            com.tencent.android.tpush.a.a.i(a, "setKeyValueTag context or tagKey or tagValue invalid.");
            return;
        }
        String string3 = string + "::::" + string2;
        com.tencent.android.tpush.a.a.e(a, "Action -> setKeyValueTag with tag = " + string3);
        XGPushManager.a(context, string3, 3, -1L);
    }

    public static void sendCommReport2Service(Context context, String string, String string2) {
        long l2 = XGPushConfig.getAccessId(context);
        Intent intent = new Intent("com.tencent.android.tpush.action.COMM_REPORT.V3");
        intent.putExtra("type", 1L);
        intent.putExtra("accessId", Rijndael.encrypt("" + l2));
        intent.putExtra("msgId", 1000L);
        intent.putExtra("broadcastId", 0L);
        intent.putExtra("msgTimestamp", System.currentTimeMillis() / 1000L);
        intent.putExtra("clientTimestamp", System.currentTimeMillis() / 1000L);
        intent.putExtra("pkgName", context.getPackageName());
        intent.putExtra("msg", Rijndael.encrypt(string));
        intent.putExtra("ext", Rijndael.encrypt(string2));
        context.sendBroadcast(intent);
    }

    public static void deleteKeyValueTag(Context context, String string, String string2) {
        if (context == null || string == null || string.trim().length() == 0) {
            com.tencent.android.tpush.a.a.i(a, "deleteKeyValueTag context or tagKey invalid.");
            return;
        }
        String string3 = string + "::::" + string2;
        com.tencent.android.tpush.a.a.e(a, "Action -> deleteKeyValueTag with tag = " + string3);
        XGPushManager.a(context, string3, 4, -1L);
    }

    public static void deleteTag(Context context, String string) {
        if (XGPushConfig.enableDebug) {
            com.tencent.android.tpush.a.a.e(a, "Action -> deleteTag with tag = " + string);
        }
        if (context == null || string == null || string.trim().length() == 0) {
            com.tencent.android.tpush.a.a.i(a, "context is null or tagName invalid.");
            return;
        }
        XGPushManager.a(context, string, 2, -1L);
    }

    static void a(Context context, String string, int n2, long l2) {
        if (context == null) {
            throw new IllegalArgumentException("The context parameter can not be null!");
        }
        if (t.a(context) > 0) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("The tagName parameter can not be null!");
        }
        long l3 = l2;
        if (l2 <= 0L) {
            l3 = XGPushConfig.getAccessId(context);
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("The accessId not set!");
        }
        Intent intent = new Intent("com.tencent.android.tpush.action.TAG.V3");
        intent.putExtra("accId", l3);
        intent.putExtra("packName", Rijndael.encrypt(context.getPackageName()));
        intent.putExtra("tagFlag", n2);
        intent.putExtra("tagName", Rijndael.encrypt(string));
        context.sendBroadcast(intent);
    }

    static XGPushClickedResult a(Activity activity) {
        if (XGPushConfig.enableDebug) {
            com.tencent.android.tpush.a.a.e("TPush", ">>> onActivityStarted activity=" + activity);
        }
        if (activity == null || activity.getIntent() == null) {
            return null;
        }
        Intent intent = activity.getIntent();
        String string = intent.getStringExtra("tag.tpush.MSG");
        if (string == null || !string.equalsIgnoreCase("true")) {
            return null;
        }
        if (t.a(activity.getApplicationContext()) > 0) {
            return null;
        }
        XGPushClickedResult xGPushClickedResult = new XGPushClickedResult();
        xGPushClickedResult.parseIntent(intent);
        intent.removeExtra("tag.tpush.MSG");
        g.a().a(new aa(activity, intent));
        return xGPushClickedResult;
    }

    public static XGPushClickedResult onActivityStarted(Activity activity) {
        if (XGPushConfig.enableDebug) {
            com.tencent.android.tpush.a.a.e("XGPushMessage", ">>> onActivityStarted " + activity);
        }
        if (activity == null || activity.getIntent() == null || !t.h((Context)activity)) {
            return null;
        }
        Intent intent = activity.getIntent();
        try {
            if (intent != null && intent.hasExtra("tag.tpush.NOTIFIC")) {
                Serializable serializable = intent.getSerializableExtra("tag.tpush.NOTIFIC");
                intent.removeExtra("tag.tpush.NOTIFIC");
                if (serializable != null && serializable instanceof XGPushClickedResult) {
                    XGPushClickedResult xGPushClickedResult = (XGPushClickedResult)serializable;
                    xGPushClickedResult.parseIntent(intent);
                    return xGPushClickedResult;
                }
            }
        }
        catch (Exception exception) {
            com.tencent.android.tpush.a.a.c(a, "onActivityStarted", exception);
        }
        return null;
    }

    public static long addLocalNotification(Context context, XGLocalMessage xGLocalMessage) {
        return XGPushManager.a(context, xGLocalMessage, -1L);
    }

    static long a(Context context, XGLocalMessage xGLocalMessage, long l2) {
        try {
            if (context == null || xGLocalMessage == null) {
                com.tencent.android.tpush.a.a.h(a, "addLocalNotification context == null or msg == null");
                return -1L;
            }
            if (!TpnsSecurity.checkTpnsSecurityLibSo(context)) {
                return -1L;
            }
            long l3 = l2 <= 0L ? XGPushConfig.getAccessId(context) : l2;
            long l4 = System.currentTimeMillis();
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(l3).append(xGLocalMessage.getMsgId()).append(context.getPackageName()).append(TextUtils.isEmpty((CharSequence)xGLocalMessage.getTitle()) ? "" : xGLocalMessage.getTitle()).append(TextUtils.isEmpty((CharSequence)xGLocalMessage.getContent()) ? "" : xGLocalMessage.getContent());
            String string = xGLocalMessage.getCustom_content();
            if (TextUtils.isEmpty((CharSequence)string) || new JSONObject(string).length() == 0) {
                string = "";
            }
            stringBuilder.append(string);
            if (xGLocalMessage.getType() == 1) {
                stringBuilder.append(TextUtils.isEmpty((CharSequence)xGLocalMessage.getUrl()) ? "" : xGLocalMessage.getUrl()).append(TextUtils.isEmpty((CharSequence)xGLocalMessage.getIntent()) ? "" : xGLocalMessage.getIntent()).append(TextUtils.isEmpty((CharSequence)xGLocalMessage.getActivity()) ? "" : xGLocalMessage.getActivity());
            }
            String string2 = stringBuilder.toString();
            String string3 = "tpush.local.msg." + com.tencent.android.tpush.encrypt.a.a(string2);
            long l5 = xGLocalMessage.getExpirationTimeMs();
            com.tencent.android.tpush.common.n.b(context, string3, l5);
            com.tencent.android.tpush.a.a.d("TPush", string2 + ",tag:" + string3 + ",exp:" + l5);
            TpnsPushMsg tpnsPushMsg = new TpnsPushMsg();
            tpnsPushMsg.msgId = xGLocalMessage.getMsgId();
            tpnsPushMsg.accessId = l3;
            tpnsPushMsg.appPkgName = context.getPackageName();
            tpnsPushMsg.busiMsgId = xGLocalMessage.getBusiMsgId();
            tpnsPushMsg.timestamp = l4 / 1000L;
            tpnsPushMsg.serverTime = -l4;
            tpnsPushMsg.ttl = xGLocalMessage.getTtl();
            tpnsPushMsg.type = xGLocalMessage.getType();
            tpnsPushMsg.multiPkg = 0L;
            tpnsPushMsg.date = xGLocalMessage.getDate();
            tpnsPushMsg.content = "{\"title\":\"" + xGLocalMessage.getTitle() + "\",\"content\":\"" + XGPushManager.a(xGLocalMessage.getContent()) + "\",\"builder_id\":" + xGLocalMessage.getBuilderId() + ",\"custom_content\":" + xGLocalMessage.getCustom_content() + ",\"ring\":" + xGLocalMessage.getRing() + ",\"vibrate\":" + xGLocalMessage.getVibrate() + ",\"lights\":" + xGLocalMessage.getLights() + ",\"n_id\":" + xGLocalMessage.getNotificationId() + ",\"ring_raw\":\"" + xGLocalMessage.getRing_raw() + "\",\"icon_type\":" + xGLocalMessage.getIcon_type() + ",\"icon_res\":\"" + xGLocalMessage.getIcon_res() + "\",\"style_id\":" + xGLocalMessage.getStyle_id() + ",\"small_icon\":\"" + xGLocalMessage.getSmall_icon() + "\",\"clearable\":1,\"accept_time\":[{\"start\":{\"hour\":\"" + xGLocalMessage.getHour() + "\",\"min\":\"" + xGLocalMessage.getMin() + "\"},\"end\":{\"hour\":\"23\",\"min\":\"59\"}}],\"action\":{\"action_type\":" + xGLocalMessage.getAction_type() + ",\"activity\":\"" + xGLocalMessage.getActivity() + "\",\"browser\":{\"url\":\"" + xGLocalMessage.getUrl() + "\"},\"intent\":\"" + xGLocalMessage.getIntent() + "\",\"package_name\":{\"packageDownloadUrl\":\"" + xGLocalMessage.getPackageDownloadUrl() + "\",\"packageName\":\"" + xGLocalMessage.getPackageName() + "\"}}}";
            com.tencent.android.tpush.service.channel.a a2 = new com.tencent.android.tpush.service.channel.a(0, "127.0.0.1");
            Intent intent = new Intent("com.tencent.android.tpush.action.INTERNAL_PUSH_MESSAGE");
            intent.setPackage(tpnsPushMsg.appPkgName);
            intent.putExtra("msgId", tpnsPushMsg.msgId);
            intent.putExtra("content", Rijndael.encrypt(tpnsPushMsg.content));
            intent.putExtra("date", tpnsPushMsg.date);
            intent.putExtra("type", tpnsPushMsg.type);
            intent.putExtra("accId", tpnsPushMsg.accessId);
            intent.putExtra("busiMsgId", tpnsPushMsg.busiMsgId);
            intent.putExtra("timestamps", tpnsPushMsg.timestamp);
            intent.putExtra("multiPkg", tpnsPushMsg.multiPkg);
            intent.putExtra("server_time", tpnsPushMsg.serverTime * 1000L);
            intent.putExtra("ttl", tpnsPushMsg.ttl);
            intent.putExtra("svrAck", true);
            intent.putExtra("extra_host", h.c(a2.d()));
            intent.putExtra("extra_port", a2.e());
            intent.putExtra("extra_pact", s.a(a2.b()));
            intent.putExtra("extra_push_time", l4);
            i.a(context).b(intent);
            return -l4;
        }
        catch (Throwable throwable) {
            com.tencent.android.tpush.a.a.c("TPush", "addLocalNotification ", throwable);
            return 0L;
        }
    }

    public static XGPushNotifactionCallback getNotifactionCallback() {
        return c;
    }

    public static void setNotifactionCallback(XGPushNotifactionCallback xGPushNotifactionCallback) {
        c = xGPushNotifactionCallback;
    }

    public static void clearLocalNotifications(Context context) {
        if (context == null) {
            com.tencent.android.tpush.a.a.h(a, "clearLocalNotifications  context==null.");
            return;
        }
        if (t.a(context) > 0) {
            return;
        }
        Context context2 = context.getApplicationContext();
        g.a().a(new ab(context2));
    }

    static void a(Context context, Intent intent) {
        long l2 = intent.getLongExtra("msgId", -1L);
        com.tencent.android.tpush.b.d.a().d(context, l2);
        Intent intent2 = new Intent("com.tencent.android.tpush.action.PUSH_CLICK.RESULT.V3");
        intent2.putExtras(intent);
        intent2.putExtra("packName", context.getPackageName());
        intent2.putExtra("clickTime", System.currentTimeMillis() / 1000L);
        com.tencent.android.tpush.service.d.a.d(context, intent2);
        context.sendBroadcast(intent2);
    }

    public static void onMessageClicked(Context context, XGPushTextMessage xGPushTextMessage) {
        XGPushManager.a(context, xGPushTextMessage.a(), "com.tencent.android.tpush.action.PUSH_CLICK.RESULT.V3");
    }

    public static void onMessageCleared(Context context, XGPushTextMessage xGPushTextMessage) {
        XGPushManager.a(context, xGPushTextMessage.a(), "com.tencent.android.tpush.action.PUSH_CANCELLED.RESULT.V3");
    }

    private static void a(Context context, Intent intent, String string) {
        if (context == null || intent == null || string == null) {
            return;
        }
        Intent intent2 = new Intent(string);
        intent2.putExtras(intent);
        if ("com.tencent.android.tpush.action.PUSH_CANCELLED.RESULT.V3".equals(string)) {
            intent2.putExtra("action", 2);
        }
        intent2.putExtra("packName", context.getPackageName());
        intent2.putExtra("clickTime", System.currentTimeMillis() / 1000L);
        com.tencent.android.tpush.service.d.a.d(context, intent2);
        context.sendBroadcast(intent2);
    }

    private static void c(Context context, Intent intent) {
        if (intent != null) {
            Intent intent2 = new Intent("com.tencent.android.tpush.action.FEEDBACK");
            intent2.setPackage(context.getPackageName());
            intent2.putExtra("TPUSH.FEEDBACK", 4);
            intent2.putExtra("TPUSH.ERRORCODE", 0);
            intent2.putExtras(intent);
            context.sendBroadcast(intent2);
        }
    }

    public static void onActivityStoped(Activity activity) {
        if (activity == null) {
            return;
        }
    }

    public static void setPushNotificationBuilder(Context context, int n2, XGPushNotificationBuilder xGPushNotificationBuilder) {
        if (context == null) {
            throw new IllegalArgumentException("context is null.");
        }
        if (n2 < 1 || n2 > 4096) {
            throw new IllegalArgumentException("notificationBulderId\u4e0d\u5728\u8303\u56f4[1, 4096].");
        }
        if (xGPushNotificationBuilder == null) {
            return;
        }
        com.tencent.android.tpush.b.b.a(context, n2, xGPushNotificationBuilder);
    }

    public static void setDefaultNotificationBuilder(Context context, XGPushNotificationBuilder xGPushNotificationBuilder) {
        if (context == null) {
            return;
        }
        if (xGPushNotificationBuilder == null) {
            return;
        }
        com.tencent.android.tpush.b.b.a(context, 0, xGPushNotificationBuilder);
    }

    public static XGPushNotificationBuilder getDefaultNotificationBuilder(Context context) {
        XGPushNotificationBuilder xGPushNotificationBuilder = XGPushManager.getNotificationBuilder(context, 0);
        if (xGPushNotificationBuilder == null) {
            com.tencent.android.tpush.b.b.a(context);
        }
        return xGPushNotificationBuilder;
    }

    public static XGPushNotificationBuilder getNotificationBuilder(Context context, int n2) {
        if (context == null) {
            Log.e((String)"TPush", (String)"getNotificationBuilder  context == null");
            return null;
        }
        return com.tencent.android.tpush.b.b.a(context, n2);
    }

    public static void cancelNotifaction(Context context, int n2) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cancelAllNotifaction(Context context) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancelAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void msgAck(Context context, n n2) {
        if (context != null && n2 != null) {
            if (XGPushConfig.enableDebug) {
                com.tencent.android.tpush.a.a.a(a, "Action -> msgAck(" + context.getPackageName() + "," + n2.b() + ")");
            }
            com.tencent.android.tpush.a.a.a(3, n2.b());
            if (n2.b() > 0L) {
                MessageId messageId = com.tencent.android.tpush.b.d.a().a(context, context.getPackageName(), n2.b());
                if (messageId == null) {
                    com.tencent.android.tpush.a.a.g(a, "Action -> msgAck(" + context.getPackageName() + "," + n2.b() + ")" + "error, no the id: " + n2.b());
                    return;
                }
                Intent intent = new Intent("com.tencent.android.tpush.action.MSG_ACK.V3");
                intent.putExtra("msgId", n2.b());
                intent.putExtra("packName", context.getPackageName());
                intent.putExtra("MessageId", (Serializable)messageId);
                context.sendBroadcast(intent);
            }
        }
    }

    public static String getServiceTag(Context context) {
        if (!TpnsSecurity.checkTpnsSecurityLibSo(context)) {
            return "xg_service_enable";
        }
        return Rijndael.encrypt(XGPushConfig.getAccessId(context) + "," + "xg_service_enable");
    }

    public static void enableService(Context context, boolean bl) {
        if (context == null) {
            return;
        }
        if (!bl) {
            com.tencent.android.tpush.a.a.h("TPush", "XG is disable.");
            XGPushManager.unregisterPush(context, new ac(context));
        }
        int n2 = enableService = bl ? 1 : 0;
        if (XGPushConfig.enableDebug) {
            com.tencent.android.tpush.a.a.e(a, "enableService=" + enableService);
        }
        m.a(context, context.getPackageName() + ENABLE_SERVICE_SUFFIX, enableService);
    }

    static void a(Context context, String string, String string2, int n2, String string3, XGIOperateCallback xGIOperateCallback, long l2, String string4) {
        XGPushManager.setContext(context);
        if (context == null) {
            xGIOperateCallback.onFail(null, 10001, "The context parameter can not be null!");
            return;
        }
        g.a().a(new ad(context, xGIOperateCallback, l2, string4, string, string2, string3, n2));
    }

    static void a(Context context, Intent intent, XGIOperateCallback xGIOperateCallback, boolean bl) {
        t.e(context);
        ag ag2 = new ag(context, intent, xGIOperateCallback);
        context.registerReceiver((BroadcastReceiver)ag2, new IntentFilter("com.tencent.android.tpush.action.SERVICE_START.V3"));
        ah ah2 = new ah(context, intent, xGIOperateCallback);
        try {
            d.put(ag2, ah2);
            g.a().a(ah2, 10000L);
        }
        catch (Exception exception) {
            com.tencent.android.tpush.a.a.c("TPush", "mapTimeRunnableOfMessage error", exception);
        }
    }

    private static synchronized void c(Context context, Intent intent, XGIOperateCallback xGIOperateCallback) {
        if (XGPushConfig.enableDebug) {
            com.tencent.android.tpush.a.a.e(a, "Action -> Register to xinge server");
        }
        if (xGIOperateCallback != null) {
            context.registerReceiver((BroadcastReceiver)new ae(xGIOperateCallback), new IntentFilter("com.tencent.android.tpush.action.REGISTER.RESULT.V3"));
        }
        context.sendBroadcast(intent);
    }

    private static void d(Context context, Intent intent, XGIOperateCallback xGIOperateCallback) {
        context.registerReceiver((BroadcastReceiver)new v(xGIOperateCallback), new IntentFilter("com.tencent.android.tpush.action.UNREGISTER.RESULT.V3"));
        context.sendBroadcast(intent);
    }

    private static String a(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '/': 
                case '\\': {
                    stringBuilder.append('\\').append(c2);
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                default: {
                    if (c2 <= '\u001f') {
                        stringBuilder.append(String.format("\\u%04x", c2));
                        continue block8;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ String a() {
        return a;
    }

    static /* synthetic */ void a(Context context, Intent intent, XGIOperateCallback xGIOperateCallback) {
        XGPushManager.d(context, intent, xGIOperateCallback);
    }

    static /* synthetic */ void b(Context context, Intent intent) {
        XGPushManager.c(context, intent);
    }

    static /* synthetic */ void b(Context context, Intent intent, XGIOperateCallback xGIOperateCallback) {
        XGPushManager.c(context, intent, xGIOperateCallback);
    }

    static /* synthetic */ Map b() {
        return d;
    }
}

