/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LazyReactPackage
implements ReactPackage {
    public static ReactModuleInfoProvider getReactModuleInfoProviderViaReflection(LazyReactPackage lazyReactPackage) {
        Class<?> reactModuleInfoProviderClass;
        try {
            reactModuleInfoProviderClass = Class.forName(lazyReactPackage.getClass().getCanonicalName() + "$$ReactModuleInfoProvider");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (reactModuleInfoProviderClass == null) {
            throw new RuntimeException("ReactModuleInfoProvider class for " + lazyReactPackage.getClass().getCanonicalName() + " not found.");
        }
        try {
            return (ReactModuleInfoProvider)reactModuleInfoProviderClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate ReactModuleInfoProvider for " + lazyReactPackage.getClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate ReactModuleInfoProvider for " + lazyReactPackage.getClass(), e);
        }
    }

    public abstract List<ModuleSpec> getNativeModules(ReactApplicationContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<NativeModule> createNativeModules(ReactApplicationContext reactContext) {
        ArrayList<NativeModule> modules = new ArrayList<NativeModule>();
        for (ModuleSpec holder : this.getNativeModules(reactContext)) {
            NativeModule nativeModule;
            SystraceMessage.beginSection(0L, "createNativeModule").arg("module", holder.getType()).flush();
            try {
                ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_START, holder.getType().getSimpleName());
                nativeModule = (NativeModule)holder.getProvider().get();
                ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_END);
            }
            finally {
                Systrace.endSection(0L);
            }
            modules.add(nativeModule);
        }
        return modules;
    }

    public List<ModuleSpec> getViewManagers(ReactApplicationContext reactContext) {
        return Collections.emptyList();
    }

    @Override
    public List<ViewManager> createViewManagers(ReactApplicationContext reactContext) {
        List<ModuleSpec> viewManagerModuleSpecs = this.getViewManagers(reactContext);
        if (viewManagerModuleSpecs == null || viewManagerModuleSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ViewManager> viewManagers = new ArrayList<ViewManager>();
        for (ModuleSpec moduleSpec : viewManagerModuleSpecs) {
            viewManagers.add((ViewManager)moduleSpec.getProvider().get());
        }
        return viewManagers;
    }

    public abstract ReactModuleInfoProvider getReactModuleInfoProvider();
}

