/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import javax.annotation.Nullable;

public class ReactRootView
extends SizeMonitoringFrameLayout
implements RootView {
    @Nullable
    private ReactInstanceManager mReactInstanceManager;
    @Nullable
    private String mJSModuleName;
    @Nullable
    private Bundle mLaunchOptions;
    @Nullable
    private CustomGlobalLayoutListener mCustomGlobalLayoutListener;
    @Nullable
    private ReactRootViewEventListener mRootViewEventListener;
    private int mRootViewTag;
    private boolean mWasMeasured = false;
    private boolean mIsAttachedToInstance = false;
    private final JSTouchDispatcher mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);

    public ReactRootView(Context context) {
        super(context);
    }

    public ReactRootView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ReactRootView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.mWasMeasured = true;
        if (this.mReactInstanceManager != null && !this.mIsAttachedToInstance) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ReactRootView.this.attachToReactInstanceManager();
                }
            });
        }
    }

    @Override
    public void onChildStartedNativeGesture(MotionEvent androidEvent) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"React", (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mJSTouchDispatcher.onChildStartedNativeGesture(androidEvent, eventDispatcher);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.dispatchJSTouchEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.dispatchJSTouchEvent(ev);
        super.onTouchEvent(ev);
        return true;
    }

    private void dispatchJSTouchEvent(MotionEvent event) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"React", (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mJSTouchDispatcher.handleTouchEvent(event, eventDispatcher);
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIsAttachedToInstance) {
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIsAttachedToInstance) {
            this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName) {
        this.startReactApplication(reactInstanceManager, moduleName, null);
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName, @Nullable Bundle launchOptions) {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((this.mReactInstanceManager == null ? 1 : 0) != 0, (String)"This root view has already been attached to a catalyst instance manager");
        this.mReactInstanceManager = reactInstanceManager;
        this.mJSModuleName = moduleName;
        this.mLaunchOptions = launchOptions;
        if (!this.mReactInstanceManager.hasStartedCreatingInitialContext()) {
            this.mReactInstanceManager.createReactContextInBackground();
        }
        if (this.mWasMeasured) {
            this.attachToReactInstanceManager();
        }
    }

    public void unmountReactApplication() {
        if (this.mReactInstanceManager != null && this.mIsAttachedToInstance) {
            this.mReactInstanceManager.detachRootView(this);
            this.mIsAttachedToInstance = false;
        }
    }

    public void onAttachedToReactInstance() {
        if (this.mRootViewEventListener != null) {
            this.mRootViewEventListener.onAttachedToReactInstance(this);
        }
    }

    public void setEventListener(ReactRootViewEventListener eventListener) {
        this.mRootViewEventListener = eventListener;
    }

    String getJSModuleName() {
        return (String)Assertions.assertNotNull((Object)this.mJSModuleName);
    }

    @Nullable
    Bundle getLaunchOptions() {
        return this.mLaunchOptions;
    }

    @VisibleForTesting
    void simulateAttachForTesting() {
        this.mIsAttachedToInstance = true;
        this.mWasMeasured = true;
    }

    private CustomGlobalLayoutListener getCustomGlobalLayoutListener() {
        if (this.mCustomGlobalLayoutListener == null) {
            this.mCustomGlobalLayoutListener = new CustomGlobalLayoutListener();
        }
        return this.mCustomGlobalLayoutListener;
    }

    private void attachToReactInstanceManager() {
        if (this.mIsAttachedToInstance) {
            return;
        }
        this.mIsAttachedToInstance = true;
        ((ReactInstanceManager)Assertions.assertNotNull((Object)this.mReactInstanceManager)).attachMeasuredRootView(this);
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Assertions.assertCondition((!this.mIsAttachedToInstance ? 1 : 0) != 0, (String)"The application this ReactRootView was rendering was not unmounted before the ReactRootView was garbage collected. This usually means that your application is leaking large amounts of memory. To solve this, make sure to call ReactRootView#unmountReactApplication in the onDestroy() of your hosting Activity or in the onDestroyView() of your hosting Fragment.");
    }

    public int getRootViewTag() {
        return this.mRootViewTag;
    }

    public void setRootViewTag(int rootViewTag) {
        this.mRootViewTag = rootViewTag;
    }

    private class CustomGlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final Rect mVisibleViewArea = new Rect();
        private final int mMinKeyboardHeightDetected = (int)PixelUtil.toPixelFromDIP(60.0f);
        private int mKeyboardHeight = 0;
        private int mDeviceRotation = 0;

        CustomGlobalLayoutListener() {
        }

        public void onGlobalLayout() {
            if (ReactRootView.this.mReactInstanceManager == null || !ReactRootView.this.mIsAttachedToInstance || ReactRootView.this.mReactInstanceManager.getCurrentReactContext() == null) {
                return;
            }
            this.checkForKeyboardEvents();
            this.checkForDeviceOrientationChanges();
        }

        private void checkForKeyboardEvents() {
            ReactRootView.this.getRootView().getWindowVisibleDisplayFrame(this.mVisibleViewArea);
            int heightDiff = DisplayMetricsHolder.getWindowDisplayMetrics().heightPixels - this.mVisibleViewArea.bottom;
            if (this.mKeyboardHeight != heightDiff && heightDiff > this.mMinKeyboardHeightDetected) {
                this.mKeyboardHeight = heightDiff;
                WritableMap params = Arguments.createMap();
                WritableMap coordinates = Arguments.createMap();
                coordinates.putDouble("screenY", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.bottom));
                coordinates.putDouble("screenX", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.left));
                coordinates.putDouble("width", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()));
                coordinates.putDouble("height", PixelUtil.toDIPFromPixel(this.mKeyboardHeight));
                params.putMap("endCoordinates", coordinates);
                this.sendEvent("keyboardDidShow", params);
            } else if (this.mKeyboardHeight != 0 && heightDiff <= this.mMinKeyboardHeightDetected) {
                this.mKeyboardHeight = 0;
                this.sendEvent("keyboardDidHide", null);
            }
        }

        private void checkForDeviceOrientationChanges() {
            int rotation = ((WindowManager)ReactRootView.this.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
            if (this.mDeviceRotation == rotation) {
                return;
            }
            this.mDeviceRotation = rotation;
            DisplayMetricsHolder.initDisplayMetrics(ReactRootView.this.getContext());
            this.emitUpdateDimensionsEvent();
            this.emitOrientationChanged(rotation);
        }

        private void emitOrientationChanged(int newRotation) {
            double rotationDegrees;
            String name;
            boolean isLandscape = false;
            switch (newRotation) {
                case 0: {
                    name = "portrait-primary";
                    rotationDegrees = 0.0;
                    break;
                }
                case 1: {
                    name = "landscape-primary";
                    rotationDegrees = -90.0;
                    isLandscape = true;
                    break;
                }
                case 2: {
                    name = "portrait-secondary";
                    rotationDegrees = 180.0;
                    break;
                }
                case 3: {
                    name = "landscape-secondary";
                    rotationDegrees = 90.0;
                    isLandscape = true;
                    break;
                }
                default: {
                    return;
                }
            }
            WritableMap map = Arguments.createMap();
            map.putString("name", name);
            map.putDouble("rotationDegrees", rotationDegrees);
            map.putBoolean("isLandscape", isLandscape);
            this.sendEvent("namedOrientationDidChange", map);
        }

        private void emitUpdateDimensionsEvent() {
            ReactRootView.this.mReactInstanceManager.getCurrentReactContext().getNativeModule(DeviceInfoModule.class).emitUpdateDimensionsEvent();
        }

        private void sendEvent(String eventName, @Nullable WritableMap params) {
            if (ReactRootView.this.mReactInstanceManager != null) {
                ReactRootView.this.mReactInstanceManager.getCurrentReactContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, params);
            }
        }
    }

    public static interface ReactRootViewEventListener {
        public void onAttachedToReactInstance(ReactRootView var1);
    }
}

