'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
// ACTIONS project
var NEW_PROJECT = exports.NEW_PROJECT = 'NEW_PROJECT';
var LOAD_PROJECT = exports.LOAD_PROJECT = 'LOAD_PROJECT';
var SAVE_PROJECT = exports.SAVE_PROJECT = 'SAVE_PROJECT';
var OPEN_CATALOG = exports.OPEN_CATALOG = 'OPEN_CATALOG';
var SELECT_TOOL_EDIT = exports.SELECT_TOOL_EDIT = 'SELECT_TOOL_EDIT';
var UNSELECT_ALL = exports.UNSELECT_ALL = 'UNSELECT_ALL';
var SET_PROPERTIES = exports.SET_PROPERTIES = 'SET_PROPERTIES';
var SET_ITEMS_ATTRIBUTES = exports.SET_ITEMS_ATTRIBUTES = 'SET_ITEMS_ATTRIBUTES';
var SET_LINES_ATTRIBUTES = exports.SET_LINES_ATTRIBUTES = 'SET_LINES_ATTRIBUTES';
var SET_HOLES_ATTRIBUTES = exports.SET_HOLES_ATTRIBUTES = 'SET_HOLES_ATTRIBUTES';
var REMOVE = exports.REMOVE = 'REMOVE';
var UNDO = exports.UNDO = 'UNDO';
var ROLLBACK = exports.ROLLBACK = 'ROLLBACK';
var SET_PROJECT_PROPERTIES = exports.SET_PROJECT_PROPERTIES = 'SET_PROJECT_PROPERTIES';
var OPEN_PROJECT_CONFIGURATOR = exports.OPEN_PROJECT_CONFIGURATOR = 'OPEN_PROJECT_CONFIGURATOR';
var INIT_CATALOG = exports.INIT_CATALOG = 'INIT_CATALOG';
var UPDATE_MOUSE_COORDS = exports.UPDATE_MOUSE_COORDS = 'UPDATE_MOUSE_COORDS';
var UPDATE_ZOOM_SCALE = exports.UPDATE_ZOOM_SCALE = 'UPDATE_ZOOM_SCALE';
var TOGGLE_SNAP = exports.TOGGLE_SNAP = 'TOGGLE_SNAP';
var CHANGE_CATALOG_PAGE = exports.CHANGE_CATALOG_PAGE = 'CHANGE_CATALOG_PAGE';
var GO_BACK_TO_CATALOG_PAGE = exports.GO_BACK_TO_CATALOG_PAGE = 'GO_BACK_TO_CATALOG_PAGE';
var THROW_ERROR = exports.THROW_ERROR = 'THROW_ERROR';
var THROW_WARNING = exports.THROW_WARNING = 'THROW_WARNING';
var COPY_PROPERTIES = exports.COPY_PROPERTIES = 'COPY_PROPERTIES';
var PASTE_PROPERTIES = exports.PASTE_PROPERTIES = 'PASTE_PROPERTIES';

// ACTIONS viewer2D
var SELECT_TOOL_ZOOM_IN = exports.SELECT_TOOL_ZOOM_IN = 'SELECT_TOOL_ZOOM_IN';
var SELECT_TOOL_ZOOM_OUT = exports.SELECT_TOOL_ZOOM_OUT = 'SELECT_TOOL_ZOOM_OUT';
var SELECT_TOOL_PAN = exports.SELECT_TOOL_PAN = 'SELECT_TOOL_PAN';
var UPDATE_2D_CAMERA = exports.UPDATE_2D_CAMERA = 'UPDATE_2D_CAMERA';

//ACTIONS viewer3D
var SELECT_TOOL_3D_VIEW = exports.SELECT_TOOL_3D_VIEW = 'SELECT_TOOL_3D_VIEW';
var SELECT_TOOL_3D_FIRST_PERSON = exports.SELECT_TOOL_3D_FIRST_PERSON = 'SELECT_TOOL_3D_FIRST_PERSON';

//ACTIONS items
var SELECT_TOOL_DRAWING_ITEM = exports.SELECT_TOOL_DRAWING_ITEM = 'SELECT_TOOL_DRAWING_ITEM';
var UPDATE_DRAWING_ITEM = exports.UPDATE_DRAWING_ITEM = 'UPDATE_DRAWING_ITEM';
var END_DRAWING_ITEM = exports.END_DRAWING_ITEM = 'END_DRAWING_ITEM';
var BEGIN_DRAGGING_ITEM = exports.BEGIN_DRAGGING_ITEM = 'BEGIN_DRAGGING_ITEM';
var UPDATE_DRAGGING_ITEM = exports.UPDATE_DRAGGING_ITEM = 'UPDATE_DRAGGING_ITEM';
var END_DRAGGING_ITEM = exports.END_DRAGGING_ITEM = 'END_DRAGGING_ITEM';
var BEGIN_ROTATING_ITEM = exports.BEGIN_ROTATING_ITEM = 'BEGIN_ROTATING_ITEM';
var UPDATE_ROTATING_ITEM = exports.UPDATE_ROTATING_ITEM = 'UPDATE_ROTATING_ITEM';
var END_ROTATING_ITEM = exports.END_ROTATING_ITEM = 'END_ROTATING_ITEM';

//ACTION drawings
var SELECT_HOLE = exports.SELECT_HOLE = 'SELECT_HOLE';
var SELECT_AREA = exports.SELECT_AREA = 'SELECT_AREA';
var SELECT_ITEM = exports.SELECT_ITEM = 'SELECT_ITEM';
var SELECT_LINE = exports.SELECT_LINE = 'SELECT_LINE';
var SELECT_TOOL_DRAWING_LINE = exports.SELECT_TOOL_DRAWING_LINE = 'SELECT_TOOL_DRAWING_LINE';
var BEGIN_DRAWING_LINE = exports.BEGIN_DRAWING_LINE = 'BEGIN_DRAWING_LINE';
var UPDATE_DRAWING_LINE = exports.UPDATE_DRAWING_LINE = 'UPDATE_DRAWING_LINE';
var END_DRAWING_LINE = exports.END_DRAWING_LINE = 'END_DRAWING_LINE';
var SELECT_TOOL_DRAWING_HOLE = exports.SELECT_TOOL_DRAWING_HOLE = 'SELECT_TOOL_DRAWING_HOLE';
var UPDATE_DRAWING_HOLE = exports.UPDATE_DRAWING_HOLE = 'UPDATE_DRAWING_HOLE';
var END_DRAWING_HOLE = exports.END_DRAWING_HOLE = 'END_DRAWING_HOLE';
var BEGIN_DRAGGING_LINE = exports.BEGIN_DRAGGING_LINE = 'BEGIN_DRAGGING_LINE';
var UPDATE_DRAGGING_LINE = exports.UPDATE_DRAGGING_LINE = 'UPDATE_DRAGGING_LINE';
var END_DRAGGING_LINE = exports.END_DRAGGING_LINE = 'END_DRAGGING_LINE';
var SELECT_TOOL_UPLOAD_IMAGE = exports.SELECT_TOOL_UPLOAD_IMAGE = 'SELECT_TOOL_UPLOAD_IMAGE';
var BEGIN_UPLOADING_IMAGE = exports.BEGIN_UPLOADING_IMAGE = 'BEGIN_UPLOADING_IMAGE';
var END_UPLOADING_IMAGE = exports.END_UPLOADING_IMAGE = 'END_UPLOADING_IMAGE';
var BEGIN_FITTING_IMAGE = exports.BEGIN_FITTING_IMAGE = 'BEGIN_FITTING_IMAGE';
var END_FITTING_IMAGE = exports.END_FITTING_IMAGE = 'END_FITTING_IMAGE';
var BEGIN_DRAGGING_HOLE = exports.BEGIN_DRAGGING_HOLE = 'BEGIN_DRAGGING_HOLE';
var UPDATE_DRAGGING_HOLE = exports.UPDATE_DRAGGING_HOLE = 'UPDATE_DRAGGING_HOLE';
var END_DRAGGING_HOLE = exports.END_DRAGGING_HOLE = 'END_DRAGGING_HOLE';

//ACTIONS vertices
var BEGIN_DRAGGING_VERTEX = exports.BEGIN_DRAGGING_VERTEX = 'BEGIN_DRAGGING_VERTEX';
var UPDATE_DRAGGING_VERTEX = exports.UPDATE_DRAGGING_VERTEX = 'UPDATE_DRAGGING_VERTEX';
var END_DRAGGING_VERTEX = exports.END_DRAGGING_VERTEX = 'END_DRAGGING_VERTEX';

//ACTIONS scene
var SET_LAYER_PROPERTIES = exports.SET_LAYER_PROPERTIES = 'SET_LAYER_PROPERTIES';
var ADD_LAYER = exports.ADD_LAYER = 'ADD_LAYER';
var SELECT_LAYER = exports.SELECT_LAYER = 'SELECT_LAYER';
var REMOVE_LAYER = exports.REMOVE_LAYER = 'REMOVE_LAYER';

//GROUPING ACTIONS
var PROJECT_ACTIONS = exports.PROJECT_ACTIONS = {
  NEW_PROJECT: NEW_PROJECT,
  LOAD_PROJECT: LOAD_PROJECT,
  SAVE_PROJECT: SAVE_PROJECT,
  OPEN_CATALOG: OPEN_CATALOG,
  SELECT_TOOL_EDIT: SELECT_TOOL_EDIT,
  UNSELECT_ALL: UNSELECT_ALL,
  SET_PROPERTIES: SET_PROPERTIES,
  SET_ITEMS_ATTRIBUTES: SET_ITEMS_ATTRIBUTES,
  SET_LINES_ATTRIBUTES: SET_LINES_ATTRIBUTES,
  SET_HOLES_ATTRIBUTES: SET_HOLES_ATTRIBUTES,
  REMOVE: REMOVE,
  UNDO: UNDO,
  ROLLBACK: ROLLBACK,
  SET_PROJECT_PROPERTIES: SET_PROJECT_PROPERTIES,
  OPEN_PROJECT_CONFIGURATOR: OPEN_PROJECT_CONFIGURATOR,
  INIT_CATALOG: INIT_CATALOG,
  UPDATE_MOUSE_COORDS: UPDATE_MOUSE_COORDS,
  UPDATE_ZOOM_SCALE: UPDATE_ZOOM_SCALE,
  TOGGLE_SNAP: TOGGLE_SNAP,
  CHANGE_CATALOG_PAGE: CHANGE_CATALOG_PAGE,
  GO_BACK_TO_CATALOG_PAGE: GO_BACK_TO_CATALOG_PAGE,
  THROW_ERROR: THROW_ERROR,
  THROW_WARNING: THROW_WARNING,
  COPY_PROPERTIES: COPY_PROPERTIES,
  PASTE_PROPERTIES: PASTE_PROPERTIES
};

var VIEWER2D_ACTIONS = exports.VIEWER2D_ACTIONS = {
  SELECT_TOOL_ZOOM_IN: SELECT_TOOL_ZOOM_IN,
  SELECT_TOOL_ZOOM_OUT: SELECT_TOOL_ZOOM_OUT,
  SELECT_TOOL_PAN: SELECT_TOOL_PAN,
  UPDATE_2D_CAMERA: UPDATE_2D_CAMERA
};

var VIEWER3D_ACTIONS = exports.VIEWER3D_ACTIONS = {
  SELECT_TOOL_3D_VIEW: SELECT_TOOL_3D_VIEW,
  SELECT_TOOL_3D_FIRST_PERSON: SELECT_TOOL_3D_FIRST_PERSON
};

var ITEMS_ACTIONS = exports.ITEMS_ACTIONS = {
  SELECT_ITEM: SELECT_ITEM,
  SELECT_TOOL_DRAWING_ITEM: SELECT_TOOL_DRAWING_ITEM,
  UPDATE_DRAWING_ITEM: UPDATE_DRAWING_ITEM,
  END_DRAWING_ITEM: END_DRAWING_ITEM,
  BEGIN_DRAGGING_ITEM: BEGIN_DRAGGING_ITEM,
  UPDATE_DRAGGING_ITEM: UPDATE_DRAGGING_ITEM,
  END_DRAGGING_ITEM: END_DRAGGING_ITEM,
  BEGIN_ROTATING_ITEM: BEGIN_ROTATING_ITEM,
  UPDATE_ROTATING_ITEM: UPDATE_ROTATING_ITEM,
  END_ROTATING_ITEM: END_ROTATING_ITEM
};

var HOLE_ACTIONS = exports.HOLE_ACTIONS = {
  SELECT_HOLE: SELECT_HOLE,
  SELECT_TOOL_DRAWING_HOLE: SELECT_TOOL_DRAWING_HOLE,
  UPDATE_DRAWING_HOLE: UPDATE_DRAWING_HOLE,
  END_DRAWING_HOLE: END_DRAWING_HOLE,
  BEGIN_DRAGGING_HOLE: BEGIN_DRAGGING_HOLE,
  UPDATE_DRAGGING_HOLE: UPDATE_DRAGGING_HOLE,
  END_DRAGGING_HOLE: END_DRAGGING_HOLE
};

var LINE_ACTIONS = exports.LINE_ACTIONS = {
  SELECT_LINE: SELECT_LINE,
  SELECT_TOOL_DRAWING_LINE: SELECT_TOOL_DRAWING_LINE,
  BEGIN_DRAWING_LINE: BEGIN_DRAWING_LINE,
  UPDATE_DRAWING_LINE: UPDATE_DRAWING_LINE,
  END_DRAWING_LINE: END_DRAWING_LINE,
  BEGIN_DRAGGING_LINE: BEGIN_DRAGGING_LINE,
  UPDATE_DRAGGING_LINE: UPDATE_DRAGGING_LINE,
  END_DRAGGING_LINE: END_DRAGGING_LINE
};

var AREA_ACTIONS = exports.AREA_ACTIONS = {
  SELECT_AREA: SELECT_AREA
};

var SCENE_ACTIONS = exports.SCENE_ACTIONS = {
  ADD_LAYER: ADD_LAYER,
  SET_LAYER_PROPERTIES: SET_LAYER_PROPERTIES,
  SELECT_LAYER: SELECT_LAYER,
  REMOVE_LAYER: REMOVE_LAYER
};

var VERTEX_ACTIONS = exports.VERTEX_ACTIONS = {
  BEGIN_DRAGGING_VERTEX: BEGIN_DRAGGING_VERTEX,
  UPDATE_DRAGGING_VERTEX: UPDATE_DRAGGING_VERTEX,
  END_DRAGGING_VERTEX: END_DRAGGING_VERTEX
};

//MODES
var MODE_IDLE = exports.MODE_IDLE = 'MODE_IDLE';
var MODE_2D_ZOOM_IN = exports.MODE_2D_ZOOM_IN = 'MODE_2D_ZOOM_IN';
var MODE_2D_ZOOM_OUT = exports.MODE_2D_ZOOM_OUT = 'MODE_2D_ZOOM_OUT';
var MODE_2D_PAN = exports.MODE_2D_PAN = 'MODE_2D_PAN';
var MODE_3D_VIEW = exports.MODE_3D_VIEW = 'MODE_3D_VIEW';
var MODE_3D_FIRST_PERSON = exports.MODE_3D_FIRST_PERSON = 'MODE_3D_FIRST_PERSON';
var MODE_WAITING_DRAWING_LINE = exports.MODE_WAITING_DRAWING_LINE = 'MODE_WAITING_DRAWING_LINE';
var MODE_DRAGGING_LINE = exports.MODE_DRAGGING_LINE = 'MODE_DRAGGING_LINE';
var MODE_DRAGGING_VERTEX = exports.MODE_DRAGGING_VERTEX = 'MODE_DRAGGING_VERTEX';
var MODE_DRAGGING_ITEM = exports.MODE_DRAGGING_ITEM = 'MODE_DRAGGING_ITEM';
var MODE_DRAGGING_HOLE = exports.MODE_DRAGGING_HOLE = 'MODE_DRAGGING_HOLE';
var MODE_DRAWING_LINE = exports.MODE_DRAWING_LINE = 'MODE_DRAWING_LINE';
var MODE_DRAWING_HOLE = exports.MODE_DRAWING_HOLE = 'MODE_DRAWING_HOLE';
var MODE_DRAWING_ITEM = exports.MODE_DRAWING_ITEM = 'MODE_DRAWING_ITEM';
var MODE_ROTATING_ITEM = exports.MODE_ROTATING_ITEM = 'MODE_ROTATING_ITEM';
var MODE_UPLOADING_IMAGE = exports.MODE_UPLOADING_IMAGE = 'MODE_UPLOADING_IMAGE';
var MODE_FITTING_IMAGE = exports.MODE_FITTING_IMAGE = 'MODE_FITTING_IMAGE';
var MODE_VIEWING_CATALOG = exports.MODE_VIEWING_CATALOG = 'MODE_VIEWING_CATALOG';
var MODE_CONFIGURING_PROJECT = exports.MODE_CONFIGURING_PROJECT = 'MODE_CONFIGURING_PROJECT';

//Thinking about it...
//https://developer.mozilla.org/it/docs/Web/JavaScript/Reference/Global_Objects/Proxy
/*
let MODE_DEF = [
  'IDLE',
  '2D_ZOOM_IN',
  '2D_ZOOM_OUT',
  '2D_PAN',
  '3D_VIEW',
  '3D_FIRST_PERSON',
  'WAITING_DRAWING_LINE',
  'DRAGGING_LINE',
  'DRAGGING_VERTEX',
  'DRAGGING_ITEM',
  'DRAGGING_HOLE',
  'DRAWING_LINE',
  'DRAWING_HOLE',
  'DRAWING_ITEM',
  'ROTATING_ITEM',
  'UPLOADING_IMAGE',
  'FITTING_IMAGE',
  'VIEWING_CATALOG',
  'CONFIGURING_PROJECT',
];

export const MODE = new Proxy( MODE_DEF, { get: (target, name) => { return target.indexOf(name) !== -1 ? name : null } } );
*/

var MODE_SNAPPING = exports.MODE_SNAPPING = [MODE_IDLE, MODE_2D_ZOOM_IN, MODE_2D_ZOOM_OUT, MODE_2D_PAN, MODE_WAITING_DRAWING_LINE, MODE_DRAWING_LINE, MODE_DRAWING_HOLE, MODE_DRAWING_ITEM, MODE_DRAGGING_LINE, MODE_DRAGGING_VERTEX, MODE_DRAGGING_ITEM, MODE_DRAGGING_HOLE, MODE_FITTING_IMAGE, MODE_UPLOADING_IMAGE, MODE_ROTATING_ITEM];

//UNITS
var UNIT_MILLIMETER = exports.UNIT_MILLIMETER = 'mm';
var UNIT_CENTIMETER = exports.UNIT_CENTIMETER = 'cm';
var UNIT_METER = exports.UNIT_METER = 'm';
var UNIT_INCH = exports.UNIT_INCH = 'in';
var UNIT_FOOT = exports.UNIT_FOOT = 'ft';
var UNIT_MILE = exports.UNIT_MILE = 'mi';

var UNITS_LENGTH = exports.UNITS_LENGTH = [UNIT_MILLIMETER, UNIT_CENTIMETER, UNIT_METER, UNIT_INCH, UNIT_FOOT, UNIT_MILE];

var EPSILON = exports.EPSILON = 1e-6;