/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.ant.ResultFormatter;
import com.googlecode.jslint4java.formatter.ReportFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class ReportResultFormatter
implements ResultFormatter {
    private final ReportFormatter formatter = new ReportFormatter();
    private OutputStream out;
    private final StringBuilder sb = new StringBuilder();

    public void begin() {
        if (this.out == null) {
            throw new BuildException("destFile not specified");
        }
        if (this.formatter.header() != null) {
            this.sb.append(this.formatter.header());
        }
    }

    public void end() {
        if (this.formatter.footer() != null) {
            this.sb.append(this.formatter.footer());
        }
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
            w.write(this.sb.toString());
            ((Writer)w).flush();
        }
        catch (IOException exc) {
            try {
                throw new BuildException("Unable to write log file", (Throwable)exc);
            }
            catch (Throwable throwable) {
                FileUtils.close(w);
                throw throwable;
            }
        }
        FileUtils.close((Writer)w);
        this.out = null;
        this.sb.delete(0, this.sb.length() - 1);
    }

    public void output(JSLintResult result) {
        this.sb.append(this.formatter.format(result));
    }

    public void setFile(File file) {
        try {
            this.out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setStdout(OutputStream defaultOutputStream) {
    }
}

