/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.ant.ResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintXmlFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class XmlResultFormatter
implements ResultFormatter {
    private final JSLintResultFormatter form = new JSLintXmlFormatter();
    private final StringBuilder sb = new StringBuilder();
    private OutputStream out;

    public void begin() {
        if (this.out == null) {
            throw new BuildException("must specify destFile for xml output");
        }
        if (this.sb.length() > 0) {
            this.sb.delete(0, this.sb.length() - 1);
        }
        this.sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        this.sb.append("<jslint>\n");
    }

    public void end() {
        this.sb.append("</jslint>");
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
            w.write(this.sb.toString());
            ((Writer)w).flush();
        }
        catch (IOException exc) {
            try {
                throw new BuildException("Unable to write log file", (Throwable)exc);
            }
            catch (Throwable throwable) {
                FileUtils.close(w);
                throw throwable;
            }
        }
        FileUtils.close((Writer)w);
        this.out = null;
    }

    public void output(JSLintResult result) {
        this.sb.append(this.form.format(result));
    }

    public void setFile(File file) {
        try {
            this.out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setStdout(OutputStream defaultOutputStream) {
    }
}

