/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.Util;
import org.mozilla.javascript.Scriptable;

public class Issue {
    private final String a;
    private final String b;
    private final String c;
    private final int character;
    private final String d;
    private final String evidence;
    private final int line;
    private final String raw;
    private final String reason;
    private final String systemId;

    private Issue(IssueBuilder ib) {
        this.systemId = ib.systemId;
        this.reason = ib.reason;
        this.line = ib.line;
        this.character = ib.character;
        this.evidence = ib.evidence;
        this.raw = ib.raw;
        this.a = ib.a;
        this.b = ib.b;
        this.c = ib.c;
        this.d = ib.d;
    }

    public String getA() {
        return this.a;
    }

    public String getB() {
        return this.b;
    }

    public String getC() {
        return this.c;
    }

    public int getCharacter() {
        return this.character;
    }

    public String getD() {
        return this.d;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public int getLine() {
        return this.line;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String toString() {
        return this.getSystemId() + ":" + this.getLine() + ":" + this.getCharacter() + ":" + this.getReason();
    }

    public static class IssueBuilder {
        private String a;
        private String b;
        private String c;
        private final int character;
        private String d;
        private String evidence;
        private final int line;
        private String raw;
        private final String reason;
        private final String systemId;

        public static Issue fromJavaScript(String systemId, Scriptable err) {
            int line = Util.intValue("line", err);
            int col = Util.intValue("character", err);
            return new IssueBuilder(systemId, line, col, Util.stringValue("reason", err)).evidence(Util.stringValue("evidence", err)).raw(Util.stringValue("raw", err)).a(Util.stringValue("a", err)).b(Util.stringValue("b", err)).c(Util.stringValue("c", err)).d(Util.stringValue("d", err)).build();
        }

        public IssueBuilder(String systemId, int line, int character, String reason) {
            this.character = character;
            this.line = line;
            this.reason = reason;
            this.systemId = systemId;
        }

        public Issue build() {
            return new Issue(this);
        }

        public IssueBuilder a(String a) {
            this.a = a;
            return this;
        }

        public IssueBuilder b(String b) {
            this.b = b;
            return this;
        }

        public IssueBuilder c(String c) {
            this.c = c;
            return this;
        }

        public IssueBuilder d(String d) {
            this.d = d;
            return this;
        }

        public IssueBuilder evidence(String evidence) {
            this.evidence = evidence;
            return this;
        }

        public IssueBuilder raw(String raw) {
            this.raw = raw;
            return this;
        }
    }
}

