/**
 * Copyright (c) 2014, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */

'use strict';




const fs = require('fs');

module.exports = (
filePath,
hasteFS) =>
{
  if (hasteFS && hasteFS.exists(filePath)) {
    return true;
  }

  try {
    return fs.statSync(filePath).isFile();
  } catch (e) {}
  return false;
};