/**
 * Copyright (c) 2014, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */

'use strict';












const matchers = require('./matchers');
const spyMatchers = require('./spyMatchers');
const toThrowMatchers = require('./toThrowMatchers');var _require =

require('jest-matcher-utils');const stringify = _require.stringify;

const GLOBAL_STATE = Symbol.for('$$jest-matchers-object');

class JestAssertionError extends Error {}

if (!global[GLOBAL_STATE]) {
  Object.defineProperty(
  global,
  GLOBAL_STATE,
  { value: { matchers: Object.create(null), state: { suppressedErrors: [] } } });

}

const expect = actual => {
  const allMatchers = global[GLOBAL_STATE].matchers;
  const expectation = { not: {} };
  Object.keys(allMatchers).forEach(name => {
    expectation[name] =
    makeThrowingMatcher(allMatchers[name], false, actual);
    expectation.not[name] =
    makeThrowingMatcher(allMatchers[name], true, actual);
  });

  return expectation;
};

const makeThrowingMatcher = (
matcher,
isNot,
actual) =>
{
  return function throwingMatcher() {
    let throws = true;
    const matcherContext = Object.assign(
    // When throws is disabled, the matcher will not throw errors during test
    // execution but instead add them to the global matcher state. If a
    // matcher throws, test execution is normally stopped immediately. The
    // snapshot matcher uses it because we want to log all snapshot
    // failures in a test.
    { dontThrow: () => throws = false },
    global[GLOBAL_STATE].state,
    { isNot });

    let result;

    try {for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {args[_key] = arguments[_key];}
      result = matcher.apply(
      matcherContext,
      [actual].concat(args));

    } catch (error) {
      // Remove this and deeper functions from the stack trace frame.
      Error.captureStackTrace(error, throwingMatcher);
      throw error;
    }

    _validateResult(result);

    if (result.pass && isNot || !result.pass && !isNot) {// XOR
      let message = result.message;

      // for performance reasons some of the messages are evaluated
      // lazily
      if (typeof message === 'function') {
        message = message();
      }

      const error = new JestAssertionError(message);
      // Remove this function from the stack trace frame.
      Error.captureStackTrace(error, throwingMatcher);

      if (throws) {
        throw error;
      } else {
        global[GLOBAL_STATE].state.suppressedErrors.push(error);
      }
    }
  };
};

const addMatchers = matchersObj => {
  Object.assign(global[GLOBAL_STATE].matchers, matchersObj);
};

const _validateResult = result => {
  if (
  typeof result !== 'object' ||
  typeof result.pass !== 'boolean' ||
  !(
  typeof result.message === 'string' ||
  typeof result.message === 'function'))

  {
    throw new Error(
    'Unexpected return from a matcher function.\n' +
    'Matcher functions should ' +
    'return an object in the following format:\n' +
    '  {message: string | function, pass: boolean}\n' +
    `'${ stringify(result) }' was returned`);

  }
};

const setState = state => {
  Object.assign(global[GLOBAL_STATE].state, state);
};

const getState = () => global[GLOBAL_STATE].state;

// add default jest matchers
addMatchers(matchers);
addMatchers(spyMatchers);
addMatchers(toThrowMatchers);

module.exports = {
  addMatchers,
  expect,
  getState,
  setState };