/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */

'use strict';



const IstanbulInstrument = require('istanbul-lib-instrument');var _require =

require('jest-runtime');const transformSource = _require.transformSource;const shouldInstrument = _require.shouldInstrument;

module.exports = function (source, filename, config) {
  if (shouldInstrument(filename, config)) {
    // Transform file without instrumentation first, to make sure produced
    // source code is ES6 (no flowtypes etc.) and can be instrumented
    source = transformSource(filename, config, source, false);
    const instrumenter = IstanbulInstrument.createInstrumenter();
    instrumenter.instrumentSync(source, filename);
    return instrumenter.fileCoverage;
  } else {
    return null;
  }
};