## babel-preset-env [![npm](https://img.shields.io/npm/v/babel-preset-env.svg)](https://www.npmjs.com/package/babel-preset-env) [![travis](https://img.shields.io/travis/babel/babel-preset-env/master.svg)](https://travis-ci.org/babel/babel-preset-env)

> Babel preset for all environments.

### How it currently works

#### Determine browser support for ECMAScript features (up to `latest`)

[#7](https://github.com/babel/babel-preset-env/issues/7) - Use external data such as [`compat-table`](https://github.com/kangax/compat-table) to determine browser support. We should create PRs there when necessary.

![](https://cloud.githubusercontent.com/assets/588473/19214029/58deebce-8d48-11e6-9004-ee3fbcb75d8b.png)

We run the script [build-data.js](/scripts/build-data.js) which creates [plugins.json](/data/plugins.json).

#### Make mapping between javascript features and plugins

This should be straightforward to do in most cases. There might be cases were plugins should be split up more. Currently located at [pluginFeatures.js](/data/pluginFeatures.js).

#### Support all plugins in Babel that are considered `latest`

[#14](https://github.com/babel/babel-preset-env/issues/14) - It won't include `stage-x` plugins. env will support all plugins in what we consider the latest version of Javascript (by matching what we do in [`babel-preset-latest`](http://babeljs.io/docs/plugins/preset-latest/)).

#### Determine the lowest common denominator of plugins to be included in the preset

If you are targeting IE 8 and Chrome 55 it will include all plugins required by IE 8 since you would need to support both still.

#### Support a `browsers` option like autoprefixer

[#19](https://github.com/babel/babel-preset-env/pull/19) - Use [browserslist](https://github.com/ai/browserslist) to also queries like `> 1%, last 2 versions`.

## Install

```sh
$ npm install --save-dev babel-preset-env
```

## Usage via [`.babelrc`](http://babeljs.io/docs/usage/babelrc/)

### [Options](http://babeljs.io/docs/plugins/#pluginpresets-options)

* `targets` - an object of browsers/environment versions to support (ex: chrome, node, etc).

The data for this is currently at: [/data/plugins.json](/data/plugins.json) and being generated by [/scripts/build-data.js](/scripts/build-data.js) using https://kangax.github.io/compat-table.

> We would like help to make sure the data is correct! This just means usage/testing!

Currently: "chrome, edge, firefox, safari, node"

> Some node features are > `6.5`.

* `browsers` (array/string) - an query to select browsers (ex: last 2 versions, > 5%).  

> Note, browsers' results are overridden by explicit items from `targets`.

> If your config is a js file, also do `"node": parseFloat(process.versions.node)`

* `loose` (boolean) - Enable "loose" transformations for any plugins in this preset that allow them (Disabled by default).
* `modules` - Enable transformation of ES6 module syntax to another module type (Enabled by default to `"commonjs"`).
  * Can be `false` to not transform modules, or one of `["amd", "umd", "systemjs", "commonjs"]`.
* `debug` (boolean) - `console.log` out the targets and plugins being used as well as the version specified in `/data/plugins.json`.

```js
{
  "presets": [
    ["env", {
      "targets": {
        "chrome": 52,
        "browsers": "last 2 safari versions"
      },
      "loose": true,
      "modules": false
    }]
  ]
}
```

### Example

```js
// src
export class A {}
```

```js
// default is to run all transforms
{
  "presets": [
    ["env", {}]
  ]
}

// ...

var A = exports.A = function A() {
  _classCallCheck(this, A);
};
```

```js
// target chrome 52
{
  "presets": [
    ["env", {
      "targets": {
        "chrome": 52
      }
    }]
  ]
}

// ...

class A {}
exports.A = A;
```

```js
// target chrome 52 with webpack 2/rollup
{
  "presets": [
    ["env", {
      "targets": {
        "chrome": 52
      },
      "modules": false
    }]
  ]
}

// ...

export class A {}
```

```js
// using browserslist
{
  "presets": [
    ["env", {
      "targets": {
        "chrome": 52,
        "browsers": ["last 2 versions", "safari 7"]
      }
    }]
  ]
}

// ...

export var A = function A() {
  _classCallCheck(this, A);
};
```

### Example with `debug: true`

```js
Using targets: {
  "node": 6.5
}

Using plugins:

module: false
transform-exponentiation-operator {}
transform-async-to-generator {}
syntax-trailing-function-commas {}
```

## Caveats

### Using `babel-plugin-transform-object-rest-spread` and targeting node.js 6.5 or higher

You may get a `SyntaxError: Unexpected token ...` error if using the [object-rest-spread](https://github.com/babel/babel/tree/master/packages/babel-plugin-transform-object-rest-spread) feature and targeting node.js 6.5 or higher.

This is a known issue at [babel/babel#4074](https://github.com/babel/babel/issues/4074).

A simple workaround would be to re-enable the following plugins: `babel-plugin-transform-es2015-destructuring` and `babel-plugin-transform-es2015-parameters`.
