/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */
'use strict';

const jestExpect = require('jest-matchers').expect;var _require =
require('jest-matchers');const addMatchers = _require.addMatchers;var _require2 =



require('jest-snapshot');const toMatchSnapshot = _require2.toMatchSnapshot;const toThrowErrorMatchingSnapshot = _require2.toThrowErrorMatchingSnapshot;

const jasmineExpect = global.expect;

// extend jasmine matchers with `jest-matchers`
module.exports = () => {
  addMatchers({ toMatchSnapshot, toThrowErrorMatchingSnapshot });
  global.expect = actual => {
    const jasmineMatchers = jasmineExpect(actual);
    const jestMatchers = jestExpect(actual);
    const not = Object.assign(jasmineMatchers.not, jestMatchers.not);
    return Object.assign(jasmineMatchers, jestMatchers, { not });
  };
};