/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gloverlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.autonavi.ae.gmap.gloverlay.BaseMapOverlay;
import com.autonavi.ae.gmap.gloverlay.GLCrossVector;
import com.autonavi.ae.gmap.gloverlay.GLTextureProperty;
import com.autonavi.amap.mapcore.interfaces.IAMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossVectorOverlay
extends BaseMapOverlay<GLCrossVector, Object> {
    int mIndex = 0;
    GLCrossVector.AVectorCrossAttr attr = null;

    public CrossVectorOverlay(int n2, Context context, IAMap iAMap) {
        super(n2, context, iAMap);
    }

    @Override
    protected void iniGLOverlay() {
        this.mGLOverlay = new GLCrossVector(this.mEngineID, this.mMapView, this.hashCode());
    }

    @Override
    public void addItem(Object object) {
    }

    @Override
    public void resumeMarker(Bitmap bitmap) {
        int n2 = 12345;
        this.AddOverlayTexture(bitmap, n2, 4);
        ((GLCrossVector)this.mGLOverlay).setArrowResId(false, n2);
        ((GLCrossVector)this.mGLOverlay).setCarResId(n2);
    }

    public void AddOverlayTexture(Bitmap bitmap, int n2, int n3) {
        GLTextureProperty gLTextureProperty = new GLTextureProperty();
        gLTextureProperty.mId = n2;
        gLTextureProperty.mAnchor = n3;
        gLTextureProperty.mBitmap = bitmap;
        gLTextureProperty.mXRatio = 0.0f;
        gLTextureProperty.mYRatio = 0.0f;
        gLTextureProperty.isGenMimps = true;
        this.mMapView.addOverlayTexture(this.mEngineID, gLTextureProperty);
    }

    public int dipToPixel(Context context, int n2) {
        if (context == null) {
            return n2;
        }
        try {
            float f2 = TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
            return (int)f2;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public void setAttribute(GLCrossVector.AVectorCrossAttr aVectorCrossAttr) {
        this.attr = aVectorCrossAttr;
    }

    public void setData(byte[] byArray) {
        if (this.attr == null) {
            GLCrossVector.AVectorCrossAttr aVectorCrossAttr = new GLCrossVector.AVectorCrossAttr();
            aVectorCrossAttr.nCenterX = 0;
            aVectorCrossAttr.nCenterY = 0;
            aVectorCrossAttr.stRectMax = new Rect();
            aVectorCrossAttr.stRectMin = new Rect();
            aVectorCrossAttr.nAngle = 0;
            aVectorCrossAttr.stAreaRect = new Rect(0, 0, this.mMapView.getMapWidth(), this.mMapView.getMapHeight() * 4 / 11);
            aVectorCrossAttr.stAreaColor = Color.argb((int)217, (int)95, (int)95, (int)95);
            aVectorCrossAttr.fImportBorderWidth = this.dipToPixel(this.mContext, 22);
            aVectorCrossAttr.stImportBorderColor = Color.argb((int)255, (int)255, (int)255, (int)255);
            aVectorCrossAttr.fUnImportBorderWidth = aVectorCrossAttr.fImportBorderWidth;
            aVectorCrossAttr.stUnImportBorderColor = aVectorCrossAttr.stImportBorderColor;
            aVectorCrossAttr.fArrowBorderWidth = this.dipToPixel(this.mContext, 22);
            aVectorCrossAttr.stArrowBorderColor = Color.argb((int)0, (int)0, (int)50, (int)20);
            aVectorCrossAttr.fImportLineWidth = this.dipToPixel(this.mContext, 18);
            aVectorCrossAttr.stImportLineColor = Color.argb((int)255, (int)150, (int)170, (int)200);
            aVectorCrossAttr.fUnImportLineWidth = aVectorCrossAttr.fImportLineWidth;
            aVectorCrossAttr.stUnImportLineColor = aVectorCrossAttr.stImportLineColor;
            aVectorCrossAttr.fDashLineWidth = this.dipToPixel(this.mContext, 2);
            aVectorCrossAttr.stDashLineColor = aVectorCrossAttr.stUnImportBorderColor;
            aVectorCrossAttr.fArrowLineWidth = this.dipToPixel(this.mContext, 18);
            aVectorCrossAttr.stArrowLineColor = Color.argb((int)255, (int)255, (int)253, (int)65);
            aVectorCrossAttr.dayMode = false;
        }
        if (null != byArray && this.attr != null) {
            ((GLCrossVector)this.mGLOverlay).addVectorItem(this.attr, byArray, byArray.length);
            ((GLCrossVector)this.mGLOverlay).setVisible(true);
        }
    }

    public void remove() {
        this.setVisible(false);
        this.releaseInstance();
    }
}

