/// <reference types="react" />
import Component from '../AbstractComponent';
import Props, { OrientationType, QualityType } from './Props';
declare let CameraFacing: any;
declare let Orientation: OrientationType;
declare let Quality: QualityType;
/**
 * 安卓相机版本
 * 4 使用
 * 5 安卓5.0相机
 * 设置安卓相机版本
 * @param cameraVersion 版本
 */
export declare function setCameraVersion(cameraVersion: any): void;
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/6/22
 */
declare class Camera extends Component<Props> {
    static propTypes: {
        cameraFacing: any;
        needCaptureOutputBuffer: any;
        orientation: any;
        quality: any;
        onCaptureOutputBuffer: any;
    };
    static defaultProps: {
        cameraFacing: any;
        orientation: number;
        quality: string;
    };
    /**
     * 检查是否有相机权限
     * ios only
     */
    static checkVideoAuthorizationStatus: any;
    /**
     * 检查是否有麦克风权限
     * ios only
     */
    static checkAudioAuthorizationStatus: any;
    componentDidMount(): void;
    componentWillUnmount(): void;
    capture(option: any): void;
    handleCaptureOutputBuffer(event: any): void;
    render(): JSX.Element;
}
export { Camera as default, Orientation, CameraFacing, Quality };
