export interface OriType {
    unknown: number;
    portrait: number;
    portraitUpsideDown: number;
    landscapeLeft: number;
    landscapeRight: number;
    faceUp: number;
    faceDown: number;
}
export declare const Orientation: OriType;
/**
 * 设备方向管理器
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/8/5
 */
export default class OrientationManager {
    /**
     * 获取当前屏幕方向
     * @return {*}
     */
    static getOrientation(): any;
    /**
     * 设置屏幕方向
     * @param orientation 屏幕方向
     * @param lock 是否锁定旋转
     */
    static setOrientation(orientation: any, lock: any): void;
    /**
     * 设置屏幕方向为默认值
     */
    static setOrientationToDefault(): void;
    /**
     * 监听屏幕旋转方向
     * @param callback
     */
    static addDeviceOrientationDidChangeListener(callback: any): void;
    /**
     * 移除屏幕旋转监听
     * @param callback
     */
    static removeDeviceOrientationDidChangeListener(callback: any): void;
}
