/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.search;

import com.autonavi.ae.search.INativeSearchObserver;
import com.autonavi.ae.search.NativeSearchEngine;
import com.autonavi.ae.search.NativeSearchPub;
import com.autonavi.ae.search.interfaces.OnSearchResultListener;
import com.autonavi.ae.search.log.GLog;
import com.autonavi.ae.search.model.GADAREAEXTRAINFO;
import com.autonavi.ae.search.model.GADAREAINFO;
import com.autonavi.ae.search.model.GObjectID;
import com.autonavi.ae.search.model.GPoiResult;
import com.autonavi.ae.search.model.SearchStatus;
import java.util.Hashtable;

public class SearchEngine
extends NativeSearchEngine {
    private Hashtable<Integer, OnSearchResultListener> mSearchCallBackListenerList = new Hashtable();
    private boolean mIsInit = false;
    private Object o = new Object();
    private long mNativeId = 0L;
    private final String TAG = "SearchEngine";
    private static int mRequestID = 1;
    private INativeSearchObserver obServer = new INativeSearchObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetSearchResult(int n2, int n3, GPoiResult gPoiResult) {
            if (GLog.isLogShow()) {
                if (gPoiResult != null) {
                    GLog.v("SearchEngine", "onGetSearchResult id=" + n2 + ",status=" + n3 + ",size=" + gPoiResult.getNumberOfItemGet());
                } else {
                    GLog.v("SearchEngine", "onGetSearchResult id=" + n2 + ",status=" + n3 + ",result=NULL");
                }
            }
            OnSearchResultListener onSearchResultListener = null;
            Object object = SearchEngine.this.o;
            synchronized (object) {
                onSearchResultListener = (OnSearchResultListener)SearchEngine.this.mSearchCallBackListenerList.remove(n2);
            }
            if (onSearchResultListener != null) {
                onSearchResultListener.onGetSearchResult(n3, gPoiResult);
            }
        }

        @Override
        public void onSetPoiParam(int n2) {
            GLog.v("wmh", "SearchEngine.onSetPoiParam");
        }

        @Override
        public void onGetPoiParam(int n2, int n3, int n4) {
            GLog.v("wmh", "SearchEngine.onGetPoiParam");
        }

        @Override
        public void onGetPoiCategoryList(int n2, int n3) {
            GLog.v("wmh", "SearchEngine.onGetPoiCategoryList status=" + n2 + ",lNumberOfCategory=" + n3);
        }

        @Override
        public void onGetAdareaInfo(int n2, int n3, GADAREAINFO[] gADAREAINFOArray) {
            GLog.v("wmh", "SearchEngine.onGetAdareaInfo");
        }

        @Override
        public void onGetSuggestArea() {
            GLog.v("wmh", "SearchEngine.onGetSuggestArea");
        }
    };

    public int init() {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = this.nativeCreateSearcher();
        if (GLog.isLogShow()) {
            GLog.v("SearchEngine", "nativeCreateSearcher.naviid=" + n2);
        }
        if (n2 != 0) {
            int n3 = this.nativeInit(string, string2, string3, null, 20, 0);
            if (n3 == 0) {
                this.mIsInit = true;
                return this.addSearchObserver(this.obServer);
            }
            this.mIsInit = false;
            return n3;
        }
        return -1;
    }

    public int setMccPath(String string) {
        return this.nativeSetMccPath(string, SearchEngine.getRequestID());
    }

    public int cancelQuery() {
        if (this.isInit()) {
            if (GLog.isLogShow()) {
                GLog.v("SearchEngine", "cancelQuery start");
            }
            return this.nativeAbortSearch();
        }
        return -2;
    }

    private int addSearchObserver(INativeSearchObserver iNativeSearchObserver) {
        if (this.isInit()) {
            return this.nativeAddSearchObserver(iNativeSearchObserver);
        }
        return -2;
    }

    public boolean isInit() {
        return this.mIsInit && this.mNativeId != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroy() {
        if (GLog.isLogShow()) {
            GLog.v("SearchEngine", "destroy start");
        }
        Object object = this.o;
        synchronized (object) {
            this.mSearchCallBackListenerList.clear();
        }
        this.mIsInit = false;
        return this.nativeDestroy();
    }

    public int startSearch(int n2, String string, int n3, float f2, float f3, int n4, int n5, GObjectID[] gObjectIDArray) {
        return this.startSearch(n2, string, n3, f2, f3, n4, n5, gObjectIDArray, null);
    }

    public int preSearch(int n2, String string, int n3, float f2, float f3, int n4, OnSearchResultListener onSearchResultListener) {
        return this.startSearch(n2, 1, string, n3, f2, f3, n4, onSearchResultListener);
    }

    public int startSearch(int n2, String string, int n3, float f2, float f3, int n4, OnSearchResultListener onSearchResultListener) {
        return this.startSearch(n2, 2, string, n3, f2, f3, n4, onSearchResultListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startSearch(int n2, int n3, String string, int n4, float f2, float f3, int n5, OnSearchResultListener onSearchResultListener) {
        if (this.isInit()) {
            Object object;
            if (f2 <= 0.0f || f3 <= 0.0f) {
                n2 = 8;
            }
            int n6 = SearchEngine.getRequestID();
            if (onSearchResultListener != null) {
                object = this.o;
                synchronized (object) {
                    this.mSearchCallBackListenerList.put(n6, onSearchResultListener);
                }
            }
            object = this.nativeStartSearch(n2, n3, string, n4, f2, f3, 0, n5, n6, 0, null);
            if (GLog.isLogShow()) {
                GLog.v("SearchEngine", "startSearch requestID=" + ((SearchStatus)object).getEventId() + "strKey=" + string + ",nAdcode=" + n4 + ",status=" + ((SearchStatus)object).getStatus());
            }
            return ((SearchStatus)object).getStatus();
        }
        return -2;
    }

    private static synchronized int getRequestID() {
        if (mRequestID > 60000) {
            mRequestID = 1;
        }
        return mRequestID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startSearch(int n2, String string, int n3, float f2, float f3, int n4, int n5, GObjectID[] gObjectIDArray, OnSearchResultListener onSearchResultListener) {
        if (this.isInit()) {
            Object object;
            int n6 = SearchEngine.getRequestID();
            if (onSearchResultListener != null) {
                object = this.o;
                synchronized (object) {
                    this.mSearchCallBackListenerList.put(n6, onSearchResultListener);
                }
            }
            object = this.nativeStartSearch(n2, 2, string, n3, f2, f3, 0, n4, n6, n5, gObjectIDArray);
            if (GLog.isLogShow()) {
                GLog.v("SearchEngine", "startSearch requestID=" + ((SearchStatus)object).getEventId() + "strKey=" + string + ",nAdcode=" + n3 + ",status=" + ((SearchStatus)object).getStatus());
            }
            return ((SearchStatus)object).getStatus();
        }
        return -2;
    }

    public int searchNearestPoi(float f2, float f3, OnSearchResultListener onSearchResultListener) {
        int n2 = 0;
        return this.startSearch(9, 2, null, n2, f2, f3, 10, onSearchResultListener);
    }

    public int getPoiDetail(String string, float f2, float f3, OnSearchResultListener onSearchResultListener) {
        int n2 = 0;
        return this.startSearch(10, 2, string, n2, f2, f3, 10, onSearchResultListener);
    }

    public int setPoiParam(int n2, int n3) {
        if (this.isInit()) {
            return this.nativeSetPoiParam(n2, n3);
        }
        return -2;
    }

    public int getPoiParam(int n2) {
        if (this.isInit()) {
            return this.nativeGetPoiParam(n2);
        }
        return -2;
    }

    public boolean isExistByAdCode(int n2) {
        if (this.isInit()) {
            return NativeSearchPub.DbExists(n2);
        }
        return false;
    }

    public static synchronized String getDataVersion(int n2) {
        return NativeSearchPub.GetDataVersion(n2);
    }

    public static synchronized String getEngineVersion() {
        return NativeSearchPub.GetVersion();
    }

    public int getPoiCategoryList(int n2) {
        if (this.isInit()) {
            return this.nativeGetPoiCategoryList(n2);
        }
        return -2;
    }

    public GADAREAEXTRAINFO GetAdareaInfo(int n2) {
        if (this.isInit()) {
            return NativeSearchPub.GetAdareaInfo(n2);
        }
        return null;
    }

    public int searchAdareaInfo(String string) {
        if (this.isInit()) {
            return this.nativeSearchAdareaInfo(0, string);
        }
        return -2;
    }
}

