/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.SparseArray;
import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.ae.gmap.callback.GLMapCoreCallback;
import com.autonavi.ae.gmap.callback.JniIndoorCallback;
import com.autonavi.ae.gmap.callback.JniMapCoreCallback;
import com.autonavi.ae.gmap.callback.JniMapHeatCallback;
import com.autonavi.ae.gmap.callback.JniScenicCallback;
import com.autonavi.ae.gmap.gesture.EAMapPlatformGestureInfo;
import com.autonavi.ae.gmap.glanimation.ADGLMapAnimFling;
import com.autonavi.ae.gmap.glanimation.ADGLMapAnimGroup;
import com.autonavi.ae.gmap.glanimation.ADGLMapAnimationMgr;
import com.autonavi.ae.gmap.glinterface.GLGeoPoint;
import com.autonavi.ae.gmap.gloverlay.BaseMapOverlay;
import com.autonavi.ae.gmap.gloverlay.GLOverlayBundle;
import com.autonavi.ae.gmap.gloverlay.GLTextureProperty;
import com.autonavi.ae.gmap.listener.MapListener;
import com.autonavi.ae.gmap.listener.RouteBoardDataListener;
import com.autonavi.ae.gmap.maploader.BaseMapLoader;
import com.autonavi.ae.gmap.maploader.ConnectionManager;
import com.autonavi.ae.gmap.maploader.GuideMapLoader;
import com.autonavi.ae.gmap.maploader.HeatMapLoader;
import com.autonavi.ae.gmap.maploader.IndoorMapLoader;
import com.autonavi.ae.gmap.maploader.MapSourceGridData;
import com.autonavi.ae.gmap.maploader.MessageDataThread;
import com.autonavi.ae.gmap.maploader.NetworkState;
import com.autonavi.ae.gmap.maploader.NormalMapLoader;
import com.autonavi.ae.gmap.maploader.OpenLayerMapLoader;
import com.autonavi.ae.gmap.maploader.TilesProcessingCtrl;
import com.autonavi.ae.gmap.maploader.TmcMapLoader;
import com.autonavi.ae.gmap.maploader.VMapDataCache;
import com.autonavi.ae.gmap.scenic.Label3rd;
import com.autonavi.ae.gmap.scenic.MapHeatListener;
import com.autonavi.ae.gmap.scenic.ScenicInfor;
import com.autonavi.ae.gmap.scenic.ScenicListener;
import com.autonavi.ae.gmap.scenic.ScenicWidgetItem;
import com.autonavi.ae.gmap.style.MapTilsCacheAndResManager;
import com.autonavi.ae.gmap.style.MapTilsCacheAndResManagerImpl;
import com.autonavi.ae.gmap.style.StyleItem;
import com.autonavi.ae.gmap.style.StylesIconsUpdate;
import com.autonavi.ae.gmap.utils.GLMapUtil;
import com.autonavi.ae.gmap.utils.GLStateInstance;
import com.autonavi.ae.gmap.utils.TextTextureGenerator;
import com.autonavi.amap.mapcore.CameraUpdateMessage;
import com.autonavi.amap.mapcore.MapConfig;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import com.autonavi.amap.mapcore.interfaces.IAMapListener;
import com.autonavi.amap.mapcore.message.GestureMapMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLMapEngine
implements JniIndoorCallback,
JniMapCoreCallback,
JniMapHeatCallback,
JniScenicCallback {
    public static final int TAP_POINTS = 1;
    public static final int TAP_LINES = 2;
    public static final int TAP_POLYGON = 4;
    public static final int ANIM_ACTION_MOVE = 1;
    public static final int ANIM_ACTION_ZOOM = 2;
    public static final int ANIM_ACTION_ROTATEMAP = 4;
    public static final int ANIM_ACTION_ROTATECAMERA = 8;
    private static final int LONG_LONG_TICK_COUNT = 3;
    private static final int NORMAL_TICK_COUNT = 1;
    private static final int LONG_TICK_COUNT = 2;
    public static final int DATA_NOTEXIT = 0;
    public static final int DATA_IN_DISK = 1;
    public static final int DATA_IN_MEMORY = 2;
    public static int BUILDINGHEIGHT = 0;
    private List<MapSourceGridData> geometryReqMapGrids = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> roadReqMapGrids = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> bldReqMapGrids = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> regionReqMapGrids = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> poiReqMapGrids = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> versionMapGrids = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> indoorMapGrids = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> vectmcReqMapGirds = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> stiReqMapGirds = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> mapReqModels = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> guideReqMapGirds = new ArrayList<MapSourceGridData>();
    private List<MapSourceGridData> mapHeatReqMapGirds = new ArrayList<MapSourceGridData>();
    private static final int MAX_CUR_SCREEN_GRIDS_COUNT = 200;
    private MapSourceGridData[] mCurScreenGirds = new MapSourceGridData[200];
    private MapSourceGridData[] mEagleEyeScreenGirds = null;
    private int mCurScreenGridsCount = 0;
    private Object mCurGridFillLock = new Object();
    private Context mContext = null;
    private TextTextureGenerator mTextTextureGenerator = null;
    private ConnectionManager mConnectionManager = null;
    public TilesProcessingCtrl mTileProcessCtrl = null;
    private GLMapCoreCallback mapcoreListener = null;
    private RouteBoardDataListener mBoardDataListener = null;
    private ScenicListener mScenicListener = null;
    public MapListener mMapListener = null;
    public IAMapListener mAMapListener = null;
    private MapHeatListener mMapHeatListener = null;
    private CopyOnWriteArrayList<CameraUpdateMessage> mStateMessageList = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<GestureMapMessage> mGestureMessageList = new CopyOnWriteArrayList();
    private byte[] tmp_3072bytes_data;
    private boolean canStopRender = false;
    boolean isMoveCameraStep = false;
    boolean isGestureStep = false;
    private int map_gesture_count = 0;
    private long mNativeMapengineInstance = 0L;
    private IAMap mGlMapView = null;
    private Object mut_lock = new Object();
    private int mShowErrowTipCouont = 0;
    public String mUserAgent = "";
    private ADGLMapAnimationMgr map_anims_mgr = null;
    MapTilsCacheAndResManager mCacheMgr = null;
    GLMapState s = new GLMapState();
    private SparseArray<GLStateInstance> mStateSparseArray = new SparseArray();

    public void pushRendererState() {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativePushRendererState(1, this.mNativeMapengineInstance);
        }
    }

    public void popRendererState() {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativePopRenderState(1, this.mNativeMapengineInstance);
        }
    }

    public int getStateMessageCount() {
        return this.mStateMessageList.size();
    }

    public void addMessage(CameraUpdateMessage cameraUpdateMessage) {
        if (this.mStateMessageList != null) {
            this.mStateMessageList.add(cameraUpdateMessage);
        }
    }

    public synchronized CameraUpdateMessage getStateMessage() {
        if (this.mStateMessageList != null && this.mStateMessageList.size() == 0) {
            return null;
        }
        CameraUpdateMessage cameraUpdateMessage = this.mStateMessageList.get(0);
        this.mStateMessageList.remove(cameraUpdateMessage);
        return cameraUpdateMessage;
    }

    public GLMapEngine(Context context, IAMap iAMap) {
        this.mContext = context;
        this.mGlMapView = iAMap;
        this.map_anims_mgr = new ADGLMapAnimationMgr();
        this.tmp_3072bytes_data = ByteBuffer.allocate(3072).array();
        this.mTextTextureGenerator = new TextTextureGenerator();
        String string = this.mTextTextureGenerator.getFontVersion();
        File file = context.getDir("Map_Assert", 0);
        if (!file.exists()) {
            file.mkdir();
        }
        String string2 = file.getPath() + "/";
        this.mNativeMapengineInstance = GLMapEngine.nativeCreate(string2, string, BUILDINGHEIGHT);
        this.mUserAgent = System.getProperty("http.agent") + " amap/" + GLMapUtil.getAppVersionName(context);
        for (int i2 = 0; i2 < 200; ++i2) {
            this.mCurScreenGirds[i2] = new MapSourceGridData();
        }
    }

    public MapTilsCacheAndResManager getMapCacheMgr() {
        return this.mCacheMgr;
    }

    public void initConnectionManager() {
        this.mConnectionManager = new ConnectionManager(this);
        this.mTileProcessCtrl = new TilesProcessingCtrl();
        this.mConnectionManager.start();
    }

    public void loadStartResource(int n2, int n3, int n4, int n5, boolean bl2, int n6, int n7) {
        int[] nArray = new int[]{n3, n4, n5, 0, 0};
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeLoadStartResource(n2, this.mNativeMapengineInstance, this, nArray, n6, n7);
        }
    }

    public void changeSurface(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeChangeSurface(n2, this.mNativeMapengineInstance, n3, n4, n5, n6, n7, n8, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destorySurface() {
        if (this.mTileProcessCtrl != null) {
            this.mTileProcessCtrl.clearAll();
        }
        if (this.mConnectionManager != null) {
            this.mConnectionManager.threadFlag = false;
            if (this.mConnectionManager.isAlive()) {
                try {
                    this.mConnectionManager.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mConnectionManager.shutDown();
                this.mConnectionManager = null;
            }
        }
        if (null != this.mStateSparseArray) {
            this.mStateSparseArray.clear();
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeDestorySurface(this.mNativeMapengineInstance, this);
        }
        this.tmp_3072bytes_data = null;
        Object object = this.mut_lock;
        synchronized (object) {
            if (this.mNativeMapengineInstance != 0L) {
                GLMapEngine.nativeDestroy(this.mNativeMapengineInstance);
                this.mNativeMapengineInstance = 0L;
            }
        }
    }

    public void drawFrame() {
        if (this.mNativeMapengineInstance != 0L) {
            this.processMessage();
            GLMapEngine.nativeDrawFrame(this.mNativeMapengineInstance);
            GLMapEngine.nativePostDrawFrame(this.mNativeMapengineInstance);
        }
    }

    private void processMessage() {
        try {
            this.processGestureMessage();
            if (this.mGestureMessageList.size() <= 0) {
                this.processStateMapMessage();
            } else if (this.mStateMessageList.size() > 0) {
                this.mStateMessageList.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processGestureMessage() {
        if (this.mGestureMessageList.size() <= 0) {
            if (this.isGestureStep) {
                this.isGestureStep = false;
            }
            return;
        }
        this.isGestureStep = true;
        GLMapState gLMapState = new GLMapState(1, this.getMapEnginePtr());
        if (gLMapState == null) {
            return;
        }
        gLMapState.recalculate();
        GestureMapMessage gestureMapMessage = null;
        while (this.mGestureMessageList.size() > 0 && (gestureMapMessage = this.mGestureMessageList.remove(0)) != null) {
            int n2;
            if (gestureMapMessage.width == 0) {
                gestureMapMessage.width = this.mGlMapView.getMapWidth();
            }
            if (gestureMapMessage.height == 0) {
                gestureMapMessage.height = this.mGlMapView.getMapHeight();
            }
            if ((n2 = gestureMapMessage.getMapGestureState()) == 100) {
                this.gestureBegin();
                continue;
            }
            if (n2 == 101) {
                gestureMapMessage.runCameraUpdate(gLMapState);
                continue;
            }
            if (n2 != 102) continue;
            this.gestureEnd();
        }
        this.setMapState(1, gLMapState);
        gLMapState.recycle();
        gLMapState = null;
    }

    private void gestureBegin() {
        ++this.map_gesture_count;
    }

    private void gestureEnd() {
        --this.map_gesture_count;
    }

    private void processStateMapMessage() {
        if (this.mStateMessageList.size() <= 0) {
            if (this.isMoveCameraStep) {
                this.isMoveCameraStep = false;
            }
            return;
        }
        this.isMoveCameraStep = true;
        GLMapState gLMapState = new GLMapState(1, this.getMapEnginePtr());
        if (gLMapState == null) {
            return;
        }
        CameraUpdateMessage cameraUpdateMessage = null;
        while (this.mStateMessageList.size() > 0 && (cameraUpdateMessage = this.mStateMessageList.remove(0)) != null) {
            if (cameraUpdateMessage.width == 0) {
                cameraUpdateMessage.width = this.mGlMapView.getMapWidth();
            }
            if (cameraUpdateMessage.height == 0) {
                cameraUpdateMessage.height = this.mGlMapView.getMapHeight();
            }
            gLMapState.recalculate();
            cameraUpdateMessage.runCameraUpdate(gLMapState);
        }
        this.setMapState(1, gLMapState);
        gLMapState.recycle();
        gLMapState = null;
    }

    public Context getContext() {
        return this.mContext.getApplicationContext();
    }

    public void changeMapEnv(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeChangeMapEnv(n2, this.mNativeMapengineInstance, "");
            this.mCacheMgr.setMapCachePath(GLMapEngine.nativeGetMapCachePath(n2, this.mNativeMapengineInstance));
            this.mCacheMgr.checkDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMapEngineValid() {
        Object object = this.mut_lock;
        synchronized (object) {
            return this.mNativeMapengineInstance != 0L;
        }
    }

    public String getMapSvrAddress() {
        return "http://mps.amap.com";
    }

    public String getMapIndoorAddress() {
        return "http://m5.amap.com";
    }

    public void setMapCoreListener(GLMapCoreCallback gLMapCoreCallback) {
        this.mapcoreListener = gLMapCoreCallback;
    }

    public void clearAllMessages(int n2) {
        GLMapEngine.nativeClearAllMessage(n2, this.mNativeMapengineInstance);
    }

    public synchronized void addGestureMessage(int n2, GestureMapMessage gestureMapMessage, boolean bl2, int n3, int n4) {
        if (gestureMapMessage == null) {
            return;
        }
        gestureMapMessage.isGestureScaleByMapCenter = bl2;
        this.mGestureMessageList.add(gestureMapMessage);
    }

    public boolean isInMapAction(int n2) {
        return GLMapEngine.nativeGetGestureMsgCount(n2, this.mNativeMapengineInstance) > 0;
    }

    public boolean isInMapAnimation(int n2) {
        return this.getAnimateionsCount() > 0;
    }

    public int getAnimateionsCount() {
        if (this.mNativeMapengineInstance != 0L) {
            return this.map_anims_mgr.getAnimationsCount();
        }
        return 0;
    }

    public void setMapState(int n2, GLMapState gLMapState) {
        this.setMapState(n2, gLMapState, true);
    }

    public synchronized void setMapState(int n2, GLMapState gLMapState, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            if (bl2 && this.mGlMapView != null && this.mGlMapView.getMapConfig() != null) {
                this.mGlMapView.checkMapState(gLMapState);
            }
            gLMapState.setNativeMapengineState(n2, this.mNativeMapengineInstance);
        }
    }

    public synchronized GLMapState getNewMapState(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            return new GLMapState(n2, this.mNativeMapengineInstance);
        }
        return null;
    }

    public synchronized GLMapState getMapState(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            this.s.setMapstateInstance(this.getStateInstanceWithEngineID(n2));
            return this.s;
        }
        return null;
    }

    public long getMapStateInstance(int n2) {
        return this.getStateInstanceWithEngineID(n2);
    }

    private List<MapSourceGridData> getReqGridList(int n2) {
        switch (n2) {
            case 15: {
                return this.geometryReqMapGrids;
            }
            case 0: {
                return this.roadReqMapGrids;
            }
            case 1: {
                return this.bldReqMapGrids;
            }
            case 7: {
                return this.regionReqMapGrids;
            }
            case 8: {
                return this.poiReqMapGrids;
            }
            case 4: {
                return this.vectmcReqMapGirds;
            }
            case 3: {
                return this.stiReqMapGirds;
            }
            case 9: {
                return this.versionMapGrids;
            }
            case 10: {
                return this.indoorMapGrids;
            }
            case 11: {
                return this.guideReqMapGirds;
            }
            case 12: {
                return this.mapHeatReqMapGirds;
            }
        }
        return null;
    }

    private void processRequiredData(final int n2, List<MapSourceGridData> list, int n3, String string) {
        Object[] objectArray;
        Object object;
        if (!NetworkState.getInstance().isInternetConnected(this.mContext)) {
            if (this.mShowErrowTipCouont <= 0) {
                ++this.mShowErrowTipCouont;
                this.onException(n2, 1002);
            }
            if (this.mapcoreListener != null) {
                this.mapcoreListener.postQueueEvent(new Runnable(){

                    public void run() {
                        GLMapEngine.this.setParamater(n2, 5001, 1002, 0, 0, 0);
                    }
                });
            }
            return;
        }
        this.mShowErrowTipCouont = 0;
        ArrayList<MapSourceGridData> arrayList = new ArrayList<MapSourceGridData>();
        int n4 = list.size();
        MapSourceGridData mapSourceGridData = null;
        for (int i2 = 0; i2 < n4; ++i2) {
            mapSourceGridData = list.get(i2);
            if (this.mTileProcessCtrl.isProcessing(mapSourceGridData.getKeyGridName())) continue;
            if (n3 == 4) {
                int n5;
                object = mapSourceGridData.getGridName();
                if (TextUtils.isEmpty((CharSequence)object) || 1 == (n5 = GLMapEngine.nativeTmcCacheCheckValid(n2, this.mNativeMapengineInstance, (String)object, true, false, (byte[])(objectArray = (Object[])new byte[100])))) continue;
                if (0 == n5) {
                    int n6 = objectArray[0];
                    String string2 = null;
                    if (n6 > 0) {
                        try {
                            string2 = new String((byte[])objectArray, 1, n6, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            continue;
                        }
                    }
                    if (!TextUtils.isEmpty(string2)) {
                        mapSourceGridData.mObj = string2;
                    }
                }
                arrayList.add(mapSourceGridData);
                continue;
            }
            arrayList.add(mapSourceGridData);
        }
        if (arrayList.size() > 0) {
            BaseMapLoader baseMapLoader = null;
            switch (n3) {
                case 10: {
                    baseMapLoader = new IndoorMapLoader(n2, this, n3);
                    break;
                }
                case 11: {
                    baseMapLoader = new GuideMapLoader(n2, this, n3);
                    baseMapLoader.setGetRequestMethod(false);
                    break;
                }
                case 12: {
                    baseMapLoader = new HeatMapLoader(n2, this, n3);
                    baseMapLoader.setGetRequestMethod(false);
                    ((HeatMapLoader)baseMapLoader).setMapHeatPoiId(string);
                    break;
                }
                case 4: {
                    object = this.getMapModeState(n2, false);
                    if (null == object) break;
                    baseMapLoader = new TmcMapLoader(n2, this, n3);
                    baseMapLoader.setGetRequestMethod(false);
                    ((NormalMapLoader)baseMapLoader).setMapParams((int)this.getMapZoomer(n2), (int)object[0], (int)object[2]);
                    break;
                }
                default: {
                    objectArray = this.getMapModeState(n2, false);
                    if (null == objectArray) break;
                    baseMapLoader = new NormalMapLoader(n2, this, n3);
                    baseMapLoader.setGetRequestMethod(false);
                    ((NormalMapLoader)baseMapLoader).setMapParams((int)this.getMapZoomer(n2), objectArray[0], objectArray[2]);
                }
            }
            object = null;
            n4 = arrayList.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                object = (MapSourceGridData)arrayList.get(i3);
                this.mTileProcessCtrl.addProcessingTile(((MapSourceGridData)object).getKeyGridName());
                baseMapLoader.addRequestTiles((MapSourceGridData)object);
            }
            if (this.mConnectionManager != null) {
                this.mConnectionManager.insertConntionTask(baseMapLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGridsInScreen(int n2, List<MapSourceGridData> list, int n3) {
        try {
            if (list.size() == 0) {
                return false;
            }
            if (!this.isMapEngineValid()) {
                return false;
            }
            Object object = this.mCurGridFillLock;
            synchronized (object) {
                int n4 = list.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (!this.isGridInList(n2, list.get(i2).getGridName())) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetCurrentGrideNameLen(int n2) {
        try {
            if (!this.isMapEngineValid()) {
                return 0;
            }
            Object object = this.mCurGridFillLock;
            synchronized (object) {
                if (this.mCurScreenGridsCount <= 0) {
                    return 0;
                }
                if (n2 == 1) {
                    return this.mCurScreenGirds[0].getGridName().length();
                }
                if (n2 == 2) {
                    return this.mEagleEyeScreenGirds[0].getGridName().length();
                }
                return 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGridInScreen(int n2, int n3, String string) {
        try {
            if (!this.isMapEngineValid()) {
                return false;
            }
            Object object = this.mCurGridFillLock;
            synchronized (object) {
                return this.isGridInList(n2, string);
                {
                }
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean isIndoorGridsInScreen(List<MapSourceGridData> list, int n2) {
        return true;
    }

    public boolean isIndoorGridInScreen(int n2, String string, short s2) {
        return true;
    }

    private boolean isIndoorGridInList(String string, List<MapSourceGridData> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getKeyGridName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isGridInList(int n2, String string) {
        int n3 = this.mCurScreenGridsCount;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(n2 == 1 ? this.mCurScreenGirds[i2].getGridName().startsWith(string) : n2 == 2 && this.mEagleEyeScreenGirds[i2].getGridName().startsWith(string))) continue;
            return true;
        }
        return false;
    }

    public void clearException(int n2) {
        if (this.mapcoreListener != null) {
            this.mapcoreListener.clearException(n2);
        }
    }

    public void onException(int n2, int n3) {
        if (this.mapcoreListener != null) {
            this.mapcoreListener.onException(n2, n3);
        }
    }

    @Override
    public void onMapSurfaceRenderer(int n2, int n3) {
        try {
            switch (n3) {
                case 1: {
                    if (this.mMapListener == null) break;
                    this.mMapListener.beforeDrawFrame(n2, this.getMapState(n2));
                    break;
                }
                case 5: {
                    if (this.mMapListener != null) {
                        this.mMapListener.afterDrawFrame(n2, this.getMapState(n2));
                    }
                    if (this.mAMapListener == null) break;
                    this.mAMapListener.afterDrawFrame(n2, this.getMapState(n2));
                    break;
                }
                case 11: {
                    this.fillCurScreenGrids(n2);
                    break;
                }
                case 10000: {
                    if (this.mapcoreListener == null) break;
                    this.mapcoreListener.resetRenderTimeLong();
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if (this.mAMapListener == null) break;
                    this.mAMapListener.afterDrawLabel(n2, this.getMapState(n2));
                    break;
                }
                case 0: {
                    if (2 != this.IsRealCityAnimateFinish(n2) || null == this.mMapListener) break;
                    this.mMapListener.onRealCityAnimateFinish(n2);
                    break;
                }
            }
            this.onMapProcessEvent(n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onMapSufaceChanged(int n2, int n3, int n4) {
    }

    @Override
    public void onMapProcessEvent(int n2) {
        try {
            if (this.map_anims_mgr.getAnimationsCount() > 0) {
                GLMapState gLMapState = this.getMapState(n2);
                gLMapState.recalculate();
                this.map_anims_mgr.doAnimations(gLMapState);
                this.setMapState(n2, gLMapState);
                gLMapState.recycle();
                gLMapState = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void onMapDataRequired(int n2, int n3, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || this.mNativeMapengineInstance == 0L) {
            return;
        }
        List<MapSourceGridData> list = this.getReqGridList(n3);
        String string = null;
        if (list != null) {
            list.clear();
            int n4 = stringArray.length;
            MapSourceGridData mapSourceGridData = null;
            for (int i2 = 0; i2 < n4; ++i2) {
                if (n3 == 12) {
                    string = GLMapEngine.nativeGetMapHeatPoiId(n2, this.mNativeMapengineInstance);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        mapSourceGridData = new MapSourceGridData(stringArray[i2], string, n3);
                    }
                } else {
                    mapSourceGridData = new MapSourceGridData(stringArray[i2], n3);
                }
                if (mapSourceGridData == null) continue;
                list.add(mapSourceGridData);
            }
            if (n3 != 5) {
                this.processRequiredData(n2, list, n3, string);
            }
        }
    }

    @Override
    public byte[] onCharBitmapRequired(int n2, int n3) {
        byte[] byArray = this.mTextTextureGenerator.getTextPixelBuffer(n3);
        if (this.mapcoreListener != null) {
            this.mapcoreListener.resetRenderTimeLong();
        }
        return byArray;
    }

    @Override
    public byte[] onMapCharsWidthsRequired(int n2, int[] nArray, int n3, int n4) {
        return this.mTextTextureGenerator.getCharsWidths(nArray);
    }

    @Override
    public void onClearCache(int n2) {
        VMapDataCache.getInstance().reset();
    }

    @Override
    public void onIndoorBuildingActivity(int n2, byte[] byArray) {
        if (this.mGlMapView != null) {
            try {
                this.mGlMapView.onIndoorBuildingActivity(n2, byArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void onIndoorDataRequired(int n2, int n3, String[] stringArray, int[] nArray, int[] nArray2) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        List<MapSourceGridData> list = this.getReqGridList(n3);
        if (null != list) {
            list.clear();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                list.add(new MapSourceGridData(stringArray[i2], n3, nArray[i2], nArray2[i2]));
            }
            if (n3 != 5) {
                this.processRequiredData(n2, list, n3, null);
            }
        }
    }

    private List<MapSourceGridData> parseTiles(byte[] byArray, int n2) {
        ArrayList<MapSourceGridData> arrayList = null;
        try {
            int n3 = 0;
            int n4 = byArray[n3++];
            if (n4 <= 0) {
                return null;
            }
            arrayList = new ArrayList<MapSourceGridData>();
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by2 = byArray[n3++];
                String string = new String(byArray, n3, (int)by2, "utf-8");
                n3 += by2;
                ++n3;
                arrayList.add(new MapSourceGridData(string, n2));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getCurScreenGridList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.mCurGridFillLock;
        synchronized (object) {
            for (int i2 = 0; i2 < this.mCurScreenGridsCount; ++i2) {
                arrayList.add(this.mCurScreenGirds[i2].getGridName());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCurScreenGrids(int n2) throws UnsupportedEncodingException {
        if (this.mNativeMapengineInstance == 0L) {
            return;
        }
        Object object = this.mCurGridFillLock;
        synchronized (object) {
            byte by2;
            GLMapEngine.nativeGetScreenGrids(n2, this.mNativeMapengineInstance, this.tmp_3072bytes_data, 5);
            int n3 = 0;
            int n4 = this.tmp_3072bytes_data[n3++];
            if (n4 <= 0) {
                return;
            }
            if (n4 > 200) {
                n4 = 200;
            }
            this.mCurScreenGridsCount = 0;
            for (int i2 = 0; i2 < n4 && n3 < 3072 && (by2 = this.tmp_3072bytes_data[n3++]) > 0 && by2 <= 20 && n3 + by2 <= 3072; ++i2) {
                String string = new String(this.tmp_3072bytes_data, n3, (int)by2, "utf-8");
                n3 += by2;
                ++n3;
                if (n2 == 1) {
                    this.mCurScreenGirds[this.mCurScreenGridsCount++].setGridData(string, 5);
                    continue;
                }
                if (n2 != 2) continue;
                this.mEagleEyeScreenGirds[this.mCurScreenGridsCount++].setGridData(string, 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canStopMapRender(int n2) {
        Object object = this.mut_lock;
        synchronized (object) {
            if (this.mNativeMapengineInstance != 0L) {
                return GLMapEngine.nativeCanStopRenderMap(n2, this.mNativeMapengineInstance);
            }
        }
        return true;
    }

    public void setInternaltexture(int n2, byte[] byArray, int n3) {
        if (byArray != null) {
            GLMapEngine.nativeSetInternalTexture(n2, this.mNativeMapengineInstance, byArray, n3);
        }
    }

    public synchronized void setMapCenter(int n2, int n3, int n4) {
        GLMapState.nativeSetMapCenter(this.getStateInstanceWithEngineID(n2), n3, n4);
    }

    public synchronized Point getMapCenter(int n2) {
        Point point = new Point();
        GLMapState.nativeGetMapCenter(this.getStateInstanceWithEngineID(n2), point);
        return point;
    }

    public synchronized void setMapZoom(int n2, float f2) {
        if (f2 > (float)this.getMaxZoomLevel(n2)) {
            f2 = this.getMaxZoomLevel(n2);
        }
        GLMapState.nativeSetMapZoomer(this.getStateInstanceWithEngineID(n2), f2);
    }

    public synchronized byte[] getLabelBuffer(int n2, int n3, int n4, int n5) {
        byte[] byArray = new byte[3072];
        GLMapEngine.nativeSelectMapPois(n2, this.mNativeMapengineInstance, n3, n4, n5, byArray);
        return byArray;
    }

    public void clearSelectMapPois(int n2) {
        GLMapEngine.nativeClearSelectedScenicPois(n2, this.mNativeMapengineInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMapHeatData(int n2, byte[] byArray, int n3, int n4, int n5, String string) {
        boolean bl2 = false;
        if (byArray.length == 0 || null == string || string.length() == 0) {
            return false;
        }
        Object object = this.mut_lock;
        synchronized (object) {
            if (this.mNativeMapengineInstance != 0L) {
                try {
                    byte[] byArray2 = string.getBytes("utf-8");
                    int n6 = byArray2.length;
                    int n7 = 1 + n6 + n4;
                    byte[] byArray3 = new byte[n7];
                    byArray3[0] = (byte)n6;
                    System.arraycopy(byArray2, 0, byArray3, 1, n6);
                    System.arraycopy(byArray, n3, byArray3, 1 + n6, n4);
                    boolean bl3 = bl2 = GLMapEngine.nativePutMapdata(n2, this.mNativeMapengineInstance, 12, byArray3, n5) > 0;
                    if (this.mapcoreListener != null) {
                        this.mapcoreListener.resetRenderTimeLong();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMapTMCData(int n2, int n3, byte[] byArray, String string, boolean bl2) {
        Object object = this.mut_lock;
        synchronized (object) {
            if (this.mNativeMapengineInstance != 0L) {
                GLMapEngine.nativeUpdateTmcCache(n2, this.mNativeMapengineInstance, n3, byArray, string, bl2);
                if (this.mapcoreListener != null) {
                    this.mapcoreListener.resetRenderTimeLong();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PutResourceData(int n2, byte[] byArray) {
        Object object = this.mut_lock;
        synchronized (object) {
            if (this.mNativeMapengineInstance != 0L) {
                GLMapEngine.nativePutResourceData(n2, this.mNativeMapengineInstance, byArray);
                if (this.mapcoreListener != null) {
                    this.mapcoreListener.resetRenderTimeLong();
                }
            }
        }
    }

    public void UpdateStyleOrIcons(final int n2, final String string, final int n3) {
        if (null == this.mapcoreListener || 0L == this.mNativeMapengineInstance) {
            return;
        }
        this.mapcoreListener.postQueueEvent(new Runnable(){

            public void run() {
                GLMapEngine.nativeUpdateStyleOrIcons(n2, GLMapEngine.this.mNativeMapengineInstance, string, n3);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMapData(int n2, byte[] byArray, int n3, int n4, int n5, int n6) {
        boolean bl2 = false;
        Object object = this.mut_lock;
        synchronized (object) {
            if (this.mNativeMapengineInstance != 0L) {
                if (byArray.length == n4 && n3 == 0) {
                    bl2 = GLMapEngine.nativePutMapdata(n2, this.mNativeMapengineInstance, n5, byArray, n6) > 0;
                } else {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, n3, byArray2, 0, n4);
                    boolean bl3 = bl2 = GLMapEngine.nativePutMapdata(n2, this.mNativeMapengineInstance, n5, byArray2, n6) > 0;
                }
                if (this.mapcoreListener != null) {
                    this.mapcoreListener.resetRenderTimeLong();
                }
            }
        }
        return bl2;
    }

    public void setIndoorBuildingToBeActive(int n2, String string, int n3, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        GLMapEngine.nativeSetIndoorBuildingToBeActive(n2, this.mNativeMapengineInstance, string, n3, string2);
        if (this.mapcoreListener != null) {
            this.mapcoreListener.resetRenderTimeLongLong();
        }
    }

    public void resetRenderTime(int n2) {
        if (this.mapcoreListener != null) {
            this.mapcoreListener.resetRenderTimeLongLong();
        }
    }

    public float getMapZoomer(int n2) {
        return GLMapState.nativeGetMapZoomer(this.getStateInstanceWithEngineID(n2));
    }

    public int getMaxZoomLevel(int n2) {
        return GLMapState.nativeGetMaxZoomLevel(this.getStateInstanceWithEngineID(n2));
    }

    public int getMinZoomLevel(int n2) {
        return GLMapState.nativeGetMinZoomLevel(this.getStateInstanceWithEngineID(n2));
    }

    public synchronized void setCameraDegree(int n2, float f2) {
        if (f2 == 65.0f) {
            this.setParamater(n2, 1900, 0, 0, 1, 0);
        }
        GLMapState.nativeSetCameraDegree(this.getStateInstanceWithEngineID(n2), f2);
    }

    public synchronized float getCameraDegree(int n2) {
        return GLMapState.nativeGetCameraDegree(this.getStateInstanceWithEngineID(n2));
    }

    public synchronized void setMapAngle(int n2, float f2) {
        float f3 = 0.0f;
        f3 = f2 < 0.0f ? f2 + 360.0f : (f2 >= 360.0f ? f2 - 360.0f : f2);
        GLMapState.nativeSetMapAngle(this.getStateInstanceWithEngineID(n2), f3);
    }

    public synchronized float getMapAngle(int n2) {
        return GLMapState.nativeGetMapAngle(this.getStateInstanceWithEngineID(n2));
    }

    public void screenToMapGPoint(int n2, float f2, float f3, PointF pointF) {
        GLMapState.nativeScreenToMapGPoint(this.getStateInstanceWithEngineID(n2), f2, f3, pointF);
    }

    public void p20ToMapPoint(int n2, int n3, int n4, PointF pointF) {
        GLMapState.nativeP20ToMapPoint(this.getStateInstanceWithEngineID(n2), n3, n4, pointF);
    }

    public void p20ToScreenPoint(int n2, int n3, int n4, PointF pointF) {
        GLMapState.nativeP20ToScreenPoint(this.getStateInstanceWithEngineID(n2), n3, n4, pointF);
    }

    public void mapToScreenPoint(int n2, float f2, float f3, PointF pointF) {
        GLMapState.nativeMapToScreenPoint(this.getStateInstanceWithEngineID(n2), f2, f3, pointF);
    }

    public void mapToP20Point(int n2, float f2, float f3, Point point) {
        GLMapState.nativeMapToP20Point(this.getStateInstanceWithEngineID(n2), f2, f3, point);
    }

    public void screenToP20Point(int n2, float f2, float f3, Point point) {
        GLMapState.nativeScreenToP20Point(this.getStateInstanceWithEngineID(n2), f2, f3, point);
    }

    public float getGLUnitWithWin(int n2, int n3) {
        return GLMapState.nativeGetGLUnitWithWin(this.getStateInstanceWithEngineID(n2), n3);
    }

    public float getGLUnitWithWinByY(int n2, int n3, int n4) {
        return GLMapState.nativeGetGLUnitWithWinByY(this.getStateInstanceWithEngineID(n2), n3, n4);
    }

    public void getPixel20Bound(int n2, Rect rect) {
        GLMapState.nativeGetPixel20Bound(this.getStateInstanceWithEngineID(n2), rect);
    }

    public void mapToScreenPointWithZ(int n2, float f2, float f3, float f4, PointF pointF) {
        GLMapState.nativeMapToScreenPointWithZ(this.getStateInstanceWithEngineID(n2), f2, f3, f4, pointF);
    }

    public float getGLUnitWithPixel20(int n2, int n3) {
        return GLMapState.nativeGetGLUnitWithPixel20(this.getStateInstanceWithEngineID(n2), n3);
    }

    public void clearAnimations(int n2, boolean bl2) {
        if (bl2) {
            this.map_anims_mgr.clearAnimations();
        } else if (this.mapcoreListener != null) {
            this.mapcoreListener.postQueueEvent(new Runnable(){

                public void run() {
                    GLMapEngine.this.map_anims_mgr.clearAnimations();
                }
            });
        }
    }

    public void clearAnimations(int n2, boolean bl2, int n3) {
        if (bl2) {
            this.map_anims_mgr.clearAnimations();
        } else if (this.mapcoreListener != null) {
            this.mapcoreListener.postQueueEvent(new Runnable(){

                public void run() {
                    GLMapEngine.this.map_anims_mgr.clearAnimations();
                }
            });
        }
    }

    public void AddGroupAnimation(int n2, final int n3, final float f2, final int n4, final int n5, final int n6, final int n7, boolean bl2) {
        this.mapcoreListener.postQueueEvent(new Runnable(){

            public void run() {
                ADGLMapAnimGroup aDGLMapAnimGroup = new ADGLMapAnimGroup(n3);
                aDGLMapAnimGroup.setToCameraDegree(n5, 0);
                aDGLMapAnimGroup.setToMapAngle(n4, 0);
                aDGLMapAnimGroup.setToMapLevel(f2, 0);
                aDGLMapAnimGroup.setToMapCenterGeo(n6, n7, 0);
                if (GLMapEngine.this.map_anims_mgr != null && aDGLMapAnimGroup != null && aDGLMapAnimGroup.isValid()) {
                    GLMapEngine.this.map_anims_mgr.addAnimation(aDGLMapAnimGroup);
                }
            }
        });
    }

    public void AddGeoAndScreenCenterGroupAnimation(final int n2, final int n3, final GLGeoPoint gLGeoPoint, final Point point, final boolean bl2) {
        if (null == this.mapcoreListener || null == gLGeoPoint || point == null) {
            return;
        }
        this.mapcoreListener.postQueueEvent(new Runnable(){

            public void run() {
                GLMapEngine.nativeAddGeoAndScreenCenterGroupAnimation(n2, GLMapEngine.this.mNativeMapengineInstance, n3, gLGeoPoint.x, gLGeoPoint.y, point.x, point.y, bl2);
            }
        });
    }

    public void startPivotZoomRotateAnim(final int n2, final Point point, final float f2, int n3, final int n4) {
        if (f2 == -9999.0f && n3 == -9999) {
            return;
        }
        if (n3 != -9999 && n3 < 0) {
            n3 += 360;
        }
        final int n5 = n3;
        this.mapcoreListener.postQueueEvent(new Runnable(){

            public void run() {
                GLMapEngine.nativeClearAnimation(n2, GLMapEngine.this.mNativeMapengineInstance);
                if (point != null) {
                    GLMapEngine.nativeAddZoomRotateAnimation(n2, GLMapEngine.this.mNativeMapengineInstance, n4, f2, n5, point.x, point.y);
                } else {
                    GLMapEngine.nativeAddZoomRotateAnimation(n2, GLMapEngine.this.mNativeMapengineInstance, n4, f2, n5, 0, 0);
                }
            }
        });
    }

    public void startPivotZoomAnim(final int n2, final Point point, final float f2, int n3) {
        MapConfig mapConfig;
        if (point != null && point.x <= 0 && point.y <= 0) {
            point.y = 1;
        }
        if ((mapConfig = this.mGlMapView.getMapConfig()) == null) {
            return;
        }
        if (f2 > mapConfig.getMaxZoomLevel() || f2 < mapConfig.getMinZoomLevel()) {
            return;
        }
        final int n4 = n3;
        this.mapcoreListener.postQueueEvent(new Runnable(){

            public void run() {
                GLMapEngine.nativeFinishAnimations(n2, GLMapEngine.this.mNativeMapengineInstance);
                if (point != null) {
                    GLMapEngine.nativeAddPivotZoomAnimation(n2, GLMapEngine.this.mNativeMapengineInstance, n4, f2, point.x, point.y);
                } else {
                    GLMapEngine.nativeAddPivotZoomAnimation(n2, GLMapEngine.this.mNativeMapengineInstance, n4, f2, 0, 0);
                }
            }
        });
    }

    public void startMapSlidAnim(final int n2, final Point point, final float f2, final float f3) {
        this.mapcoreListener.postQueueEvent(new Runnable(){

            public void run() {
                if (point == null) {
                    return;
                }
                try {
                    float f22;
                    GLMapEngine.this.clearAnimations(n2, true);
                    GLMapState gLMapState = new GLMapState(1, GLMapEngine.this.getMapEnginePtr());
                    gLMapState.recalculate();
                    int n22 = 12000;
                    float f32 = f2;
                    float f4 = f3;
                    float f5 = Math.abs(f32);
                    float f6 = Math.abs(f4);
                    float f7 = f22 = f5 > f6 ? f5 : f6;
                    if (f22 > (float)n22) {
                        if (f5 > f6) {
                            f32 = f32 > 0.0f ? (float)n22 : (float)(-n22);
                            f4 = (float)n22 / f5 * f4;
                        } else {
                            f32 = (float)n22 / f6 * f32;
                            f4 = f4 > 0.0f ? (float)n22 : (float)(-n22);
                        }
                    }
                    ADGLMapAnimFling aDGLMapAnimFling = new ADGLMapAnimFling(500, GLMapEngine.this.mGlMapView.getMapWidth() / 2, GLMapEngine.this.mGlMapView.getMapHeight() / 2);
                    aDGLMapAnimFling.setPositionAndVelocity(f32, f4);
                    aDGLMapAnimFling.commitAnimation(gLMapState);
                    gLMapState.recycle();
                    GLMapEngine.this.map_anims_mgr.addAnimation(aDGLMapAnimFling);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
    }

    public void FinishAnimations(final int n2, boolean bl2) {
        if (bl2) {
            GLMapEngine.nativeFinishAnimations(n2, this.mNativeMapengineInstance);
        } else if (this.mapcoreListener != null) {
            this.mapcoreListener.postQueueEvent(new Runnable(){

                public void run() {
                    GLMapEngine.nativeFinishAnimations(n2, GLMapEngine.this.mNativeMapengineInstance);
                }
            });
        }
    }

    public void setOvelayBundle(int n2, GLOverlayBundle<BaseMapOverlay<?, ?>> gLOverlayBundle) {
        if (null == this.mStateSparseArray.get(n2) || n2 < 0) {
            return;
        }
        ((GLStateInstance)this.mStateSparseArray.get((int)n2)).mOverlayBundle = gLOverlayBundle;
    }

    public void addOverlayTexture(int n2, GLTextureProperty gLTextureProperty) {
        if (null != gLTextureProperty && null != gLTextureProperty.mBitmap && !gLTextureProperty.mBitmap.isRecycled()) {
            GLMapEngine.nativeAddOverlayTexture(n2, this.mNativeMapengineInstance, gLTextureProperty.mId, gLTextureProperty.mAnchor, gLTextureProperty.mXRatio, gLTextureProperty.mYRatio, gLTextureProperty.mBitmap, gLTextureProperty.isGenMimps, gLTextureProperty.isRepeat);
        }
    }

    public GLOverlayBundle<BaseMapOverlay<?, ?>> getOvelayBundle(int n2) {
        if (null == this.mStateSparseArray.get(n2) || n2 < 0) {
            return null;
        }
        return ((GLStateInstance)this.mStateSparseArray.get((int)n2)).mOverlayBundle;
    }

    public long getGlOverlayMgrPtr(int n2) {
        return GLMapEngine.nativeGetGlOverlayMgrPtr(n2, this.mNativeMapengineInstance);
    }

    public long getMapEnginePtr() {
        return this.mNativeMapengineInstance;
    }

    public long createOverlay(int n2, int n3) {
        return GLMapEngine.nativeCreateOverlay(n2, this.mNativeMapengineInstance, n3);
    }

    public static void destoryOverlay(int n2, long l2) {
        GLMapEngine.nativeDestoryOverlay(n2, l2);
    }

    public synchronized void setParamater(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetParmater(n2, this.mNativeMapengineInstance, n3, n4, n5, n6, n7);
        }
    }

    public void addPoiFilter(int n2, int n3, int n4, int n5, float f2, float f3, String string, int n6) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeAddPoiFilter(n2, this.mNativeMapengineInstance, n3, n4, n5, f2, f3, 3.0f, 20.0f, string, n6);
        }
    }

    public void removePoiFilter(int n2, String string) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeRemovePoiFilter(n2, this.mNativeMapengineInstance, string);
        }
    }

    public void clearPoiFilter(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeClearPoiFilter(n2, this.mNativeMapengineInstance);
        }
    }

    public void setSearchedSubwayIds(int n2, String[] stringArray) {
        if (stringArray != null && this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetSearchedSubwayIds(n2, this.mNativeMapengineInstance, stringArray);
        }
    }

    public void setNaviRouteBoardDataListener(RouteBoardDataListener routeBoardDataListener) {
        this.mBoardDataListener = routeBoardDataListener;
    }

    @Override
    public void onRoadTips(int n2, byte[] byArray) {
        if (null != this.mBoardDataListener && null != byArray && byArray.length > 0) {
            this.mBoardDataListener.setRouteBoardData(n2, byArray);
        }
    }

    @Override
    public void onOfflineMap(int n2, String string, int n3) {
        if (string.length() != 0 && null != this.mMapListener) {
            this.mMapListener.onOfflineMap(n2, string, n3);
        }
    }

    public void setScenicWidgetFilter(int n2, ScenicWidgetItem scenicWidgetItem) {
        if (scenicWidgetItem == null) {
            GLMapEngine.nativeSetScenicFilter(n2, this.mNativeMapengineInstance, 0, null);
            return;
        }
        int[] nArray = new int[scenicWidgetItem.mFilters.length * 3];
        for (int i2 = 0; i2 < scenicWidgetItem.mFilters.length; ++i2) {
            nArray[i2 * 3] = scenicWidgetItem.mFilters[i2].mMainKey;
            nArray[i2 * 3 + 1] = scenicWidgetItem.mFilters[i2].mSubKey;
            nArray[i2 * 3 + 2] = scenicWidgetItem.mFilters[i2].mPoiFlag;
        }
        GLMapEngine.nativeSetScenicFilter(n2, this.mNativeMapengineInstance, scenicWidgetItem.mItemIndex, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScenicData(int n2, byte[] byArray, int n3, String string) {
        Object object = this.mut_lock;
        synchronized (object) {
            if (this.mNativeMapengineInstance != 0L) {
                try {
                    byte[] byArray2 = string.getBytes("utf-8");
                    byte by2 = (byte)byArray2.length;
                    int n4 = by2 + n3 + 1;
                    byte[] byArray3 = new byte[n4];
                    byArray3[0] = by2;
                    System.arraycopy(byArray2, 0, byArray3, 1, by2);
                    System.arraycopy(byArray, 0, byArray3, 1 + by2, n3);
                    GLMapEngine.nativePutMapdata(n2, this.mNativeMapengineInstance, 101, byArray3, 0);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public void setShowMask(int n2, boolean bl2) {
        GLMapEngine.nativeSetShowMask(n2, this.mNativeMapengineInstance, bl2);
    }

    public boolean isShowMask(int n2) {
        return GLMapEngine.nativeIsShowMask(n2, this.mNativeMapengineInstance);
    }

    public void setMaskColor(int n2, int n3) {
        GLMapEngine.nativeSetMaskColor(n2, this.mNativeMapengineInstance, n3);
    }

    public boolean isShowLandMarkBuildingPoi(int n2) {
        return GLMapEngine.nativeIsShowLandMarkBuildingPoi(n2, this.mNativeMapengineInstance);
    }

    public void setShowFeatureSpotIcon(boolean bl2) {
    }

    public boolean isShowFeatureSpotIcon(int n2) {
        return GLMapEngine.nativeIsShowFeatureSpotIcon(n2, this.mNativeMapengineInstance);
    }

    @Override
    public void onScenicActive(final int n2, byte[] byArray) {
        ScenicInfor scenicInfor = null;
        if (null != byArray) {
            try {
                int n3 = 0;
                byte by2 = byArray[n3++];
                scenicInfor = new ScenicInfor();
                scenicInfor.mAoiId = new String(byArray, n3, (int)by2, "utf-8");
                n3 += by2;
                scenicInfor.mHasWidget = byArray[n3++] != 0;
                scenicInfor.mHasGuideMap = byArray[n3++] != 0;
                scenicInfor.mHasGuideVoice = byArray[n3++] != 0;
                scenicInfor.mHasFootPrint = byArray[n3++] != 0;
                scenicInfor.mHasThermal = byArray[n3++] != 0;
                scenicInfor.mHasRoute = byArray[n3++] != 0;
                scenicInfor.mRouteNumber = byArray[n3++];
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        final ScenicInfor scenicInfor2 = scenicInfor;
        if (this.mapcoreListener != null) {
            this.mapcoreListener.postOnUIThread(new Runnable(){

                public void run() {
                    if (null != GLMapEngine.this.mScenicListener) {
                        GLMapEngine.this.mScenicListener.onScenicActive(n2, scenicInfor2);
                    }
                }
            });
        }
    }

    public void setScenicListener(ScenicListener scenicListener) {
        this.mScenicListener = scenicListener;
    }

    public void setScenicGuideEnable(int n2, boolean bl2) {
        this.setParamater(n2, 1027, bl2 ? 1 : 0, 0, 0, 0);
    }

    public void setMapListener(IAMapListener iAMapListener) {
        this.mAMapListener = iAMapListener;
    }

    public void setMapHeatListener(MapHeatListener mapHeatListener) {
        this.mMapHeatListener = mapHeatListener;
    }

    public void setMapHeatEnable(int n2, boolean bl2) {
        this.setParamater(n2, 2015, bl2 ? 1 : 0, 0, 0, 0);
    }

    public void setMapHeatPoiRegion(int n2, String string, int[] nArray, int[] nArray2) {
        GLMapEngine.nativeSetMapHeatPoiRegion(n2, this.mNativeMapengineInstance, string, nArray, nArray2);
    }

    public void addLabels3rd(int n2, int n3, Label3rd[] label3rdArray, boolean bl2) {
        GLMapEngine.nativeAddLabels3rd(n2, this.mNativeMapengineInstance, n3, label3rdArray, bl2);
    }

    public void clearLabels3rd(int n2, int n3, boolean bl2) {
        GLMapEngine.nativeClearLabels3rd(n2, this.mNativeMapengineInstance, n3, bl2);
    }

    @Override
    public void onMapHeatActive(int n2, boolean bl2) {
        if (null != this.mMapHeatListener) {
            this.mMapHeatListener.onMapHeatActive(n2, bl2);
        }
    }

    public boolean doMapDataControl(int n2, int n3, int n4, int n5, int n6) {
        if (this.mNativeMapengineInstance != 0L && n3 == 1 && n4 == 2 && n6 == 1) {
            MessageDataThread messageDataThread = new MessageDataThread(n2, this, n3, n4, n5, n6);
            messageDataThread.start();
        }
        return true;
    }

    public void setMapDataConrol(final int n2, final int n3, final int n4, final int n5, final int n6, final byte[] byArray) {
        if (this.mNativeMapengineInstance != 0L && null != this.mapcoreListener) {
            this.mapcoreListener.postQueueEvent(new Runnable(){

                public void run() {
                    GLMapEngine.nativeMapDataControl(n2, GLMapEngine.this.mNativeMapengineInstance, n3, n4, n5, n6, byArray);
                }
            });
        }
    }

    @Override
    public void onTransferParam(int n2, int[] nArray) {
        if (nArray == null) {
            return;
        }
        block0 : switch (nArray[0]) {
            case 10001: {
                boolean bl2 = nArray[1] != 0;
                break;
            }
            case 10000: {
                if (this.mapcoreListener == null) break;
                this.mapcoreListener.resetRenderTime(false);
                break;
            }
            case 10002: {
                if (this.mapcoreListener == null) break;
                switch (nArray[1]) {
                    default: {
                        this.mapcoreListener.resetRenderTime(false);
                        break block0;
                    }
                    case 2: {
                        this.mapcoreListener.resetRenderTimeLong();
                        break block0;
                    }
                    case 3: 
                }
                this.mapcoreListener.resetRenderTimeLongLong();
            }
        }
    }

    @Override
    public void onOpenLayerDataRequired(int n2, String string, int n3, int n4, int n5, String[] stringArray) {
        OpenLayerMapLoader openLayerMapLoader = new OpenLayerMapLoader(n2, this, string, n3, n4, n5);
        if (openLayerMapLoader.createDownUrl(stringArray) && this.mConnectionManager != null) {
            openLayerMapLoader.setGetRequestMethod(false);
            this.mConnectionManager.insertConntionTask(openLayerMapLoader);
        }
    }

    @Override
    public void onLoadTextureByName(int n2, String string, int n3) {
    }

    @Override
    public byte[] OnMapLoadResourceByName(int n2, String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        if (this.mGlMapView.getMapConfig().isCustomStyleEnable()) {
            if (string.startsWith("icons_5")) {
                byArray = this.getMapCacheMgr().getOtherResDataFromDisk(this.mGlMapView.getMapConfig().getCustomTextureResourcePath());
            } else if (string.startsWith("bktile")) {
                byArray = this.getMapCacheMgr().getOtherResData(string);
                int n3 = this.mGlMapView.getMapConfig().getCustomBackgroundColor();
                if (n3 != -1) {
                    byArray = this.writeCustomBackground(byArray, n3);
                }
            }
            if (byArray != null) {
                return byArray;
            }
        }
        byArray = this.getMapCacheMgr().getOtherResData(string);
        return byArray;
    }

    public byte[] writeCustomBackground(byte[] byArray, int n2) {
        byte[] byArray2 = null;
        try {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
            int n3 = bitmap.getWidth();
            int n4 = bitmap.getHeight();
            for (int i2 = 1; i2 < n3; ++i2) {
                for (int i3 = 1; i3 < n4; ++i3) {
                    bitmap2.setPixel(i2, i3, n2);
                }
            }
            byArray2 = this.bitmap2bytes(bitmap2);
            if (byArray2 == null) {
                byArray2 = byArray;
            }
            bitmap2.recycle();
            bitmap.recycle();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            byArray2 = byArray;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] bitmap2bytes(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void OnMapResourceRequired(int n2, String string, int n3) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile = new MapTilsCacheAndResManager.RetStyleIconsFile();
        if (null == this.mCacheMgr) {
            return;
        }
        retStyleIconsFile.fullName = string;
        String[] stringArray = string.split("_|\\.");
        if (stringArray.length < 2) {
            return;
        }
        retStyleIconsFile.name = stringArray[0] + "_" + stringArray[1];
        try {
            retStyleIconsFile.clientVersion = Integer.parseInt(stringArray[2]);
            retStyleIconsFile.serverVersion = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 1;
        }
        catch (NumberFormatException numberFormatException) {
            retStyleIconsFile.clientVersion = 1;
            retStyleIconsFile.serverVersion = 1;
        }
        retStyleIconsFile.type = n3;
        String string2 = this.getMapSvrAddress();
        new StylesIconsUpdate(n2, this, retStyleIconsFile).start(string2 + "/ws/mps/vmap?");
    }

    @Override
    public void OnMapResourceReLoad(int n2, String string, int n3) {
        this.UpdateStyleOrIcons(n2, string, n3);
    }

    public void appendOpenLayer(int n2, byte[] byArray) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeAppendOpenLayer(n2, this.mNativeMapengineInstance, byArray);
        }
    }

    public void deleteOpenLayer(int n2, int n3) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeDeleteOpenLayer(n2, this.mNativeMapengineInstance, n3);
        }
    }

    public void onClearOverlayTexture(int n2) {
        GLMapEngine.nativeClearOverlayTexture(n2, this.mNativeMapengineInstance);
    }

    public int IsSupportRealcity(int n2, int n3) {
        return GLMapEngine.nativeIsSupportRealcity(n2, this.mNativeMapengineInstance, n3);
    }

    public String GetRealCityDataVerSion(int n2, int n3) {
        return GLMapEngine.nativeGetRealCityDataVerSion(n2, this.mNativeMapengineInstance, n3);
    }

    public int IsRealCityAnimateFinish(int n2) {
        return GLMapEngine.nativeIsRealCityAnimateFinish(n2, this.mNativeMapengineInstance);
    }

    public boolean SetMapModeAndStyle(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, StyleItem[] styleItemArray) {
        int[] nArray = new int[]{n3, n4, n5, 0, 0};
        return GLMapEngine.nativeSetMapModeAndStyle(n2, this.mNativeMapengineInstance, nArray, bl2, bl3, styleItemArray);
    }

    public boolean IsSkinExist(int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = new int[]{n3, n4, n5, n6, n7};
        return GLMapEngine.nativeIsSkinExist(n2, this.mNativeMapengineInstance, nArray);
    }

    public void createEngineWithFrame(int n2, Rect rect, int n3, int n4) {
        if (null != rect) {
            if (n2 == 2 && null == this.mEagleEyeScreenGirds) {
                this.mEagleEyeScreenGirds = new MapSourceGridData[200];
                for (int i2 = 0; i2 < 200; ++i2) {
                    this.mEagleEyeScreenGirds[i2] = new MapSourceGridData();
                }
            }
            if (this.mCacheMgr == null) {
                this.mCacheMgr = new MapTilsCacheAndResManagerImpl(this.mContext, GLMapEngine.nativeGetMapCachePath(n2, this.mNativeMapengineInstance));
                this.mCacheMgr.checkDir();
            }
            GLMapEngine.nativeCreateEngineWithFrame(n2, this.mNativeMapengineInstance, rect.left, rect.top, rect.width(), rect.height(), n3, n4, false);
            GLStateInstance gLStateInstance = new GLStateInstance(n2, GLMapEngine.nativeGetMapStateInstance(n2, this.mNativeMapengineInstance));
            this.mStateSparseArray.put(n2, (Object)gLStateInstance);
        }
    }

    public void removeEngine(int n2) {
        GLMapEngine.nativeRemoveEngine(n2, this.mNativeMapengineInstance);
        if (null != this.mStateSparseArray) {
            this.mStateSparseArray.remove(n2);
        }
    }

    public void setEngineVisible(int n2, boolean bl2) {
        GLMapEngine.nativeSetServiceViewVisible(n2, bl2, this.mNativeMapengineInstance);
    }

    public int[] getEngineIDs() {
        return GLMapEngine.nativeGetEngineIDArray(this.mNativeMapengineInstance);
    }

    public int getEngineIDWithType(int n2) {
        int n3 = 0;
        switch (n2) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        return n3;
    }

    public boolean isEngineCreated(int n2) {
        int[] nArray = this.getEngineIDs();
        if (null != nArray && nArray.length > 0) {
            for (int n3 : nArray) {
                if (n3 != n2) continue;
                return true;
            }
        }
        return false;
    }

    private long getStateInstanceWithEngineID(int n2) {
        if (null == this.mStateSparseArray.get(n2) || n2 < 0) {
            return 0L;
        }
        return ((GLStateInstance)this.mStateSparseArray.get(n2)).getStateInstance();
    }

    public int getEngineIDWithGestureInfo(EAMapPlatformGestureInfo eAMapPlatformGestureInfo) {
        if (this.mNativeMapengineInstance != 0L) {
            return GLMapEngine.nativeGetEngineIDWithGestureInfo(this.mNativeMapengineInstance, eAMapPlatformGestureInfo);
        }
        return 1;
    }

    public void setBackGroundColor(int n2, float f2, float f3, float f4, float f5) {
        GLMapEngine.nativeSetBackGroundColor(n2, this.mNativeMapengineInstance, f2, f3, f4, f5);
    }

    public void setServiceViewRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GLMapEngine.nativeSetServiceViewRect(n2, this.mNativeMapengineInstance, n3, n4, n5, n6, n7, n8);
    }

    public boolean getSrvViewStateBoolValue(int n2, int n3) {
        return GLMapEngine.nativeGetSrvViewStateBoolValue(n2, this.mNativeMapengineInstance, n3);
    }

    public int getSrvViewStateIntValue(int n2, int n3) {
        return GLMapEngine.nativeGetSrvViewStateIntValue(n2, this.mNativeMapengineInstance, n3);
    }

    public float getSrvViewStateFloatValue(int n2, int n3) {
        return GLMapEngine.nativeGetSrvViewStateFloatValue(n2, this.mNativeMapengineInstance, n3);
    }

    public void setSrvViewStateBoolValue(int n2, int n3, boolean bl2) {
        GLMapEngine.nativeSetSrvViewStateBoolValue(n2, this.mNativeMapengineInstance, n3, bl2);
    }

    public void setSrvViewStateIntValue(int n2, int n3, int n4) {
        GLMapEngine.nativeSetSrvViewStateIntValue(n2, this.mNativeMapengineInstance, n3, n4);
    }

    public void setSrvViewStateFloatValue(int n2, int n3, float f2) {
        GLMapEngine.nativeSetSrvViewStateFloatValue(n2, this.mNativeMapengineInstance, n3, f2);
    }

    public int[] getMapModeState(int n2, boolean bl2) {
        return GLMapEngine.nativeGetMapModeState(n2, this.mNativeMapengineInstance, bl2);
    }

    public boolean getIsProcessBuildingMark(int n2) {
        return GLMapEngine.nativeGetIsProcessBuildingMark(n2, this.mNativeMapengineInstance);
    }

    @Override
    public void OnMapAnimationFinished(int n2, int n3) {
        if (null != this.mMapListener && -1 != n3) {
            this.mMapListener.onMapAnimationFinished(n2, n3);
        }
    }

    public void onLogReport(int n2, int n3, int n4, String string) {
    }

    public void onLogOfflineDataStatusReport(int n2, String string, String string2, String string3) {
    }

    private static native long nativeCreate(String var0, String var1, int var2);

    private static native String nativeGetMapCachePath(int var0, long var1);

    private static native void nativeChangeMapEnv(int var0, long var1, String var3);

    private static native void nativeDestroy(long var0);

    public static native void nativeLoadStartResource(int var0, long var1, GLMapEngine var3, int[] var4, int var5, int var6);

    private static native void nativeCreateSurface(int var0, long var1, GLMapEngine var3);

    private static native void nativeChangeSurface(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8, GLMapEngine var9);

    private static native void nativeDestorySurface(long var0, GLMapEngine var2);

    private static native void nativeDrawFrame(long var0);

    private static native void nativePostDrawFrame(long var0);

    private static native boolean nativeCanStopRenderMap(int var0, long var1);

    private static native int nativePutMapdata(int var0, long var1, int var3, byte[] var4, int var5);

    private static native void nativeSetParmater(int var0, long var1, int var3, int var4, int var5, int var6, int var7);

    private static native long nativeGetMapStateInstance(int var0, long var1);

    private static native int nativeSelectMapPois(int var0, long var1, int var3, int var4, int var5, byte[] var6);

    private static native void nativeClearSelectedScenicPois(int var0, long var1);

    private static native void nativeSetScenicFilter(int var0, long var1, int var3, int[] var4);

    private static native void nativeGetScreenGrids(int var0, long var1, byte[] var3, int var4);

    private static native void nativeAddPoiFilter(int var0, long var1, int var3, int var4, int var5, float var6, float var7, float var8, float var9, String var10, int var11);

    private static native void nativeRemovePoiFilter(int var0, long var1, String var3);

    private static native void nativeClearPoiFilter(int var0, long var1);

    private static native void nativeSetSearchedSubwayIds(int var0, long var1, String[] var3);

    private static native void nativeSetIndoorBuildingToBeActive(int var0, long var1, String var3, int var4, String var5);

    private static native int nativeIndoorBuildingHitTest(int var0, long var1, int var3, int var4, byte[] var5);

    private static native void nativeSetShowMask(int var0, long var1, boolean var3);

    private static native boolean nativeIsShowMask(int var0, long var1);

    private static native void nativeSetMaskColor(int var0, long var1, int var3);

    private static native boolean nativeIsShowLandMarkBuildingPoi(int var0, long var1);

    private static native void nativeSetShowFeatureSpotIcon(int var0, long var1, boolean var3);

    private static native boolean nativeIsShowFeatureSpotIcon(int var0, long var1);

    private static native void nativeSetMapHeatPoiRegion(int var0, long var1, String var3, int[] var4, int[] var5);

    private static native String nativeGetMapHeatPoiId(int var0, long var1);

    private static native void nativeAddMapGestureMsg(int var0, long var1, int var3, float var4, float var5, float var6);

    private static native void nativeAddMapNaviMsg(int var0, long var1, long var3, long var5, Point var7, Point var8, float var9, float var10, float var11, float var12, float var13);

    private static native void nativeAddFlingAnimation(int var0, long var1, int var3, int var4, int var5);

    private static native void nativeAddPivotZoomAnimation(int var0, long var1, int var3, float var4, int var5, int var6);

    private static native void nativeAddZoomRotateAnimation(int var0, long var1, int var3, float var4, int var5, int var6, int var7);

    private static native void nativeAddGroupAnimation(int var0, long var1, int var3, int var4, float var5, int var6, int var7, int var8, int var9, boolean var10);

    private static native void nativeAddGeoAndScreenCenterGroupAnimation(int var0, long var1, int var3, int var4, int var5, int var6, int var7, boolean var8);

    private static native void nativeClearAnimation(int var0, long var1);

    private static native void nativeClearAnimationByType(int var0, long var1, int var3);

    private static native void nativeFinishAnimations(int var0, long var1);

    private static native void nativeClearAllMessage(int var0, long var1);

    private static native int nativeGetAnimationCount(int var0, long var1);

    private static native int nativeGetGestureMsgCount(int var0, long var1);

    private static native boolean nativeAddOverlayTexture(int var0, long var1, int var3, int var4, float var5, float var6, Bitmap var7, boolean var8, boolean var9);

    private static native void nativeClearOverlayTexture(int var0, long var1);

    private static native long nativeGetGlOverlayMgrPtr(int var0, long var1);

    protected static native long nativeCreateOverlay(int var0, long var1, int var3);

    protected static native void nativeDestoryOverlay(int var0, long var1);

    public static native String nativeGetMapEngineVersion(int var0);

    private static native void nativeAddLabels3rd(int var0, long var1, int var3, Label3rd[] var4, boolean var5);

    private static native void nativeClearLabels3rd(int var0, long var1, int var3, boolean var4);

    private static native boolean nativeMapDataControl(int var0, long var1, int var3, int var4, int var5, int var6, byte[] var7);

    private static native void nativeAppendOpenLayer(int var0, long var1, byte[] var3);

    private static native boolean nativeDeleteOpenLayer(int var0, long var1, int var3);

    private static native void nativeInsertOpenLayer(int var0, long var1, byte[] var3, int var4);

    private static native void nativeSetInternalTexture(int var0, long var1, byte[] var3, int var4);

    private static native int nativeIsSupportRealcity(int var0, long var1, int var3);

    private static native int nativeIsRealCityAnimateFinish(int var0, long var1);

    private static native String nativeGetRealCityDataVerSion(int var0, long var1, int var3);

    private static native int nativeTmcCacheCheckValid(int var0, long var1, String var3, boolean var4, boolean var5, byte[] var6);

    private static native void nativeUpdateTmcCache(int var0, long var1, int var3, byte[] var4, String var5, boolean var6);

    private static native boolean nativeSetMapModeAndStyle(int var0, long var1, int[] var3, boolean var4, boolean var5, StyleItem[] var6);

    private static native void nativePutResourceData(int var0, long var1, byte[] var3);

    private static native void nativeUpdateStyleOrIcons(int var0, long var1, String var3, int var4);

    private static native boolean nativeIsSkinExist(int var0, long var1, int[] var3);

    private static native int nativeCreateEngineWithFrame(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private static native void nativeAddEngine(int var0);

    private static native void nativeInsertEngine(int var0, long var1);

    private static native void nativeRemoveEngine(int var0, long var1);

    private static native void nativeSetServiceViewVisible(int var0, boolean var1, long var2);

    private static native int[] nativeGetEngineIDArray(long var0);

    private static native int nativeGetEngineIDWithGestureInfo(long var0, EAMapPlatformGestureInfo var2);

    private static native void nativeSetBackGroundColor(int var0, long var1, float var3, float var4, float var5, float var6);

    private static native void nativeSetServiceViewRect(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native boolean nativeGetSrvViewStateBoolValue(int var0, long var1, int var3);

    private static native void nativeSetSrvViewStateBoolValue(int var0, long var1, int var3, boolean var4);

    private static native int nativeGetSrvViewStateIntValue(int var0, long var1, int var3);

    private static native void nativeSetSrvViewStateIntValue(int var0, long var1, int var3, int var4);

    private static native float nativeGetSrvViewStateFloatValue(int var0, long var1, int var3);

    private static native void nativeSetSrvViewStateFloatValue(int var0, long var1, int var3, float var4);

    private static native int[] nativeGetMapModeState(int var0, long var1, boolean var3);

    private static native boolean nativeGetIsProcessBuildingMark(int var0, long var1);

    private static native void nativePushRendererState(int var0, long var1);

    private static native void nativePopRenderState(int var0, long var1);
}

