import { GeolocationError, GeoOptions } from 'react-native';
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 2017/4/6
 */
export default class AmapLocation {
    static setApiKey({webApiKey, androidApiKey}: {
        webApiKey: any;
        androidApiKey: any;
    }): void;
    /**
     * 高德定位SDK获取当前的地理位置
     * @param success 成功回调函数
     * @param error 失败回调函数
     * @param options 参数
     */
    static getCurrentPosition(success: Function, error?: (error: GeolocationError) => void, options?: GeoOptions): void;
    static watchPosition(success: Function, error?: (error: GeolocationError) => void, options?: GeoOptions): number;
    static clearWatch(id: any): void;
}
