/// <reference types="react" />
import * as React from 'react';
import RootManager from './RootManager';
export declare const CREATE_EVENT = "ROOT_ELEMENT_CREATE";
export declare const UPDATE_EVENT = "ROOT_ELEMENT_UPDATE";
export declare function createRootView(RootView: any, props: any): RootManager;
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/8/11
 */
export default function createRootNode<P, S>(RootView: any): {
    new (props?: P, context?: any): {
        manager: RootManager;
        componentWillMount(): void;
        componentWillUpdate(nextProps: any): void;
        componentWillUnmount(): void;
        render(): JSX.Element;
        setState<K extends keyof S>(f: (prevState: S, props: P) => Pick<S, K>, callback?: () => any): void;
        setState<K extends keyof S>(state: Pick<S, K>, callback?: () => any): void;
        forceUpdate(callBack?: () => any): void;
        props: Readonly<{
            children?: React.ReactNode;
        }> & Readonly<P>;
        state: Readonly<S>;
        context: any;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<P>, nextContext: any): void;
        shouldComponentUpdate?(nextProps: Readonly<P>, nextState: Readonly<S>, nextContext: any): boolean;
        componentDidUpdate?(prevProps: Readonly<P>, prevState: Readonly<S>, prevContext: any): void;
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
    };
};
