/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.glanimation;

import android.graphics.PointF;
import android.os.SystemClock;
import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.ae.gmap.glanimation.ADGLAnimation;
import com.autonavi.ae.gmap.glanimation.ADGLAnimationParam1V;
import com.autonavi.ae.gmap.glanimation.ADGLAnimationParam2V;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.IPoint;

public class ADGLMapAnimGroup
extends ADGLAnimation {
    public static final int CAMERA_MAX_DEGREE = 60;
    public static final int CAMERA_MIN_DEGREE = 0;
    public static final int MAXMAPLEVEL = 20;
    public static final int MINMAPLEVEL = 3;
    boolean _hasCheckParams;
    boolean _needZoom;
    boolean _hasMidZoom;
    ADGLAnimationParam1V _zoomStartParam = null;
    ADGLAnimationParam1V _zoomEndParam = null;
    int _midZoomDuration;
    int _startZoomDuration;
    int _endZoomDuration;
    public boolean _needMove;
    ADGLAnimationParam2V _moveParam = null;
    boolean _needRotateMap;
    ADGLAnimationParam1V _rotateMapParam = null;
    boolean _needRotateCamera;
    ADGLAnimationParam1V _rotateCameraParam = null;

    public ADGLMapAnimGroup(int n2) {
        this.reset();
        this._duration = n2;
    }

    public void setDuration(int n2) {
        this._duration = n2;
    }

    public void reset() {
        this._isOver = false;
        this._hasCheckParams = false;
        this._needZoom = false;
        this._needMove = false;
        this._moveParam = null;
        this._needRotateMap = false;
        this._rotateMapParam = null;
        this._hasMidZoom = false;
        this._duration = 0;
        if (this._rotateMapParam != null) {
            this._rotateMapParam.reset();
        }
        if (this._moveParam != null) {
            this._moveParam.reset();
        }
        if (this._zoomStartParam != null) {
            this._zoomStartParam.reset();
        }
        if (this._zoomEndParam != null) {
            this._zoomEndParam.reset();
        }
        if (this._rotateCameraParam != null) {
            this._rotateCameraParam.reset();
        }
    }

    public boolean isValid() {
        return this._needRotateCamera || this._needRotateMap || this._needMove || this._needZoom;
    }

    public void setToMapAngle(float f2, int n2) {
        f2 %= 360.0f;
        this._needRotateMap = true;
        if (this._rotateMapParam == null) {
            this._rotateMapParam = new ADGLAnimationParam1V();
        }
        float f3 = f2;
        this._rotateMapParam.reset();
        this._rotateMapParam.setInterpolatorType(n2, 1.0f);
        this._rotateMapParam.setToValue(f3);
    }

    public void setToMapCenterGeo(int n2, int n3, int n4) {
        if (n2 > 0 && n3 > 0) {
            this._needMove = true;
            if (this._moveParam == null) {
                this._moveParam = new ADGLAnimationParam2V();
            }
            this._moveParam.reset();
            this._moveParam.setInterpolatorType(n4, 1.0f);
            this._moveParam.setToValue(n2, n3);
        }
    }

    public void setToMapLevel(float f2, int n2) {
        this._needZoom = true;
        this._midZoomDuration = 0;
        this._hasMidZoom = false;
        if (ADGLMapAnimGroup.checkLevel(f2)) {
            this.initZoomStartParam(f2, n2);
        } else {
            this._needZoom = false;
        }
    }

    public void setToMapLevel(float f2, float f3, int n2) {
        this._needZoom = true;
        this._midZoomDuration = 0;
        this._hasMidZoom = false;
        if (n2 > 0 && n2 < this._duration) {
            this._midZoomDuration = n2;
        }
        if (ADGLMapAnimGroup.checkLevel(f2) && ADGLMapAnimGroup.checkLevel(f3)) {
            this._hasMidZoom = true;
            this.initZoomStartParam(f3, 0);
            this.initZoomEndParam(f3, f2, 0);
        } else if (ADGLMapAnimGroup.checkLevel(f2)) {
            this._hasMidZoom = false;
            this.initZoomStartParam(f2, 0);
        } else if (ADGLMapAnimGroup.checkLevel(f3)) {
            this._hasMidZoom = false;
            this.initZoomStartParam(f3, 0);
        } else {
            this._needZoom = false;
        }
    }

    public void setToCameraDegree(float f2, int n2) {
        this._needRotateCamera = false;
        if (f2 <= 60.0f && f2 >= 0.0f) {
            this._needRotateCamera = true;
            if (this._rotateCameraParam == null) {
                this._rotateCameraParam = new ADGLAnimationParam1V();
            }
            this._rotateCameraParam.reset();
            this._rotateCameraParam.setInterpolatorType(n2, 1.0f);
            this._rotateCameraParam.setToValue(f2);
        }
    }

    public static boolean checkLevel(float f2) {
        return f2 >= 3.0f && f2 <= 20.0f;
    }

    private void initZoomStartParam(float f2, int n2) {
        if (this._zoomStartParam == null) {
            this._zoomStartParam = new ADGLAnimationParam1V();
        }
        this._zoomStartParam.reset();
        this._zoomStartParam.setInterpolatorType(n2, 1.0f);
        this._zoomStartParam.setToValue(f2);
    }

    private void initZoomEndParam(float f2, float f3, int n2) {
        if (this._zoomEndParam == null) {
            this._zoomEndParam = new ADGLAnimationParam1V();
        }
        this._zoomEndParam.reset();
        this._zoomEndParam.setInterpolatorType(n2, 1.0f);
        this._zoomEndParam.setToValue(f3);
        this._zoomEndParam.setFromValue(f2);
    }

    public void commitAnimation(Object object) {
        float f2;
        this._isOver = true;
        this._hasCheckParams = false;
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (this._needZoom) {
            float f3;
            if (this._zoomStartParam == null) {
                this._hasCheckParams = true;
                return;
            }
            f2 = gLMapState.getMapZoomer();
            this._zoomStartParam.setFromValue(f2);
            if (this._hasMidZoom) {
                f3 = this._zoomStartParam.getToValue() - f2;
                float f4 = this._zoomEndParam.getFromValue() - this._zoomEndParam.getToValue();
                if ((double)Math.abs(f3) < 1.0E-6 || (double)Math.abs(f4) < 1.0E-6) {
                    this._hasMidZoom = false;
                    this._zoomStartParam.setToValue(this._zoomEndParam.getToValue());
                    this._zoomStartParam.needToCaculate();
                    this._zoomEndParam = null;
                } else {
                    this._zoomStartParam.needToCaculate();
                    this._zoomEndParam.needToCaculate();
                }
            }
            if (!this._hasMidZoom && (double)Math.abs(f3 = this._zoomStartParam.getFromValue() - this._zoomStartParam.getToValue()) < 1.0E-6) {
                this._needZoom = false;
            }
            if (this._needZoom) {
                if (this._hasMidZoom) {
                    this._endZoomDuration = this._startZoomDuration = this._duration - this._midZoomDuration >> 1;
                } else {
                    this._startZoomDuration = this._duration;
                }
            }
        }
        if (this._needMove && this._moveParam != null) {
            IPoint iPoint = new IPoint();
            gLMapState.getGeoCenter(iPoint);
            int n2 = iPoint.x;
            int n3 = iPoint.y;
            this._moveParam.setFromValue(n2, n3);
            this._needMove = this._moveParam.needToCaculate();
        }
        if (this._needRotateMap && this._rotateMapParam != null) {
            int n4;
            f2 = gLMapState.getMapAngle();
            float f5 = this._rotateMapParam.getToValue();
            if (f2 > 180.0f && f5 == 0.0f) {
                f5 = 360.0f;
            }
            if ((n4 = (int)f5 - (int)f2) > 180) {
                f5 -= 360.0f;
            } else if (n4 < -180) {
                f5 += 360.0f;
            }
            this._rotateMapParam.setFromValue(f2);
            this._rotateMapParam.setToValue(f5);
            this._needRotateMap = this._rotateMapParam.needToCaculate();
        }
        if (this._needRotateCamera && this._rotateCameraParam != null) {
            f2 = gLMapState.getCameraHeaderAngle();
            this._rotateCameraParam.setFromValue(f2);
            this._needRotateCamera = this._rotateCameraParam.needToCaculate();
        }
        this._isOver = !this._needMove && !this._needZoom && !this._needRotateMap && !this._needRotateCamera;
        this._hasCheckParams = true;
        this._startTime = SystemClock.uptimeMillis();
    }

    public void doAnimation(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this._hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this._isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this._offsetTime = l2 - this._startTime;
        if ((float)this._duration == 0.0f) {
            this._isOver = true;
            return;
        }
        float f2 = (float)this._offsetTime / (float)this._duration;
        if (f2 > 1.0f) {
            f2 = 1.0f;
            this._isOver = true;
        } else if (f2 < 0.0f) {
            this._isOver = true;
            return;
        }
        if (this._needZoom) {
            float f3 = gLMapState.getMapZoomer();
            if (this._hasMidZoom) {
                float f4 = 0.0f;
                if (this._offsetTime <= (long)this._startZoomDuration) {
                    f4 = (float)this._offsetTime / (float)this._startZoomDuration;
                    this._zoomStartParam.setNormalizedTime(f4);
                    f3 = this._zoomStartParam.getCurValue();
                } else if (this._offsetTime <= (long)(this._startZoomDuration + this._midZoomDuration)) {
                    f3 = this._zoomStartParam.getToValue();
                } else {
                    f4 = (float)(this._offsetTime - (long)this._startZoomDuration - (long)this._midZoomDuration) / (float)this._endZoomDuration;
                    this._zoomEndParam.setNormalizedTime(f4);
                    f3 = this._zoomEndParam.getCurValue();
                }
                if (this._isOver) {
                    f3 = this._zoomEndParam.getToValue();
                }
            } else {
                this._zoomStartParam.setNormalizedTime(f2);
                f3 = this._zoomStartParam.getCurValue();
            }
            gLMapState.setMapZoomer(f3);
        }
        if (this._moveParam != null && this._needMove) {
            this._moveParam.setNormalizedTime(f2);
            int n2 = (int)this._moveParam.getFromXValue();
            int n3 = (int)this._moveParam.getFromYValue();
            int n4 = (int)this._moveParam.getToXValue();
            int n5 = (int)this._moveParam.getToYValue();
            float f5 = this._moveParam.getCurMult();
            gLMapState.setMapGeoCenter(n2, n3);
            PointF pointF = gLMapState.getMapGlCenter();
            float f6 = pointF.x;
            float f7 = pointF.y;
            FPoint fPoint = new FPoint();
            gLMapState.geo2Map(n4, n5, fPoint);
            float f8 = fPoint.x;
            float f9 = fPoint.y;
            float f10 = (f8 - f6) * f5;
            float f11 = (f9 - f7) * f5;
            gLMapState.setMapGlCenter(f6 + f10, f7 + f11);
        }
        if (this._rotateMapParam != null && this._needRotateMap) {
            this._rotateMapParam.setNormalizedTime(f2);
            float f12 = this._rotateMapParam.getCurValue();
            gLMapState.setMapAngle((int)f12);
        }
        if (this._rotateCameraParam != null && this._needRotateCamera) {
            this._rotateCameraParam.setNormalizedTime(f2);
            float f13 = this._rotateCameraParam.getCurValue();
            gLMapState.setCameraDegree((int)f13);
        }
    }

    public boolean typeEqueal(ADGLMapAnimGroup aDGLMapAnimGroup) {
        return this._needRotateCamera == aDGLMapAnimGroup._needRotateCamera && this._needRotateMap == aDGLMapAnimGroup._needRotateMap && this._needZoom == aDGLMapAnimGroup._needZoom && this._needMove == aDGLMapAnimGroup._needMove;
    }
}

