/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.Rectangle;

public class MapConfig
implements Cloneable {
    public static final int MSG_AUTH_FAILURE = 2;
    public static final int MSG_CAMERAUPDATE_CHANGE = 10;
    public static final int MSG_CAMERAUPDATE_FINISH = 11;
    public static final int MSG_ZOOMVIEW_CHANGESTATE = 12;
    public static final int MSG_COMPASSVIEW_CHANGESTATE = 13;
    public static final int MSG_CALLBACK_ONTOUCHEVENT = 14;
    public static final int MSG_CALLBACK_SCREENSHOT = 15;
    public static final int MSG_CALLBACK_MAPLOADED = 16;
    public static final int MSG_TILEOVERLAY_REFRESH = 17;
    public static final int MSG_INFOWINDOW_UPDATE = 18;
    public static final int MSG_ACTION_ONMARKERCLICK = 19;
    public static final int MSG_ACTION_ONBASEPOICLICK = 20;
    public static final float MAX_ZOOM = 19.0f;
    public static final float MAX_ZOOM_INDOOR = 20.0f;
    public static final float MIN_ZOOM = 3.0f;
    public float maxZoomLevel = 19.0f;
    public float minZoomLevel = 3.0f;
    private String mCustomStylePath;
    private FPoint[] mapRect = null;
    private Rectangle geoRectangle = new Rectangle();
    private boolean isIndoorEnable = false;
    private boolean isBuildingEnable = true;
    private boolean isMapTextEnable = true;
    private boolean isTrafficEnabled = false;
    private boolean isCustomStyleEnabled = false;
    private int s_x = 221010267;
    private int s_y = 101697799;
    private float s_z = 10.0f;
    private float s_c = 0.0f;
    private float s_r = 0.0f;
    private static final int TILE_SIZE_POW = 8;
    private static final int GEO_POINT_ZOOM = 20;
    MapConfig last_mapconfig = null;
    private boolean isCenterChanged = false;
    private boolean isZoomChanged = false;
    private boolean isTiltChanged = false;
    private boolean isBearingChanged = false;
    private boolean isNeedUpdateZoomControllerState = false;
    private boolean isNeedUpdateMapRectNextFrame = false;
    private boolean isSetLimitZoomLevel;
    private IPoint[] limitIPoints;
    private float limitZoomLevel;
    private LatLngBounds limitLatLngBounds;
    private int mMapStyleMode = 0;
    private int mMapStyleTime = 0;
    private int mMapStyleState = 0;
    private float mapPerPixelUnitLength;
    private String customTextureResourcePath;
    private int customBackgroundColor = -1;
    private float mapZoomScale = 1.0f;
    private volatile int changedCounter = 0;
    private volatile double changeRatio = 1.0;
    private volatile double changeGridRatio = 1.0;
    public static final int DEFAULT_RATIO = 1;
    private int grid_x = 0;
    private int grid_y = 0;

    public MapConfig(boolean bl2) {
        if (bl2) {
            this.last_mapconfig = new MapConfig(false);
            this.last_mapconfig.setGridXY(0, 0);
            this.last_mapconfig.setS_x(0);
            this.last_mapconfig.setS_y(0);
            this.last_mapconfig.setS_z(0.0f);
            this.last_mapconfig.setS_c(0.0f);
            this.last_mapconfig.setS_r(0.0f);
        }
    }

    public int getChangedCounter() {
        return this.changedCounter;
    }

    public void resetChangedCounter() {
        this.changedCounter = 0;
    }

    public boolean isMapStateChange() {
        boolean bl2 = false;
        if (this.last_mapconfig != null) {
            int n2 = this.last_mapconfig.getS_x();
            int n3 = this.last_mapconfig.getS_y();
            float f2 = this.last_mapconfig.getS_z();
            float f3 = this.last_mapconfig.getS_c();
            float f4 = this.last_mapconfig.getS_r();
            this.isCenterChanged = n2 != this.s_x;
            this.isCenterChanged = n3 != this.s_y ? true : this.isCenterChanged;
            boolean bl3 = this.isZoomChanged = f2 != this.s_z;
            if (this.isZoomChanged) {
                this.isNeedUpdateZoomControllerState = f2 <= this.minZoomLevel || this.s_z <= this.minZoomLevel || f2 >= this.maxZoomLevel || this.s_z >= this.maxZoomLevel;
            }
            this.isTiltChanged = f3 != this.s_c;
            this.isBearingChanged = f4 != this.s_r;
            boolean bl4 = bl2 = this.isCenterChanged || this.isZoomChanged || this.isTiltChanged || this.isBearingChanged || this.isNeedUpdateMapRectNextFrame;
            if (bl2) {
                this.isNeedUpdateMapRectNextFrame = false;
                ++this.changedCounter;
                int n4 = (int)this.s_z;
                int n5 = this.s_x >> 20 - n4 + 8;
                int n6 = this.s_y >> 20 - n4 + 8;
                this.setGridXY(n5, n6);
                this.changeRatio();
            }
        }
        return bl2;
    }

    protected void setGridXY(int n2, int n3) {
        if (this.last_mapconfig != null) {
            this.last_mapconfig.setGridXY(this.grid_x, this.grid_y);
        }
        this.grid_x = n2;
        this.grid_y = n3;
    }

    protected int getGrid_X() {
        return this.grid_x;
    }

    protected int getGrid_Y() {
        return this.grid_y;
    }

    public double getChangeRatio() {
        return this.changeRatio;
    }

    public double getChangeGridRatio() {
        return this.changeGridRatio;
    }

    private void changeRatio() {
        int n2 = this.last_mapconfig.getS_x();
        int n3 = this.last_mapconfig.getS_y();
        float f2 = this.last_mapconfig.getS_z();
        float f3 = this.last_mapconfig.getS_c();
        float f4 = this.last_mapconfig.getS_r();
        this.changeRatio = Math.abs(this.s_x - n2) + Math.abs(this.s_y - n3);
        this.changeRatio = this.changeRatio == 0.0 ? 1.0 : this.changeRatio * 2.0;
        this.changeRatio *= f2 == this.s_z ? 1.0 : (double)Math.abs(f2 - this.s_z);
        float f5 = f3 == this.s_c ? 1.0f : Math.abs(f3 - this.s_c);
        float f6 = f4 == this.s_r ? 1.0f : Math.abs(f4 - this.s_r);
        this.changeRatio *= (double)f5;
        this.changeRatio *= (double)f6;
        this.changeGridRatio = Math.abs(this.last_mapconfig.getGrid_X() - this.grid_x) + (this.last_mapconfig.getGrid_Y() - this.grid_y);
        this.changeGridRatio = this.changeGridRatio == 0.0 ? 1.0 : this.changeGridRatio * 2.0;
        this.changeGridRatio *= (double)f5;
        this.changeGridRatio *= (double)f6;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" s_x: ");
        stringBuilder.append(this.s_x);
        stringBuilder.append(" s_y: ");
        stringBuilder.append(this.s_y);
        stringBuilder.append(" s_z: ");
        stringBuilder.append(this.s_z);
        stringBuilder.append(" s_c: ");
        stringBuilder.append(this.s_c);
        stringBuilder.append(" s_r: ");
        stringBuilder.append(this.s_r);
        return stringBuilder.toString();
    }

    public boolean isZoomChanged() {
        return this.isZoomChanged;
    }

    public boolean isTiltChanged() {
        return this.isTiltChanged;
    }

    public boolean isBearingChanged() {
        return this.isBearingChanged;
    }

    public boolean isIndoorEnable() {
        return this.isIndoorEnable;
    }

    public void setIndoorEnable(boolean bl2) {
        this.isIndoorEnable = bl2;
    }

    public boolean isBuildingEnable() {
        return this.isBuildingEnable;
    }

    public void setBuildingEnable(boolean bl2) {
        this.isBuildingEnable = bl2;
    }

    public boolean isMapTextEnable() {
        return this.isMapTextEnable;
    }

    public void setMapTextEnable(boolean bl2) {
        this.isMapTextEnable = bl2;
    }

    public boolean isTrafficEnabled() {
        return this.isTrafficEnabled;
    }

    public void setTrafficEnabled(boolean bl2) {
        this.isTrafficEnabled = bl2;
    }

    public boolean isNeedUpdateZoomControllerState() {
        return this.isNeedUpdateZoomControllerState;
    }

    public int getS_x() {
        return this.s_x;
    }

    public void setS_x(int n2) {
        if (this.last_mapconfig != null) {
            this.last_mapconfig.setS_x(this.s_x);
        }
        this.s_x = n2;
    }

    public int getS_y() {
        return this.s_y;
    }

    public void setS_y(int n2) {
        if (this.last_mapconfig != null) {
            this.last_mapconfig.setS_y(this.s_y);
        }
        this.s_y = n2;
    }

    public float getS_z() {
        return this.s_z;
    }

    public void setS_z(float f2) {
        if (this.last_mapconfig != null) {
            this.last_mapconfig.setS_z(this.s_z);
        }
        this.s_z = f2;
    }

    public float getS_c() {
        return this.s_c;
    }

    public void setS_c(float f2) {
        if (this.last_mapconfig != null) {
            this.last_mapconfig.setS_c(this.s_c);
        }
        this.s_c = f2;
    }

    public float getS_r() {
        return this.s_r;
    }

    public void setS_r(float f2) {
        if (this.last_mapconfig != null) {
            this.last_mapconfig.setS_r(this.s_r);
        }
        this.s_r = f2;
    }

    public FPoint[] getMapRect() {
        return this.mapRect;
    }

    public void setMapRect(FPoint[] fPointArray) {
        if (this.last_mapconfig != null) {
            this.last_mapconfig.setMapRect(fPointArray);
        }
        this.mapRect = fPointArray;
    }

    public Rectangle getGeoRectangle() {
        return this.geoRectangle;
    }

    public void setMaxZoomLevel(float f2) {
        if (f2 > 19.0f) {
            f2 = 19.0f;
        }
        if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        this.isSetLimitZoomLevel = true;
        this.maxZoomLevel = f2;
    }

    public void setMinZoomLevel(float f2) {
        if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        if (f2 > 19.0f) {
            f2 = 19.0f;
        }
        this.isSetLimitZoomLevel = true;
        this.minZoomLevel = f2;
    }

    public float getMaxZoomLevel() {
        return this.maxZoomLevel;
    }

    public float getMinZoomLevel() {
        return this.minZoomLevel;
    }

    public IPoint[] getLimitIPoints() {
        return this.limitIPoints;
    }

    public void setLimitIPoints(IPoint[] iPointArray) {
        this.limitIPoints = iPointArray;
    }

    public float getLimitZoomLevel() {
        return this.limitZoomLevel;
    }

    public void setLimitZoomLevel(float f2) {
        this.limitZoomLevel = f2;
    }

    public boolean isSetLimitZoomLevel() {
        return this.isSetLimitZoomLevel;
    }

    public LatLngBounds getLimitLatLngBounds() {
        return this.limitLatLngBounds;
    }

    public void setLimitLatLngBounds(LatLngBounds latLngBounds) {
        this.limitLatLngBounds = latLngBounds;
        if (latLngBounds == null) {
            this.setLimitZoomLevel(0.0f);
            this.resetMinMaxZoomPreference();
        }
    }

    public void resetMinMaxZoomPreference() {
        this.minZoomLevel = 3.0f;
        this.maxZoomLevel = 19.0f;
        this.isSetLimitZoomLevel = false;
    }

    public void updateMapRectNextFrame(boolean bl2) {
        this.isNeedUpdateMapRectNextFrame = bl2;
    }

    public void setMapPerPixelUnitLength(float f2) {
        this.mapPerPixelUnitLength = f2;
    }

    public float getMapPerPixelUnitLength() {
        return this.mapPerPixelUnitLength;
    }

    public void setCustomStylePath(String string) {
        this.mCustomStylePath = string;
    }

    public String getCustomStylePath() {
        return this.mCustomStylePath;
    }

    public void setCustomStyleEnable(boolean bl2) {
        this.isCustomStyleEnabled = bl2;
    }

    public boolean isCustomStyleEnable() {
        return this.isCustomStyleEnabled;
    }

    public int getMapStyleTime() {
        return this.mMapStyleTime;
    }

    public void setMapStyleTime(int n2) {
        this.mMapStyleTime = n2;
    }

    public int getMapStyleMode() {
        return this.mMapStyleMode;
    }

    public void setMapStyleMode(int n2) {
        this.mMapStyleMode = n2;
    }

    public int getMapStyleState() {
        return this.mMapStyleState;
    }

    public void setMapStyleState(int n2) {
        this.mMapStyleState = n2;
    }

    public void setCustomTextureResourcePath(String string) {
        this.customTextureResourcePath = string;
    }

    public String getCustomTextureResourcePath() {
        return this.customTextureResourcePath;
    }

    public void setCustomBackgroundColor(int n2) {
        this.customBackgroundColor = n2;
    }

    public int getCustomBackgroundColor() {
        return this.customBackgroundColor;
    }

    public void setMapZoomScale(float f2) {
        this.mapZoomScale = f2;
    }

    public float getMapZoomScale() {
        return this.mapZoomScale;
    }
}

