/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.glanimation;

public abstract class ADGLAnimationParam {
    protected int _interpolationType = 0;
    protected float _factor = 1.0f;
    protected float _normalizedTime;
    protected float _mult;
    protected boolean _hasCheckedParam = false;
    protected boolean _needToCaculate = false;
    protected boolean _hasFromValue = false;
    protected boolean _hasToValue = false;

    static float bounce(float f2) {
        return f2 * f2 * 8.0f;
    }

    public void reset() {
        this._hasCheckedParam = false;
        this._needToCaculate = false;
        this._interpolationType = 0;
        this._factor = 1.0f;
        this._hasCheckedParam = false;
        this._needToCaculate = false;
        this._hasFromValue = false;
        this._hasToValue = false;
    }

    public boolean needToCaculate() {
        if (!this._hasCheckedParam) {
            this.checkParam();
        }
        return this._hasCheckedParam && this._needToCaculate;
    }

    public float getCurMult() {
        return this._mult;
    }

    public void setNormalizedTime(float f2) {
        this._normalizedTime = f2;
        float f3 = 0.0f;
        switch (this._interpolationType) {
            case 6: {
                if (f2 < 0.0f) {
                    f3 = 0.0f;
                    break;
                }
                if (f2 < 0.25f) {
                    f3 = f2 * 4.0f;
                    break;
                }
                if (f2 < 0.5f) {
                    f3 = 2.0f - 4.0f * f2;
                    break;
                }
                if (f2 < 0.75f) {
                    f3 = 4.0f * f2 - 2.0f;
                    break;
                }
                if (f2 <= 1.0f) {
                    f3 = 4.0f - 4.0f * f2;
                    break;
                }
                f3 = 0.0f;
                break;
            }
            case 0: {
                f3 = f2;
                break;
            }
            case 1: {
                f3 = (float)Math.pow(f2, 2.0f * this._factor);
                break;
            }
            case 2: {
                if (this._factor == 1.0f) {
                    f3 = 1.0f - (1.0f - f2) * (1.0f - f2);
                    break;
                }
                f3 = (float)(1.0 - Math.pow(1.0f - f2, 2.0f * this._factor));
                break;
            }
            case 3: {
                f3 = (float)(Math.cos((double)(f2 + 1.0f) * Math.PI) / 2.0 + 0.5);
                break;
            }
            case 4: {
                f2 *= 1.1226f;
                if (f2 < 0.3535f) {
                    f3 = ADGLAnimationParam.bounce(f2);
                    break;
                }
                if (f2 < 0.7408f) {
                    f3 = ADGLAnimationParam.bounce(f2 - 0.54719f) + 0.7f;
                    break;
                }
                if (f2 < 0.9644f) {
                    f3 = ADGLAnimationParam.bounce(f2 - 0.8526f) + 0.9f;
                    break;
                }
                f3 = ADGLAnimationParam.bounce(f2 - 1.0435f) + 0.95f;
                break;
            }
            case 5: {
                float f4 = 2.0f;
                f3 = (f2 -= 1.0f) * f2 * ((f4 + 1.0f) * f2 + f4) + 1.0f;
                break;
            }
        }
        this._mult = f3;
    }

    public void setInterpolatorType(int n2, float f2) {
        this._interpolationType = n2;
        this._factor = f2;
    }

    public int getInterpolatorType() {
        return this._interpolationType;
    }

    public abstract void checkParam();
}

