/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.style;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.autonavi.ae.gmap.style.MapTilsCacheAndResManager;
import com.autonavi.ae.gmap.utils.GLFileUtil;
import com.autonavi.ae.gmap.utils.GLMapUtil;
import com.autonavi.amap.mapcore.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MapTilsCacheAndResManagerImpl
extends MapTilsCacheAndResManager {
    private static volatile MapTilsCacheAndResManagerImpl instance = null;
    private Context mContext;
    private String mCachePath;
    private String mMapExtResPath;
    private static final long Style_Update_Internal_Time = 43200000L;
    private String mCacheDir = "";
    private static final int CREATE_DIR_COUNT = 5;

    public MapTilsCacheAndResManagerImpl(Context context, String string) {
        this.mCacheDir = string;
        this.mContext = context;
    }

    public void setMapCachePath(String string) {
        this.mCacheDir = string;
    }

    public String getMapCachePath() {
        return this.mCacheDir;
    }

    public void checkDir() {
        int n2 = 0;
        File file = new File(this.mCacheDir, "vmap4res");
        while (!file.exists() && n2++ < 5) {
            file.mkdir();
        }
        this.mMapExtResPath = file.toString() + "/";
    }

    public synchronized void reset() {
        instance = null;
    }

    public byte[] getStyleData(String string, MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile) {
        try {
            return this.getStyleIconsData(string, 1, retStyleIconsFile);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getIconsData(String string, MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile) {
        try {
            return this.getStyleIconsData(string, 2, retStyleIconsFile);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getOtherResData(String string) {
        AssetManager assetManager = this.mContext.getAssets();
        InputStream inputStream = null;
        try {
            String string2 = "map_assets/" + string;
            inputStream = assetManager.open(string2);
            int n2 = inputStream.available();
            if (n2 == 0) {
                return null;
            }
            byte[] byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; i2 += inputStream.read(byArray, i2, n2 - i2)) {
            }
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public byte[] getOtherResDataFromDisk(String string) {
        return FileUtil.readFileContents(string);
    }

    public void saveFile(String string, int n2, int n3, byte[] byArray) {
        String string2;
        if (byArray == null || byArray.length <= 0) {
            return;
        }
        File file = new File(this.mMapExtResPath);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            string2 = string + "_";
            for (File file2 : fileArray) {
                if (!file2.getName().contains(string2)) continue;
                file2.delete();
                break;
            }
        }
        string2 = string + "_" + n2 + "_" + n3 + ".data";
        this.addUdateRecorder(string + "_" + n2);
        GLFileUtil.writeDatasToFile(this.mMapExtResPath + string2, byArray);
    }

    private String getFilePreName(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("_");
        if (stringArray.length < 3) {
            return null;
        }
        return stringArray[0] + "_" + stringArray[1] + "_" + stringArray[2];
    }

    private void setRetFile(MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile, String string) {
        if (retStyleIconsFile == null) {
            return;
        }
        retStyleIconsFile.fullName = string;
        String[] stringArray = string.split("_|\\.");
        if (stringArray.length < 2) {
            return;
        }
        retStyleIconsFile.name = stringArray[0] + "_" + stringArray[1];
        try {
            retStyleIconsFile.clientVersion = Integer.parseInt(stringArray[2]);
            retStyleIconsFile.serverVersion = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 1;
        }
        catch (NumberFormatException numberFormatException) {
            retStyleIconsFile.clientVersion = 1;
            retStyleIconsFile.serverVersion = 1;
        }
    }

    private byte[] getStyleIconsData(String string, int n2, MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile) throws IOException {
        String string2 = this.getFilePreName(string);
        if (string2 == null) {
            return null;
        }
        MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile2 = new MapTilsCacheAndResManager.RetStyleIconsFile();
        this.setRetFile(retStyleIconsFile2, string);
        File[] fileArray = new File(this.mMapExtResPath).listFiles();
        if (fileArray != null) {
            try {
                for (File file : fileArray) {
                    if (!file.getName().contains(string2)) continue;
                    this.setRetFile(retStyleIconsFile, file.getName());
                    if (retStyleIconsFile2.serverVersion < retStyleIconsFile.serverVersion) {
                        byte[] byArray = GLFileUtil.readFileContents(file.getAbsolutePath());
                        if (byArray == null || byArray.length <= 0) continue;
                        return byArray;
                    }
                    GLFileUtil.deleteFile(file);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        this.setRetFile(retStyleIconsFile, string);
        return GLMapUtil.decodeAssetResData(this.mContext, "map_assets/" + string);
    }

    static void copyAssertToTmp(Context context, String string, File file) {
        if (file.exists()) {
            return;
        }
        try {
            byte[] byArray;
            if (file.createNewFile() && (byArray = GLMapUtil.decodeAssetResData(context, string)) != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addUdateRecorder(String string) {
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("styles_icons_update_recorder", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(string, System.currentTimeMillis());
        editor.commit();
    }

    public synchronized boolean canUpate(String string) {
        boolean bl2 = true;
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("styles_icons_update_recorder", 0);
        long l2 = sharedPreferences.getLong(string, -1L);
        if (l2 > 0L && System.currentTimeMillis() - l2 < 43200000L) {
            bl2 = false;
        }
        return bl2;
    }

    public byte[] getPolyIconFilePath(String string, MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile) {
        try {
            String string2 = this.getFilePreName(string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile2 = new MapTilsCacheAndResManager.RetStyleIconsFile();
            this.setRetFile(retStyleIconsFile2, string);
            File[] fileArray = new File(this.mMapExtResPath).listFiles();
            if (fileArray != null) {
                try {
                    for (File file : fileArray) {
                        if (!file.getName().contains(string2)) continue;
                        this.setRetFile(retStyleIconsFile, file.getName());
                        if (retStyleIconsFile2.serverVersion < retStyleIconsFile.serverVersion) {
                            if (file.length() <= 0L) continue;
                            return (file.getAbsolutePath() + "\u0000").getBytes("utf-8");
                        }
                        GLFileUtil.deleteFile(file);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.copyAssetsFile(string);
            this.setRetFile(retStyleIconsFile, string);
            return (this.mMapExtResPath + string + "\u0000").getBytes("utf-8");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private void copyAssetsFile(String string) {
        try {
            File file = new File(this.mMapExtResPath + string);
            if (null != file && file.exists()) {
                return;
            }
            InputStream inputStream = this.mContext.getAssets().open("map_assets/" + string);
            int n2 = inputStream.available();
            if (n2 == 0) {
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.mMapExtResPath + string);
            byte[] byArray = new byte[1024];
            int n3 = inputStream.read(byArray);
            while (n3 > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n3);
                n3 = inputStream.read(byArray);
            }
            fileOutputStream.flush();
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

