/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gesture;

import android.content.Context;
import android.view.MotionEvent;
import com.autonavi.ae.gmap.gesture.TwoFingerGestureDetector;

public class RotateGestureDetector
extends TwoFingerGestureDetector {
    private final OnRotateGestureListener mListener;
    private boolean mSloppyGesture;

    public RotateGestureDetector(Context context, OnRotateGestureListener onRotateGestureListener) {
        super(context);
        this.mListener = onRotateGestureListener;
    }

    protected void handleStartProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 5: {
                this.resetState();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                this.mTimeDelta = 0L;
                this.updateStateByEvent(motionEvent);
                this.mSloppyGesture = this.isSloppyGesture(motionEvent);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onRotateBegin(this);
                break;
            }
            case 2: {
                if (!this.mSloppyGesture) break;
                this.mSloppyGesture = this.isSloppyGesture(motionEvent);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onRotateBegin(this);
                break;
            }
            case 6: {
                if (this.mSloppyGesture) break;
            }
        }
    }

    protected void handleInProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 6: {
                this.updateStateByEvent(motionEvent);
                if (!this.mSloppyGesture) {
                    this.mListener.onRotateEnd(this);
                }
                this.resetState();
                break;
            }
            case 3: {
                if (!this.mSloppyGesture) {
                    this.mListener.onRotateEnd(this);
                }
                this.resetState();
                break;
            }
            case 2: {
                boolean bl2;
                this.updateStateByEvent(motionEvent);
                if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(bl2 = this.mListener.onRotate(this))) break;
                this.mPrevEvent.recycle();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
            }
        }
    }

    protected void resetState() {
        super.resetState();
        this.mSloppyGesture = false;
    }

    public float getRotationDegreesDelta() {
        double d2 = Math.atan2(this.mPrevFingerDiffY, this.mPrevFingerDiffX) - Math.atan2(this.mCurrFingerDiffY, this.mCurrFingerDiffX);
        return (float)(d2 * 180.0 / Math.PI);
    }

    public static class SimpleOnRotateGestureListener
    implements OnRotateGestureListener {
        public boolean onRotate(RotateGestureDetector rotateGestureDetector) {
            return false;
        }

        public boolean onRotateBegin(RotateGestureDetector rotateGestureDetector) {
            return true;
        }

        public void onRotateEnd(RotateGestureDetector rotateGestureDetector) {
        }
    }

    public static interface OnRotateGestureListener {
        public boolean onRotate(RotateGestureDetector var1);

        public boolean onRotateBegin(RotateGestureDetector var1);

        public void onRotateEnd(RotateGestureDetector var1);
    }
}

