/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.util.Log;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.CustomRenderer;
import com.amap.api.maps.InfoWindowAnimationManager;
import com.amap.api.maps.LocationSource;
import com.amap.api.maps.Projection;
import com.amap.api.maps.UiSettings;
import com.amap.api.maps.model.AMapGestureListener;
import com.amap.api.maps.model.Arc;
import com.amap.api.maps.model.ArcOptions;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.Circle;
import com.amap.api.maps.model.CircleOptions;
import com.amap.api.maps.model.CrossOverlay;
import com.amap.api.maps.model.CrossOverlayOptions;
import com.amap.api.maps.model.GroundOverlay;
import com.amap.api.maps.model.GroundOverlayOptions;
import com.amap.api.maps.model.IndoorBuildingInfo;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.MyLocationStyle;
import com.amap.api.maps.model.MyTrafficStyle;
import com.amap.api.maps.model.NavigateArrow;
import com.amap.api.maps.model.NavigateArrowOptions;
import com.amap.api.maps.model.Poi;
import com.amap.api.maps.model.Polygon;
import com.amap.api.maps.model.PolygonOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.maps.model.Text;
import com.amap.api.maps.model.TextOptions;
import com.amap.api.maps.model.TileOverlay;
import com.amap.api.maps.model.TileOverlayOptions;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NIGHT = 3;
    public static final int MAP_TYPE_NAVI = 4;
    public static final int MAP_TYPE_BUS = 5;
    public static final int LOCATION_TYPE_LOCATE = 1;
    public static final int LOCATION_TYPE_MAP_FOLLOW = 2;
    public static final int LOCATION_TYPE_MAP_ROTATE = 3;
    public static final int MASK_LAYER_NONE = -1;
    public static final int MASK_LAYER_UNDER_MARKER = 0;
    public static final int MASK_LAYER_UNDER_LINE = 1;
    private final IAMap a;
    private UiSettings b;
    private Projection c;
    private MyTrafficStyle d;

    protected AMap(IAMap iAMap) {
        this.a = iAMap;
    }

    public final CameraPosition getCameraPosition() {
        try {
            return this.a.getCameraPosition();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final float getMaxZoomLevel() {
        return this.a.getMaxZoomLevel();
    }

    public final float getMinZoomLevel() {
        return this.a.getMinZoomLevel();
    }

    public final void moveCamera(CameraUpdate cameraUpdate) {
        try {
            this.a.moveCamera(cameraUpdate);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate) {
        try {
            this.a.animateCamera(cameraUpdate);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        try {
            this.a.animateCameraWithCallback(cameraUpdate, cancelableCallback);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, long l2, CancelableCallback cancelableCallback) {
        try {
            if (l2 <= 0L) {
                Log.w((String)"AMap", (String)"durationMs must be positive");
            }
            this.a.animateCameraWithDurationAndCallback(cameraUpdate, l2, cancelableCallback);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void stopAnimation() {
        try {
            this.a.stopAnimation();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final NavigateArrow addNavigateArrow(NavigateArrowOptions navigateArrowOptions) {
        try {
            return this.a.addNavigateArrow(navigateArrowOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final Polyline addPolyline(PolylineOptions polylineOptions) {
        try {
            return this.a.addPolyline(polylineOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final Circle addCircle(CircleOptions circleOptions) {
        try {
            return this.a.addCircle(circleOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final Arc addArc(ArcOptions arcOptions) {
        try {
            return this.a.addArc(arcOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final Polygon addPolygon(PolygonOptions polygonOptions) {
        try {
            return this.a.addPolygon(polygonOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        try {
            return this.a.addGroundOverlay(groundOverlayOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final Marker addMarker(MarkerOptions markerOptions) {
        try {
            return this.a.addMarker(markerOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final Text addText(TextOptions textOptions) {
        try {
            return this.a.addText(textOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final ArrayList<Marker> addMarkers(ArrayList<MarkerOptions> arrayList, boolean bl2) {
        try {
            return this.a.addMarkers(arrayList, bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final List<Marker> getMapScreenMarkers() {
        try {
            return this.a.getMapScreenMarkers();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        try {
            return this.a.addTileOverlay(tileOverlayOptions);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void clear() {
        try {
            this.a.clear();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void clear(boolean bl2) {
        try {
            this.a.clear(bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final int getMapType() {
        try {
            return this.a.getMapType();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 1;
        }
    }

    public final void setMapType(int n2) {
        try {
            this.a.setMapType(n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final boolean isTrafficEnabled() {
        try {
            return this.a.isTrafficEnabled();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setTrafficEnabled(boolean bl2) {
        try {
            this.a.setTrafficEnabled(bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void showMapText(boolean bl2) {
        try {
            this.a.setMapTextEnable(bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void showIndoorMap(boolean bl2) {
        try {
            this.a.setIndoorEnabled(bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void showBuildings(boolean bl2) {
        try {
            this.a.set3DBuildingEnabled(bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setMyTrafficStyle(MyTrafficStyle myTrafficStyle) {
        try {
            this.d = myTrafficStyle;
            this.a.setMyTrafficStyle(myTrafficStyle);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public MyTrafficStyle getMyTrafficStyle() {
        return this.d;
    }

    public final boolean isMyLocationEnabled() {
        try {
            return this.a.isMyLocationEnabled();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final void setMyLocationEnabled(boolean bl2) {
        try {
            this.a.setMyLocationEnabled(bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final Location getMyLocation() {
        try {
            return this.a.getMyLocation();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setLocationSource(LocationSource locationSource) {
        try {
            this.a.setLocationSource(locationSource);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setMyLocationStyle(MyLocationStyle myLocationStyle) {
        try {
            this.a.setMyLocationStyle(myLocationStyle);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final MyLocationStyle getMyLocationStyle() {
        try {
            return this.a.getMyLocationStyle();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setMyLocationType(int n2) {
        try {
            this.a.setMyLocationType(n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setMyLocationRotateAngle(float f2) {
        try {
            this.a.setMyLocationRotateAngle(f2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final UiSettings getUiSettings() {
        try {
            if (this.b == null) {
                this.b = this.a.getAMapUiSettings();
            }
            return this.b;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final Projection getProjection() {
        try {
            if (this.c == null) {
                this.c = this.a.getAMapProjection();
            }
            return this.c;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setOnCameraChangeListener(OnCameraChangeListener onCameraChangeListener) {
        try {
            this.a.setOnCameraChangeListener(onCameraChangeListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        try {
            this.a.setOnMapClickListener(onMapClickListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnMapTouchListener(OnMapTouchListener onMapTouchListener) {
        try {
            this.a.setOnMapTouchListener(onMapTouchListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnPOIClickListener(OnPOIClickListener onPOIClickListener) {
        try {
            this.a.setOnPOIClickListener(onPOIClickListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnMyLocationChangeListener(OnMyLocationChangeListener onMyLocationChangeListener) {
        try {
            this.a.setOnMyLocationChangeListener(onMyLocationChangeListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        try {
            this.a.setOnMapLongClickListener(onMapLongClickListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        try {
            this.a.setOnMarkerClickListener(onMarkerClickListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        try {
            this.a.setOnPolylineClickListener(onPolylineClickListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        try {
            this.a.setOnMarkerDragListener(onMarkerDragListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnInfoWindowClickListener(OnInfoWindowClickListener onInfoWindowClickListener) {
        try {
            this.a.setOnInfoWindowClickListener(onInfoWindowClickListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setInfoWindowAdapter(InfoWindowAdapter infoWindowAdapter) {
        try {
            this.a.setInfoWindowAdapter(infoWindowAdapter);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnMapLoadedListener(OnMapLoadedListener onMapLoadedListener) {
        try {
            this.a.setOnMaploadedListener(onMapLoadedListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setOnIndoorBuildingActiveListener(OnIndoorBuildingActiveListener onIndoorBuildingActiveListener) {
        try {
            this.a.setOnIndoorBuildingActiveListener(onIndoorBuildingActiveListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void getMapPrintScreen(onMapPrintScreenListener onMapPrintScreenListener2) {
        this.a.getMapPrintScreen(onMapPrintScreenListener2);
    }

    public void getMapScreenShot(OnMapScreenShotListener onMapScreenShotListener) {
        this.a.getMapScreenShot(onMapScreenShotListener);
    }

    public float getScalePerPixel() {
        try {
            return this.a.getScalePerPixel();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void runOnDrawFrame() {
        this.a.setRunLowFrame(false);
    }

    public void removecache() {
        try {
            this.a.removecache();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void removecache(OnCacheRemoveListener onCacheRemoveListener) {
        try {
            this.a.removecache(onCacheRemoveListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setCustomRenderer(CustomRenderer customRenderer) {
        try {
            this.a.setCustomRenderer(customRenderer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setPointToCenter(int n2, int n3) {
        try {
            this.a.setCenterToPixel(n2, n3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setMapTextZIndex(int n2) {
        try {
            this.a.setMapTextZIndex(n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void setLoadOfflineData(boolean bl2) {
        try {
            this.a.setLoadOfflineData(bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final int getMapTextZIndex() {
        try {
            return this.a.getMapTextZIndex();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    @Deprecated
    public static String getVersion() {
        return "5.0.0";
    }

    public void reloadMap() {
        this.a.reloadMap();
    }

    public void setRenderFps(int n2) {
        this.a.setRenderFps(n2);
    }

    public void setIndoorBuildingInfo(IndoorBuildingInfo indoorBuildingInfo) {
        try {
            this.a.setIndoorBuildingInfo(indoorBuildingInfo);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setAMapGestureListener(AMapGestureListener aMapGestureListener) {
        this.a.setAMapGestureListener(aMapGestureListener);
    }

    public float getZoomToSpanLevel(LatLng latLng, LatLng latLng2) {
        return this.a.getZoomToSpanLevel(latLng, latLng2);
    }

    public Pair<Float, LatLng> calculateZoomToSpanLevel(int n2, int n3, int n4, int n5, LatLng latLng, LatLng latLng2) {
        return this.a.calculateZoomToSpanLevel(n2, n3, n4, n5, latLng, latLng2);
    }

    public final InfoWindowAnimationManager getInfoWindowAnimationManager() {
        return this.a.getInfoWindowAnimationManager();
    }

    public void setMaskLayerParams(int n2, int n3, int n4, int n5, int n6, long l2) {
        this.a.setMaskLayerParams(n2, n3, n4, n5, n6, l2);
    }

    public void setMaxZoomLevel(float f2) {
        this.a.setMaxZoomLevel(f2);
    }

    public void setMinZoomLevel(float f2) {
        this.a.setMinZoomLevel(f2);
    }

    public void resetMinMaxZoomPreference() {
        this.a.resetMinMaxZoomPreference();
    }

    public void setMapStatusLimits(LatLngBounds latLngBounds) {
        try {
            this.a.setMapStatusLimits(latLngBounds);
            this.moveCamera(CameraUpdateFactory.newLatLngBounds(latLngBounds, 0));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public CrossOverlay addCrossOverlay(CrossOverlayOptions crossOverlayOptions) {
        return this.a.addCrossVector(crossOverlayOptions);
    }

    public float[] getViewMatrix() {
        return this.a.getViewMatrix();
    }

    public float[] getProjectionMatrix() {
        return this.a.getProjectionMatrix();
    }

    public void setMapCustomEnable(boolean bl2) {
        this.a.setMapCustomEnable(bl2);
    }

    public void setCustomMapStylePath(String string) {
        this.a.setCustomMapStylePath(string);
    }

    public void setCustomTextureResourcePath(String string) {
        this.a.setCustomTextureResourcePath(string);
    }

    public static interface OnMapScreenShotListener {
        public void onMapScreenShot(Bitmap var1);

        public void onMapScreenShot(Bitmap var1, int var2);
    }

    public static interface onMapPrintScreenListener {
        public void onMapPrint(Drawable var1);
    }

    public static interface OnCacheRemoveListener {
        public void onRemoveCacheFinish(boolean var1);
    }

    public static interface OnIndoorBuildingActiveListener {
        public void OnIndoorBuilding(IndoorBuildingInfo var1);
    }

    public static interface OnPOIClickListener {
        public void onPOIClick(Poi var1);
    }

    public static interface OnMapLoadedListener {
        public void onMapLoaded();
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);

        public void onCameraChangeFinish(CameraPosition var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(Marker var1);

        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(Location var1);
    }

    public static interface MultiPositionInfoWindowAdapter
    extends InfoWindowAdapter {
        public View getInfoWindowClick(Marker var1);

        public View getOverturnInfoWindow(Marker var1);

        public View getOverturnInfoWindowClick(Marker var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public View getInfoContents(Marker var1);
    }
}

