/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.message;

import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.message.GestureMapMessage;

public class RotateGestureMapMessage
extends GestureMapMessage {
    public int pivot_x = 0;
    public int pivot_y = 0;
    public float angle_delta = 0.0f;

    public RotateGestureMapMessage(int n2, float f2, int n3, int n4) {
        super(n2);
        this.angle_delta = f2;
        this.pivot_x = n3;
        this.pivot_y = n4;
    }

    public int getType() {
        return 2;
    }

    public void runCameraUpdate(GLMapState gLMapState) {
        int n2 = this.pivot_x;
        int n3 = this.pivot_y;
        if (this.isUseAnchor) {
            n2 = this.anchorX;
            n3 = this.anchorY;
        }
        IPoint iPoint = null;
        IPoint iPoint2 = null;
        if (n2 > 0 || n3 > 0) {
            iPoint = new IPoint();
            iPoint2 = new IPoint();
            this.win2geo(gLMapState, n2, n3, iPoint);
            gLMapState.setMapGeoCenter(iPoint.x, iPoint.y);
        }
        float f2 = this.angle_delta;
        float f3 = gLMapState.getMapAngle() + f2;
        gLMapState.setMapAngle(f3);
        gLMapState.recalculate();
        if (n2 > 0 || n3 > 0) {
            this.win2geo(gLMapState, n2, n3, iPoint2);
            gLMapState.setMapGeoCenter(2 * iPoint.x - iPoint2.x, 2 * iPoint.y - iPoint2.y);
            gLMapState.recalculate();
        }
    }
}

