/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import com.autonavi.ae.gmap.gesture.TwoFingerGestureDetector;

public class HoverGestureDetector
extends TwoFingerGestureDetector {
    private static final PointF FOCUS_DELTA_ZERO = new PointF();
    private final OnHoverGestureListener mListener;
    private boolean mSloppyGesture;
    private PointF mCurrFocusInternal;
    private PointF mPrevFocusInternal;
    private PointF mFocusExternal = new PointF();
    private PointF mFocusDeltaExternal = new PointF();

    public HoverGestureDetector(Context context, OnHoverGestureListener onHoverGestureListener) {
        super(context);
        this.mListener = onHoverGestureListener;
    }

    protected void handleStartProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 5: {
                this.resetState();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                this.mTimeDelta = 0L;
                this.updateStateByEvent(motionEvent);
                this.mSloppyGesture = this.isSloppyGesture(motionEvent);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onHoveBegin(this);
                break;
            }
            case 2: {
                if (!this.mSloppyGesture) break;
                this.mSloppyGesture = this.isSloppyGesture(motionEvent);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onHoveBegin(this);
                break;
            }
            case 6: {
                if (this.mSloppyGesture) break;
            }
        }
    }

    protected void handleInProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 6: {
                this.updateStateByEvent(motionEvent);
                if (!this.mSloppyGesture) {
                    this.mListener.onHoveEnd(this);
                }
                this.resetState();
                break;
            }
            case 3: {
                if (!this.mSloppyGesture) {
                    this.mListener.onHoveEnd(this);
                }
                this.resetState();
                break;
            }
            case 2: {
                boolean bl2;
                this.updateStateByEvent(motionEvent);
                if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(bl2 = this.mListener.onHove(this))) break;
                this.mPrevEvent.recycle();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
            }
        }
    }

    protected void resetState() {
        super.resetState();
        this.mSloppyGesture = false;
    }

    protected void updateStateByEvent(MotionEvent motionEvent) {
        super.updateStateByEvent(motionEvent);
        MotionEvent motionEvent2 = this.mPrevEvent;
        this.mCurrFocusInternal = HoverGestureDetector.determineFocalPoint(motionEvent);
        this.mPrevFocusInternal = HoverGestureDetector.determineFocalPoint(motionEvent2);
        boolean bl2 = this.mPrevEvent.getPointerCount() != motionEvent.getPointerCount();
        this.mFocusDeltaExternal = bl2 ? FOCUS_DELTA_ZERO : new PointF(this.mCurrFocusInternal.x - this.mPrevFocusInternal.x, this.mCurrFocusInternal.y - this.mPrevFocusInternal.y);
        this.mFocusExternal.x += this.mFocusDeltaExternal.x;
        this.mFocusExternal.y += this.mFocusDeltaExternal.y;
    }

    public float getFocusX() {
        return this.mFocusExternal.x;
    }

    public float getFocusY() {
        return this.mFocusExternal.y;
    }

    public PointF getFocusDelta() {
        return this.mFocusDeltaExternal;
    }

    public static interface OnHoverGestureListener {
        public boolean onHove(HoverGestureDetector var1);

        public boolean onHoveBegin(HoverGestureDetector var1);

        public void onHoveEnd(HoverGestureDetector var1);
    }
}

