/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.glanimation;

import android.os.SystemClock;
import com.autonavi.ae.gmap.glanimation.ADGLAnimation;
import com.autonavi.ae.gmap.glanimation.ADGLAnimationParam2V;

public class ADGLAnimation2V
extends ADGLAnimation {
    private ADGLAnimationParam2V _v2Param = null;
    private float _curValue1;
    private float _curValue2;

    public ADGLAnimation2V(int n2) {
        this.reset();
        this._duration = n2;
        this._curValue1 = 0.0f;
        this._curValue2 = 0.0f;
    }

    public void reset() {
        this._isOver = false;
        this._duration = 0;
        this._curValue1 = 0.0f;
        this._curValue2 = 0.0f;
        if (this._v2Param != null) {
            this._v2Param.reset();
        }
    }

    public void setAnimationValue(float f2, float f3, float f4, float f5, int n2) {
        if (this._v2Param == null) {
            this._v2Param = new ADGLAnimationParam2V();
        }
        this._v2Param.reset();
        this._v2Param.setInterpolatorType(n2, 1.0f);
        this._v2Param.setFromValue(f2, f4);
        this._v2Param.setToValue(f3, f5);
        this._startTime = SystemClock.uptimeMillis();
        this._isOver = false;
    }

    public float getCurValue(int n2) {
        if (n2 == 0) {
            return this._curValue1;
        }
        return this._curValue2;
    }

    public float getStartValue(int n2) {
        if (n2 == 0) {
            if (this._v2Param != null) {
                return this._v2Param.getFromXValue();
            }
            return 0.0f;
        }
        if (this._v2Param != null) {
            return this._v2Param.getFromYValue();
        }
        return 0.0f;
    }

    public float getEndValue(int n2) {
        if (n2 == 0) {
            if (this._v2Param != null) {
                return this._v2Param.getToXValue();
            }
            return 0.0f;
        }
        if (this._v2Param != null) {
            return this._v2Param.getToYValue();
        }
        return 0.0f;
    }

    public void doAnimation(Object object) {
        if (this._isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this._offsetTime = l2 - this._startTime;
        float f2 = (float)this._offsetTime / (float)this._duration;
        if (f2 > 1.0f) {
            f2 = 1.0f;
            this._isOver = true;
        } else if (f2 < 0.0f) {
            this._isOver = true;
            return;
        }
        if (this._v2Param != null) {
            this._v2Param.setNormalizedTime(f2);
            this._curValue1 = this._v2Param.getCurXValue();
            this._curValue2 = this._v2Param.getCurYValue();
        }
    }
}

