/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.glanimation;

import android.graphics.Point;
import android.os.SystemClock;
import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.ae.gmap.glanimation.ADGLAnimation;
import com.autonavi.ae.gmap.glanimation.ADGLAnimationParam1V;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.IPoint;

public class ADGLMapAnimPivotZoom
extends ADGLAnimation {
    private boolean _hasCheckParams;
    private float _mapLevelTo;
    private int _beginCenterGeoX;
    private int _beginCenterGeoY;
    private int _pivotGeoX;
    private int _pivotGeoY;
    private boolean _zoomCenter;
    private float _winPivotX;
    private float _winPivotY;
    ADGLAnimationParam1V _zoomParam = null;

    public void reset() {
        this._isOver = false;
        this._hasCheckParams = false;
        this._zoomCenter = true;
        this._mapLevelTo = 0.0f;
        this._beginCenterGeoX = 0;
        this._beginCenterGeoY = 0;
        this._pivotGeoX = 0;
        this._pivotGeoY = 0;
        this._winPivotX = 0.0f;
        this._winPivotY = 0.0f;
        if (this._zoomParam != null) {
            this._zoomParam.reset();
        }
    }

    public void commitAnimation(Object object) {
        this._isOver = true;
        this._hasCheckParams = false;
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        float f2 = gLMapState.getMapZoomer();
        float f3 = this._mapLevelTo - f2;
        if ((double)Math.abs(f3) < 1.0E-6) {
            this._isOver = true;
            this._hasCheckParams = true;
            return;
        }
        float f4 = f2;
        this._zoomParam.setFromValue(f4);
        this._zoomParam.setToValue(this._mapLevelTo);
        if (!this._zoomCenter) {
            IPoint iPoint = new IPoint();
            gLMapState.getGeoCenter(iPoint);
            this._beginCenterGeoX = iPoint.x;
            this._beginCenterGeoY = iPoint.y;
            FPoint fPoint = new FPoint();
            IPoint iPoint2 = new IPoint();
            gLMapState.win2Map((int)this._winPivotX, (int)this._winPivotY, fPoint);
            gLMapState.map2Geo(fPoint.x, fPoint.y, iPoint2);
            this._pivotGeoX = iPoint2.x;
            this._pivotGeoY = iPoint2.y;
        }
        this._hasCheckParams = true;
        this._isOver = false;
        this._startTime = SystemClock.uptimeMillis();
    }

    public ADGLMapAnimPivotZoom(int n2) {
        this.reset();
        this._duration = n2;
    }

    public void setToMapZoomAndPivot(float f2, int n2, Point point) {
        this._zoomParam = new ADGLAnimationParam1V();
        this._zoomParam.setInterpolatorType(n2, 1.0f);
        if (f2 > 20.0f) {
            f2 = 20.0f;
        }
        if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        this._mapLevelTo = f2;
        if (point != null) {
            this._winPivotX = point.x;
            this._winPivotY = point.y;
            this._zoomCenter = false;
        }
    }

    public void doAnimation(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this._hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this._isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this._offsetTime = l2 - this._startTime;
        float f2 = (float)this._offsetTime / (float)this._duration;
        if (f2 > 1.0f) {
            f2 = 1.0f;
            this._isOver = true;
        }
        if (f2 >= 0.0f && f2 <= 1.0f) {
            this._zoomParam.setNormalizedTime(f2);
            float f3 = this._zoomParam.getCurValue();
            if (f3 > 20.0f) {
                f3 = 20.0f;
                this._isOver = true;
            }
            if (f3 < 3.0f) {
                f3 = 3.0f;
                this._isOver = true;
            }
            if (!this._zoomCenter) {
                float f4 = f3 - this._zoomParam.getFromValue();
                float f5 = (float)Math.pow(2.0, f4);
                int n2 = (int)((float)(this._pivotGeoX - this._beginCenterGeoX) * (1.0f - 1.0f / f5));
                int n3 = (int)((float)(this._pivotGeoY - this._beginCenterGeoY) * (1.0f - 1.0f / f5));
                gLMapState.setMapGeoCenter(this._beginCenterGeoX + n2, this._beginCenterGeoY + n3);
            }
            gLMapState.setMapZoomer(f3);
        }
    }
}

