export interface Options {
    sourceType?: string;
    mediaType?: string;
    allowsEditing?: boolean;
    cameraType?: string;
    quality?: number;
}
export interface PhotoAlbum {
    edited?: {
        path?: string;
    };
    reference?: {
        path?: string;
    };
}
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/6/29
 */
declare class MediaManager {
    /**
     *
     * @param options
     * @returns {*}
     */
    static launchImageLibrary(options?: Options): Promise<PhotoAlbum>;
    static launchCamera(options?: {
        sourceType: any;
        mediaType: any;
        cameraType: any;
        allowsEditing: boolean;
        quality: any;
    }): Promise<PhotoAlbum>;
}
export { MediaManager as default, SourceType, MediaType, CameraType, Quality };
