/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gloverlay;

import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.amap.mapcore.interfaces.IAMap;

public abstract class GLOverlay {
    protected int mCode;
    protected IAMap mGLMapView;
    protected int mEngineID;
    protected boolean isNightStyle = false;
    protected long mNativeInstance = 0L;

    public GLOverlay(int n2, IAMap iAMap, int n3) {
        this.mEngineID = n2;
        this.mGLMapView = iAMap;
        this.mCode = n3;
        this.mNativeInstance = 0L;
    }

    public long getNativeInstatnce() {
        return this.mNativeInstance;
    }

    public int getCode() {
        return this.mCode;
    }

    public int getType() {
        if (this.mNativeInstance == 0L) {
            return -1;
        }
        return GLOverlay.nativeGetType(this.mNativeInstance);
    }

    public int getSubType() {
        if (this.mNativeInstance == 0L) {
            return -1;
        }
        return GLOverlay.nativeGetSubType(this.mNativeInstance);
    }

    public void removeItem(int n2) {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeRemoveItem(this.mNativeInstance, n2);
    }

    public void removeAll() {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeRemoveAll(this.mNativeInstance);
        if (this.mGLMapView != null) {
            this.mGLMapView.setRunLowFrame(false);
        }
    }

    public int getSize() {
        if (this.mNativeInstance == 0L) {
            return 0;
        }
        return GLOverlay.nativeGetCount(this.mNativeInstance);
    }

    public void setVisible(boolean bl2) {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeSetVisible(this.mNativeInstance, bl2);
        this.mGLMapView.setRunLowFrame(false);
    }

    public boolean isVisible() {
        if (this.mNativeInstance == 0L) {
            return false;
        }
        return GLOverlay.nativeIsVisible(this.mNativeInstance);
    }

    public void setClickable(boolean bl2) {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeSetClickable(this.mNativeInstance, bl2);
    }

    public boolean isClickable() {
        if (this.mNativeInstance == 0L) {
            return false;
        }
        return GLOverlay.nativeIsClickable(this.mNativeInstance);
    }

    public void clearFocus() {
    }

    public void setMaxCountShown(int n2) {
        GLOverlay.nativeSetShownMaxCount(this.mNativeInstance, n2);
    }

    public void setOverlayOnTop(boolean bl2) {
        GLOverlay.nativeSetOverlayOnTop(this.mNativeInstance, bl2);
    }

    public void setMinDisplayLevel(int n2) {
        GLOverlay.nativeSetMinDisplayLevel(this.mNativeInstance, n2);
    }

    public void setMaxDisplayLevel(int n2) {
        GLOverlay.nativeSetMaxDisplayLevel(this.mNativeInstance, n2);
    }

    public void setOverlayPriority(int n2) {
        GLOverlay.nativeSetOverlayPriority(this.mNativeInstance, n2);
    }

    public int getOverlayPriority() {
        return GLOverlay.nativeGetOverlayPriority(this.mNativeInstance);
    }

    public void setOverlayItemPriority(int n2) {
        GLOverlay.nativeSetOverlayItemPriority(this.mNativeInstance, n2);
    }

    protected void finalize() throws Throwable {
        this.releaseInstance();
        super.finalize();
    }

    public void releaseInstance() {
        if (this.mNativeInstance != 0L) {
            GLMapEngine.destoryOverlay(this.mEngineID, this.mNativeInstance);
            this.mNativeInstance = 0L;
        }
    }

    private static native int nativeGetType(long var0);

    private static native int nativeGetSubType(long var0);

    private static native void nativeRemoveItem(long var0, int var2);

    private static native void nativeRemoveAll(long var0);

    private static native int nativeGetCount(long var0);

    protected static native void nativeSetVisible(long var0, boolean var2);

    private static native boolean nativeIsVisible(long var0);

    private static native void nativeSetClickable(long var0, boolean var2);

    private static native boolean nativeIsClickable(long var0);

    private static native void nativeSetOverlayOnTop(long var0, boolean var2);

    private static native void nativeSetMinDisplayLevel(long var0, int var2);

    private static native void nativeSetMaxDisplayLevel(long var0, int var2);

    private static native void nativeSetShownMaxCount(long var0, int var2);

    private static native void nativeSetOverlayPriority(long var0, int var2);

    private static native int nativeGetOverlayPriority(long var0);

    private static native void nativeSetOverlayItemPriority(long var0, int var2);

    public void useNightStyle(boolean bl2) {
        this.isNightStyle = bl2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EAMapOverlayTpye {
        AMAPOVERLAY_POINT,
        AMAPOVERLAY_POLYLINE,
        AMAPOVERLAY_POLYGON,
        AMAPOVERLAY_NAVI,
        AMAPOVERLAY_GPS,
        AMAPOVERLAY_ARC,
        AMAPOVERLAY_ARROW,
        AMAPOVERLAY_VECTOR,
        AMAPOVERLAY_MODEL,
        AMAPOVERLAY_RCTROUTE,
        AMAPOVERLAY_ROUTE;

    }
}

