/// <reference types="react" />
import * as React from 'react';
import Component from '../AbstractComponent';
import RootManager from '../createRootNode/RootManager';
import Props from './Props';
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/5/24
 */
export declare class AbstractDialog extends Component<Props> {
    static defaultProps: {
        autoDisableAndroidBackPress: boolean;
        activeOpacity: number;
        visible: boolean;
        statusBarAutoHidden: boolean;
    };
    state: {
        animating: boolean;
        visible: boolean;
    };
    mounted: boolean;
    statusBarHidden: boolean;
    componentWillMount(): void;
    componentWillReceiveProps(): void;
    shounldComponentUpdate(): boolean;
    componentWillUnmount(): void;
    handleHardwareBackPress(): void;
    handlePress(): void;
    handleAnimationBegin(): void;
    handleAnimationEnd(): void;
    renderLoading({children, loadingProps}: {
        children: any;
        loadingProps: any;
    }): JSX.Element;
    render(): JSX.Element;
}
declare const _default: {
    new (props?: Props, context?: any): {
        manager: RootManager;
        componentWillMount(): void;
        componentWillUpdate(nextProps: any): void;
        componentWillUnmount(): void;
        render(): JSX.Element;
        setState<K extends string>(f: (prevState: any, props: Props) => Pick<any, K>, callback?: () => any): void;
        setState<K extends string>(state: Pick<any, K>, callback?: () => any): void;
        forceUpdate(callBack?: () => any): void;
        props: Readonly<{
            children?: React.ReactNode;
        }> & Readonly<Props>;
        state: Readonly<any>;
        context: any;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<Props>, nextContext: any): void;
        shouldComponentUpdate?(nextProps: Readonly<Props>, nextState: Readonly<any>, nextContext: any): boolean;
        componentDidUpdate?(prevProps: Readonly<Props>, prevState: Readonly<any>, prevContext: any): void;
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
    };
};
export default _default;
