/// <reference types="react" />
import Component from '../AbstractComponent';
import { Props } from './Props';
/**
 * Form 表单组件
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/5/5
 */
export default class Form extends Component<Props> {
    /**
     * 错误字段
     * @type {Array}
     */
    errorFields: {};
    /**
     * 缺失字段
     * @type {Array}
     */
    missFields: {};
    /**
     * 表单数据
     * @type {{}}
     */
    formValue: {};
    formFields: {};
    putFormValue(name: any, value: any): void;
    putErrorField(name: any): void;
    putMissField(name: any): void;
    /**
     * 删除表单错误字段
     * @param name 字段名字
     */
    deleteErrOrMissField(name: any): void;
    /**
     * 获取表单数据
     * @returns {{}}
     */
    getFormValue(): {};
    /**
     * 获取表单错误字段信息
     * @returns {{miss: Array, error: Array}}
     */
    getErrorFields(): {
        miss: string[];
        error: string[];
    };
    /**
     * 校验表单是否正确
     * @returns {boolean}
     */
    isValid(): boolean;
    render(): JSX.Element;
}
