/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

import android.text.TextUtils;
import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.ae.gmap.maploader.IndoorMapLoader;
import com.autonavi.ae.gmap.maploader.MapSourceGridData;
import com.autonavi.ae.gmap.utils.GLConvertUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;

public abstract class BaseMapLoader {
    protected GLMapEngine mGLMapEngine;
    public List<MapSourceGridData> mMapTiles = new ArrayList<MapSourceGridData>();
    private HttpURLConnection mURLConnection = null;
    private static final int CONNECTION_TIMEOUT = 20000;
    private boolean isGetRequestMethod = true;
    protected byte[] mReceivedDataBuffer = null;
    protected int mDataSource = 0;
    protected long mCreateTime;
    protected int mReceivedDataSize = 0;
    protected int mNextImgDataLength = 0;
    protected int mCapaticy = 30720;
    protected int mCapaticyExt = 10240;
    protected boolean isReceivedHeader = false;
    protected volatile boolean isInRequest = false;
    protected volatile boolean isFinished = false;
    protected volatile boolean isCanceled = false;
    protected int mEngineID = 0;

    public BaseMapLoader(int n2) {
        this.mEngineID = n2;
    }

    protected abstract String getMapAddress();

    protected abstract String getMapServerPath();

    protected abstract String getGridParams();

    protected abstract boolean processReceivedDataHeader();

    protected abstract void processReceivedDataByType();

    protected abstract void processReceivedVersion();

    public abstract boolean isRequestValid();

    protected abstract boolean isNeedReturn();

    protected boolean processHttpResponse(HttpURLConnection httpURLConnection) {
        return false;
    }

    public void setGetRequestMethod(boolean bl2) {
        this.isGetRequestMethod = bl2;
    }

    public void addRequestTiles(MapSourceGridData mapSourceGridData) {
        if (null != this.mMapTiles) {
            this.mMapTiles.add(mapSourceGridData);
        }
    }

    protected void downLoadOver(int n2) {
    }

    protected String getRequestParams(String string) {
        String string2 = "mapdataver=6&" + string;
        string2 = string2 + "&aetraffic=8";
        if (this.mDataSource == 101) {
            return string2;
        }
        return string2;
    }

    protected void processReceivedDataV4() {
        try {
            if (this.mNextImgDataLength == 0) {
                if (this.mReceivedDataSize >= 8) {
                    this.mNextImgDataLength = GLConvertUtil.getInt(this.mReceivedDataBuffer, 0) + 8;
                    this.processReceivedDataV4();
                }
            } else if (this.mReceivedDataSize >= this.mNextImgDataLength) {
                this.processReceivedTileDataV4(this.mReceivedDataBuffer, 8, this.mNextImgDataLength);
                if (null != this.mReceivedDataBuffer) {
                    GLConvertUtil.moveArray(this.mReceivedDataBuffer, this.mNextImgDataLength, this.mReceivedDataBuffer, 0, this.mReceivedDataSize - this.mNextImgDataLength);
                    this.mReceivedDataSize -= this.mNextImgDataLength;
                    this.mNextImgDataLength = 0;
                    this.processReceivedDataV4();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedTileDataV4(byte[] byArray, int n2, int n3) throws UnsupportedEncodingException {
        int n4 = n2;
        n2 += 4;
        byte by2 = byArray[n2++];
        String string = "";
        if (by2 > 0 && n2 + by2 - 1 < n3) {
            string = new String(byArray, n2, (int)by2, "utf-8");
        }
        n2 += by2;
        if (!this.mGLMapEngine.isMapEngineValid()) {
            return;
        }
        if (n3 <= n4) {
            return;
        }
        this.putMapData(byArray, n4, n3 - n4, this.mDataSource, 0, string);
        int n5 = this.mGLMapEngine.GetCurrentGrideNameLen(this.mEngineID);
        boolean bl2 = true;
        if (n5 >= string.length()) {
            boolean bl3 = bl2 = !this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
        }
        if (bl2) {
            this.doCancel();
        }
    }

    protected void putMapData(byte[] byArray, int n2, int n3, int n4, int n5, String string) {
        this.mGLMapEngine.putMapData(this.mEngineID, byArray, n2, n3, n4, n5);
    }

    protected void processReceivedData() {
        block10: {
            try {
                if (this.mNextImgDataLength == 0) {
                    if (this.mReceivedDataSize >= 8) {
                        this.mNextImgDataLength = GLConvertUtil.getInt(this.mReceivedDataBuffer, 0) + 8;
                        this.processReceivedData();
                    }
                    break block10;
                }
                if (this.mReceivedDataSize < this.mNextImgDataLength) break block10;
                int n2 = GLConvertUtil.getInt(this.mReceivedDataBuffer, 0);
                int n3 = GLConvertUtil.getInt(this.mReceivedDataBuffer, 4);
                if (n3 == 0) {
                    this.processReceivedTileData(this.mReceivedDataBuffer, 8, n2 + 8);
                } else {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mReceivedDataBuffer, 8, n2);
                        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = new byte[128];
                        int n4 = -1;
                        while ((n4 = gZIPInputStream.read(byArray)) > -1) {
                            byteArrayOutputStream.write(byArray, 0, n4);
                        }
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        this.processReceivedTileData(byArray2, 0, n3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (this.mNextImgDataLength > 0 && null != this.mReceivedDataBuffer) {
                    GLConvertUtil.moveArray(this.mReceivedDataBuffer, this.mNextImgDataLength, this.mReceivedDataBuffer, 0, this.mReceivedDataSize - this.mNextImgDataLength);
                    this.mReceivedDataSize -= this.mNextImgDataLength;
                    this.mNextImgDataLength = 0;
                    this.processReceivedData();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void processReceivedTileData(byte[] byArray, int n2, int n3) {
        try {
            int n4 = n2;
            n2 += 2;
            n2 += 2;
            n2 += 4;
            byte by2 = byArray[n2++];
            String string = "";
            if (by2 > 0 && n2 + by2 - 1 < n3) {
                string = new String(byArray, n2, (int)by2, "utf-8");
            }
            n2 += by2;
            if (!this.mGLMapEngine.isMapEngineValid() || n3 <= n4) {
                return;
            }
            this.mGLMapEngine.putMapData(this.mEngineID, byArray, n4, n3 - n4, this.mDataSource, 0);
            int n5 = this.mGLMapEngine.GetCurrentGrideNameLen(this.mEngineID);
            boolean bl2 = true;
            if (n5 >= string.length()) {
                boolean bl3 = bl2 = !this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
            }
            if (bl2) {
                this.doCancel();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedVersionData(byte[] byArray, int n2, int n3) {
        try {
            if (0 < n3 && n3 <= byArray.length) {
                int n4 = 0;
                int n5 = GLConvertUtil.getInt(byArray, n4);
                n4 += 4;
                if (0 != n5) {
                    return;
                }
                int n6 = GLConvertUtil.getInt(byArray, n4);
                n4 += 4;
                if (0 != n6) {
                    return;
                }
                int n7 = GLConvertUtil.getInt(byArray, n4);
                n4 += 4;
                boolean bl2 = true;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 < n7; ++i2) {
                    byte by2 = 0;
                    String string = "";
                    if (n4 >= n3) {
                        bl2 = false;
                        break;
                    }
                    by2 = byArray[n4++];
                    if (by2 <= 0 || n4 + by2 >= n3) {
                        bl2 = false;
                        break;
                    }
                    string = new String(byArray, n4, (int)by2, "utf-8");
                    arrayList.add(string);
                    n4 += by2;
                    n4 += 4;
                }
                if (bl2) {
                    this.mGLMapEngine.putMapData(this.mEngineID, byArray, 0, n3, this.mDataSource, 0);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected boolean isContainIllegal(String string) {
        return string.contains("<") || string.contains("[");
    }

    public synchronized boolean hasFinished() {
        return this.isCanceled || this.isFinished;
    }

    public void onException(int n2) {
        if (this.mDataSource != 6 && this.mDataSource != 4 && this.mDataSource != 1) {
            if (this.isCanceled) {
                this.mGLMapEngine.onException(this.mEngineID, 1004);
            } else if (this.mDataSource == 10) {
                this.mGLMapEngine.onException(this.mEngineID, n2);
            } else {
                this.mGLMapEngine.onException(this.mEngineID, n2);
                this.mGLMapEngine.setParamater(this.mEngineID, 5001, n2, 0, 0, 0);
            }
        }
        this.downLoadOver(n2);
        this.isFinished = true;
    }

    private void onConnectionReceivedData(byte[] byArray, int n2) {
        if (this.mCapaticy < this.mReceivedDataSize + n2) {
            try {
                this.mCapaticy += this.mCapaticyExt;
                byte[] byArray2 = new byte[this.mCapaticy];
                System.arraycopy(this.mReceivedDataBuffer, 0, byArray2, 0, this.mReceivedDataSize);
                this.mReceivedDataBuffer = byArray2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.doCancel();
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.doCancel();
                return;
            }
        }
        try {
            System.arraycopy(byArray, 0, this.mReceivedDataBuffer, this.mReceivedDataSize, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.doCancel();
            return;
        }
        catch (Exception exception) {
            this.doCancel();
            return;
        }
        this.mReceivedDataSize += n2;
        if (this.isNeedReturn()) {
            return;
        }
        if (!this.isReceivedHeader && !this.processReceivedDataHeader()) {
            return;
        }
        this.processReceivedDataByType();
    }

    protected void onConnectionOpened() {
        this.mReceivedDataBuffer = new byte[this.mCapaticy];
        this.mNextImgDataLength = 0;
        this.mReceivedDataSize = 0;
        this.isReceivedHeader = false;
    }

    private synchronized void onConnectionOver() {
        if (null != this.mURLConnection && this.isInRequest) {
            this.isInRequest = false;
            try {
                this.mURLConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.processReceivedVersion();
        this.mReceivedDataBuffer = null;
        this.mNextImgDataLength = 0;
        this.mReceivedDataSize = 0;
        try {
            for (int i2 = 0; i2 < this.mMapTiles.size(); ++i2) {
                this.mGLMapEngine.mTileProcessCtrl.removeTile(this.mMapTiles.get(i2).getKeyGridName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.downLoadOver(0);
        this.isFinished = true;
    }

    public synchronized void doCancel() {
        if (this.isCanceled || this.isFinished) {
            return;
        }
        this.isCanceled = true;
        this.onConnectionOver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequest() {
        block82: {
            if (this.isCanceled || this.isFinished) {
                return;
            }
            if (!this.isRequestValid()) {
                this.doCancel();
                return;
            }
            String string = this.getMapAddress();
            String string2 = this.getMapServerPath();
            String string3 = this.getGridParams();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
                this.doCancel();
                return;
            }
            String string4 = string + string2;
            String string5 = this.getRequestParams(string3);
            if (this.isGetRequestMethod) {
                string4 = string4 + string5;
                string4 = string4 + "&csid=" + UUID.randomUUID().toString();
            } else {
                string4 = string4 + "csid=" + UUID.randomUUID().toString();
            }
            InputStream inputStream = null;
            try {
                Object object;
                URL uRL = new URL(string4);
                if (null == uRL) break block82;
                Proxy proxy = null;
                if (null != proxy) {
                    this.mURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
                }
                if (null == this.mURLConnection) {
                    this.mURLConnection = (HttpURLConnection)uRL.openConnection();
                }
                this.mURLConnection.setConnectTimeout(20000);
                this.mURLConnection.setReadTimeout(20000);
                if (this.isGetRequestMethod) {
                    this.mURLConnection.setRequestMethod("GET");
                } else {
                    this.mURLConnection.setRequestMethod("POST");
                    this.mURLConnection.setDoInput(true);
                    this.mURLConnection.setDoOutput(true);
                    this.mURLConnection.setUseCaches(false);
                    this.mURLConnection.setRequestProperty("User-Agent", this.mGLMapEngine.mUserAgent);
                    byte[] byArray = string5.getBytes("utf-8");
                    object = this.mURLConnection.getOutputStream();
                    ((OutputStream)object).write(byArray);
                    ((OutputStream)object).flush();
                    ((OutputStream)object).close();
                }
                this.isInRequest = true;
                this.mURLConnection.connect();
                if (this.processHttpResponse(this.mURLConnection)) {
                    return;
                }
                int n2 = this.mURLConnection.getResponseCode();
                if (n2 == 200) {
                    this.onConnectionOpened();
                    inputStream = this.mURLConnection.getInputStream();
                    object = new byte[512];
                    int n3 = -1;
                    while ((n3 = inputStream.read((byte[])object)) > -1) {
                        if (this.isCanceled) {
                            break block82;
                        }
                        this.onConnectionReceivedData((byte[])object, n3);
                    }
                    break block82;
                }
                if (this.mDataSource == 10) {
                    if (((IndoorMapLoader)this).switchFloorFailed()) {
                        this.onException(1007);
                    }
                } else {
                    this.onException(1002);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.mDataSource == 10 && ((IndoorMapLoader)this).switchFloorFailed()) {
                    this.onException(1007);
                }
            }
            catch (IOException iOException) {
                this.onException(1005);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {
            }
            finally {
                this.onConnectionOver();
                if (inputStream != null && !this.isCanceled) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.onException(1005);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
        }
    }
}

