export interface Options {
    sourceType?: string;
    mediaType?: string;
    allowsEditing?: boolean;
    cameraType?: string;
    quality?: number;
}
export declare enum PhotoAlbumAuthorizationStatusType {
    /**
     * 拒绝
     */
    denied = 0,
    /**
     * 家长控制
     */
    restricted = 1,
    /**
     * 用户未做出选择
     */
    notDetermined = 2,
    /**
     * 已授权
     */
    authorized = 3,
}
export interface PhotoAlbum {
    edited?: {
        path?: string;
    };
    reference?: {
        path?: string;
    };
}
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/6/29
 */
declare class MediaManager {
    /**
     *
     * @param options
     * @returns {*}
     */
    static launchImageLibrary(options?: Options): Promise<PhotoAlbum>;
    static launchCamera(options?: {
        sourceType: any;
        mediaType: any;
        cameraType: any;
        allowsEditing: boolean;
        quality: any;
    }): Promise<PhotoAlbum>;
    /**
     * 获取相册授权状态
     * ios
     */
    static getPhotoAlbumAuthorizationStatus(): Promise<PhotoAlbumAuthorizationStatusType>;
}
export { MediaManager as default, SourceType, MediaType, CameraType, Quality, PhotoAlbumAuthorizationStatus };
