/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GLMapUtil {
    public static final int AMAP_ENGINE_TYPE_MAIN = 0;
    public static final int AMAP_ENGINE_TYPE_EAGLEEYE = 1;
    public static final int AN_ENGINE_ID_MAIN = 1;
    public static final int AN_ENGINE_ID_EAGLE_EYE = 2;
    public static final int DEFAULT_DURATION = 250;

    public static byte[] decodeAssetResData(Context context, String string) {
        AssetManager assetManager = context.getAssets();
        try {
            InputStream inputStream = assetManager.open(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = -1;
            while ((n2 = inputStream.read(byArray)) > -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            inputStream.close();
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public static int dipToPixel(Context context, int n2) {
        if (context == null) {
            return n2;
        }
        try {
            float f2 = TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
            return (int)f2;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static int spToPixel(Context context, int n2) {
        float f2 = TypedValue.applyDimension((int)2, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return (int)f2;
    }

    public static String getString(Context context, int n2) {
        return context.getResources().getString(n2);
    }

    public static boolean isAssic(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] < '\u0100' && cArray[i2] > '\u0000') continue;
            return false;
        }
        return true;
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }
}

