/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;

public class GLMapState {
    private long native_state_instance = 0L;
    private long native_engine_instance = 0L;
    private boolean is_new_instance = false;
    private float fov;

    public GLMapState(int n2, long l2) {
        if (l2 != 0L) {
            this.native_engine_instance = l2;
            this.native_state_instance = GLMapState.nativeNewInstance(n2, l2);
            this.is_new_instance = true;
        }
    }

    public GLMapState() {
        this.native_state_instance = 0L;
    }

    public void setMapstateInstance(long l2) {
        this.native_state_instance = l2;
    }

    public void recycle() {
        if (this.native_state_instance != 0L && this.is_new_instance) {
            GLMapState.nativeStateDestroy(this.native_state_instance);
        }
        this.native_state_instance = 0L;
    }

    public long getNativeInstance() {
        return this.native_state_instance;
    }

    public long getMapengineInstance() {
        return this.native_engine_instance;
    }

    protected void finalize() throws Throwable {
        if (this.native_state_instance != 0L && this.is_new_instance) {
            GLMapState.nativeStateDestroy(this.native_state_instance);
        }
        this.native_state_instance = 0L;
    }

    public void setNativeMapengineState(int n2, long l2) {
        if (l2 == 0L || this.native_state_instance == 0L) {
            return;
        }
        this.native_engine_instance = l2;
        GLMapState.nativeSetMapState(n2, l2, this.native_state_instance);
    }

    public Point getMapGeoCenter() {
        Point point = new Point();
        GLMapState.nativeGetMapCenter(this.native_state_instance, point);
        return point;
    }

    public void setMapGeoCenter(int n2, int n3) {
        GLMapState.nativeSetMapCenter(this.native_state_instance, n2, n3);
    }

    public float getFov() {
        return GLMapState.nativeGetFov(this.native_state_instance);
    }

    public PointF getMapGlCenter() {
        PointF pointF = new PointF();
        GLMapState.nativeGetMapGLCenter(this.native_state_instance, pointF);
        return pointF;
    }

    public void setMapGlCenter(float f2, float f3) {
        GLMapState.nativeSetMapGLCenter(this.native_state_instance, f2, f3);
    }

    public float getCameraDegree() {
        return GLMapState.nativeGetCameraDegree(this.native_state_instance);
    }

    public void setCameraDegree(float f2) {
        GLMapState.nativeSetCameraDegree(this.native_state_instance, f2);
    }

    public float getMapAngle() {
        return GLMapState.nativeGetMapAngle(this.native_state_instance);
    }

    public void setMapAngle(float f2) {
        float f3 = 0.0f;
        f3 = f2 < 0.0f ? f2 + 360.0f : (f2 >= 360.0f ? f2 - 360.0f : f2);
        GLMapState.nativeSetMapAngle(this.native_state_instance, f3);
    }

    public float getMapZoomer() {
        return GLMapState.nativeGetMapZoomer(this.native_state_instance);
    }

    public void setMapZoomer(float f2) {
        if (f2 > (float)GLMapState.nativeGetMaxZoomLevel(this.native_state_instance)) {
            f2 = GLMapState.nativeGetMaxZoomLevel(this.native_state_instance);
        }
        GLMapState.nativeSetMapZoomer(this.native_state_instance, f2);
    }

    public void recalculate() {
        GLMapState.nativeRecalculate(this.native_state_instance);
    }

    public Rect getMapViewBound() {
        Rect rect = new Rect();
        GLMapState.nativeGetMapViewBound(this.native_state_instance, rect);
        return rect;
    }

    public void screenToMapGPoint(float f2, float f3, PointF pointF) {
        GLMapState.nativeScreenToMapGPoint(this.native_state_instance, f2, f3, pointF);
    }

    public void p20ToMapPoint(int n2, int n3, PointF pointF) {
        GLMapState.nativeP20ToMapPoint(this.native_state_instance, n2, n3, pointF);
    }

    public void p20ToScreenPoint(int n2, int n3, PointF pointF) {
        GLMapState.nativeP20ToScreenPoint(this.native_state_instance, n2, n3, pointF);
    }

    public void mapToScreenPoint(float f2, float f3, PointF pointF) {
        GLMapState.nativeMapToScreenPoint(this.native_state_instance, f2, f3, pointF);
    }

    public void mapToScreenPointWithZ(float f2, float f3, float f4, PointF pointF) {
        GLMapState.nativeMapToScreenPointWithZ(this.native_state_instance, f2, f3, f4, pointF);
    }

    public void mapToP20Point(float f2, float f3, Point point) {
        GLMapState.nativeMapToP20Point(this.native_state_instance, f2, f3, point);
    }

    public void screenToP20Point(float f2, float f3, Point point) {
        GLMapState.nativeScreenToP20Point(this.native_state_instance, f2, f3, point);
    }

    public float getGLUnitWithWin(int n2) {
        return GLMapState.nativeGetGLUnitWithWin(this.native_state_instance, n2);
    }

    public float getGLUnitWithPixel20(int n2) {
        return GLMapState.nativeGetGLUnitWithPixel20(this.native_state_instance, n2);
    }

    public float getGLUnitWithWinByY(int n2, int n3) {
        return GLMapState.nativeGetGLUnitWithWinByY(this.native_state_instance, n2, n3);
    }

    public void getPixel20Bound(Rect rect) {
        GLMapState.nativeGetPixel20Bound(this.native_state_instance, rect);
    }

    public void getViewMatrix(float[] fArray) {
        if (fArray != null && fArray.length == 16) {
            GLMapState.nativeGetViewMatrix(this.native_state_instance, fArray);
        }
    }

    public void getProjectionMatrix(float[] fArray) {
        if (fArray != null && fArray.length == 16) {
            GLMapState.nativeGetProjectionMatrix(this.native_state_instance, fArray);
        }
    }

    public void getCameraPosition(int[] nArray) {
        if (nArray != null && nArray.length == 3) {
            GLMapState.nativeGetCameraPosition(this.native_state_instance, nArray);
        }
    }

    public void getGeoCenter(IPoint iPoint) {
        if (this.native_state_instance != 0L) {
            Point point = new Point();
            GLMapState.nativeGetMapCenter(this.native_state_instance, point);
            iPoint.x = point.x;
            iPoint.y = point.y;
        }
    }

    public float getCameraHeaderAngle() {
        if (this.native_state_instance != 0L) {
            return GLMapState.nativeGetCameraDegree(this.native_state_instance);
        }
        return 0.0f;
    }

    public float getMapLenWithWin(int n2) {
        if (this.native_state_instance != 0L) {
            return this.getGLUnitWithWin(n2);
        }
        return 0.0f;
    }

    public void map2Win(float f2, float f3, IPoint iPoint) {
        if (this.native_state_instance != 0L) {
            PointF pointF = new PointF();
            GLMapState.nativeMapToScreenPoint(this.native_state_instance, f2, f3, pointF);
            iPoint.x = (int)pointF.x;
            iPoint.y = (int)pointF.y;
        }
    }

    public void win2Map(int n2, int n3, FPoint fPoint) {
        if (this.native_state_instance != 0L) {
            PointF pointF = new PointF();
            GLMapState.nativeScreenToMapGPoint(this.native_state_instance, n2, n3, pointF);
            fPoint.x = (int)pointF.x;
            fPoint.y = (int)pointF.y;
        }
    }

    public void geo2Map(int n2, int n3, FPoint fPoint) {
        if (this.native_state_instance != 0L) {
            PointF pointF = new PointF();
            GLMapState.nativeP20ToMapPoint(this.native_state_instance, n2, n3, pointF);
            fPoint.x = pointF.x;
            fPoint.y = pointF.y;
        }
    }

    public void map2Geo(float f2, float f3, IPoint iPoint) {
        if (this.native_state_instance != 0L) {
            Point point = new Point();
            GLMapState.nativeMapToP20Point(this.native_state_instance, f2, f3, point);
            iPoint.x = point.x;
            iPoint.y = point.y;
        }
    }

    public static void lonlat2Geo(double d2, double d3, IPoint iPoint) {
        Point point = VirtualEarthProjection.LatLongToPixels(d3, d2, 20);
        iPoint.x = point.x;
        iPoint.y = point.y;
    }

    public static void geo2LonLat(int n2, int n3, DPoint dPoint) {
        DPoint dPoint2 = VirtualEarthProjection.PixelsToLatLong(n2, n3, 20);
        dPoint.x = dPoint2.x;
        dPoint.y = dPoint2.y;
    }

    public static native long nativeNewInstance(int var0, long var1);

    public static native void nativeStateDestroy(long var0);

    public static native void nativeSetMapState(int var0, long var1, long var3);

    public static native void nativeGetMapCenter(long var0, Point var2);

    public static native void nativeGetMapGLCenter(long var0, PointF var2);

    public static native float nativeGetCameraDegree(long var0);

    public static native float nativeGetFov(long var0);

    public static native float nativeGetMapAngle(long var0);

    public static native float nativeGetMapZoomer(long var0);

    public static native void nativeSetMapCenter(long var0, int var2, int var3);

    public static native void nativeSetMapGLCenter(long var0, float var2, float var3);

    public static native void nativeSetCameraDegree(long var0, float var2);

    public static native void nativeSetMapAngle(long var0, float var2);

    public static native void nativeSetMapZoomer(long var0, float var2);

    public static native void nativeGetMapViewBound(long var0, Rect var2);

    public static native void nativeRecalculate(long var0);

    public static native int nativeGetMaxZoomLevel(long var0);

    public static native int nativeGetMinZoomLevel(long var0);

    public static native void nativeScreenToMapGPoint(long var0, float var2, float var3, PointF var4);

    public static native void nativeP20ToMapPoint(long var0, int var2, int var3, PointF var4);

    public static native void nativeP20ToScreenPoint(long var0, int var2, int var3, PointF var4);

    public static native void nativeMapToScreenPoint(long var0, float var2, float var3, PointF var4);

    public static native void nativeMapToScreenPointWithZ(long var0, float var2, float var3, float var4, PointF var5);

    public static native void nativeMapToP20Point(long var0, float var2, float var3, Point var4);

    public static native void nativeScreenToP20Point(long var0, float var2, float var3, Point var4);

    public static native float nativeGetGLUnitWithWin(long var0, int var2);

    public static native float nativeGetGLUnitWithPixel20(long var0, int var2);

    public static native float nativeGetGLUnitWithWinByY(long var0, int var2, int var3);

    public static native void nativeGetPixel20Bound(long var0, Rect var2);

    public static native void nativeGetViewMatrix(long var0, float[] var2);

    public static native void nativeGetProjectionMatrix(long var0, float[] var2);

    public static native void nativeGetCameraPosition(long var0, int[] var2);
}

