/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.ae.gmap.maploader.BaseMapLoader;
import com.autonavi.ae.gmap.maploader.MapSourceGridData;
import com.autonavi.ae.gmap.utils.GLConvertUtil;
import java.util.ArrayList;

public class OpenLayerMapLoader
extends BaseMapLoader {
    static final int DATA_OPENLAYER_TYPEGEOMETRY = 17;
    private static ArrayList<DownTilesInfor> g_arrLayerDownBuffer = new ArrayList();
    private String mStrSeverAdd;
    private String mStrPath;
    private String mStrGridParams;
    private int mLayerid;
    private int mSubLayerid;
    private byte[] mArrblayerid;
    private byte[] mArrbsublayerid;

    public OpenLayerMapLoader(int n2, GLMapEngine gLMapEngine, String string, int n3, int n4, int n5) {
        super(n2);
        this.mGLMapEngine = gLMapEngine;
        int n6 = string.indexOf("://");
        if (n6 < 0) {
            return;
        }
        this.mDataSource = n3;
        n6 = string.indexOf("/", n6 + 4);
        this.mStrSeverAdd = string.substring(0, n6 + 1);
        this.mStrPath = string.substring(n6 + 1);
        if (this.mStrPath.indexOf(63) < 0) {
            this.mStrPath = this.mStrPath + '?';
        }
        this.mLayerid = n4;
        this.mArrblayerid = GLConvertUtil.convertInt(this.mLayerid);
        this.mSubLayerid = n5;
        this.mArrbsublayerid = GLConvertUtil.convertInt(n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExistAndAdd(int n2, String string) {
        ArrayList<DownTilesInfor> arrayList = g_arrLayerDownBuffer;
        synchronized (arrayList) {
            for (int i2 = 0; i2 < g_arrLayerDownBuffer.size(); ++i2) {
                if (OpenLayerMapLoader.g_arrLayerDownBuffer.get((int)i2).mSubLayerID != n2 || string.compareTo(OpenLayerMapLoader.g_arrLayerDownBuffer.get((int)i2).mStrTile) != 0) continue;
                return true;
            }
            DownTilesInfor downTilesInfor = new DownTilesInfor();
            downTilesInfor.mSubLayerID = n2;
            downTilesInfor.mStrTile = string;
            g_arrLayerDownBuffer.add(downTilesInfor);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDownTile(int n2, String string) {
        ArrayList<DownTilesInfor> arrayList = g_arrLayerDownBuffer;
        synchronized (arrayList) {
            for (int i2 = 0; i2 < g_arrLayerDownBuffer.size(); ++i2) {
                if (OpenLayerMapLoader.g_arrLayerDownBuffer.get((int)i2).mSubLayerID != n2 || string.compareTo(OpenLayerMapLoader.g_arrLayerDownBuffer.get((int)i2).mStrTile) != 0) continue;
                g_arrLayerDownBuffer.remove(i2);
                return;
            }
        }
    }

    public boolean createDownUrl(String[] stringArray) {
        int n2 = 17 == this.mDataSource ? 4 : 1;
        this.mStrGridParams = String.format("type=50&mapdataver=6&aetraffic=8&lyrtype=%d&id=%d&mesh=", n2, this.mSubLayerid);
        String string = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (this.isExistAndAdd(this.mSubLayerid, stringArray[i2])) continue;
            this.mMapTiles.add(new MapSourceGridData(stringArray[i2], this.mDataSource, 0, 0));
            string = string + stringArray[i2];
            string = string + ';';
        }
        if (string.length() > 1) {
            this.mStrGridParams = this.mStrGridParams + string.substring(0, string.length() - 1);
        }
        return string.length() > 1;
    }

    protected String getMapAddress() {
        return this.mStrSeverAdd;
    }

    protected String getMapServerPath() {
        return this.mStrPath;
    }

    protected String getGridParams() {
        this.mStrGridParams = this.mStrGridParams + "&channel=amapapi";
        return this.mStrGridParams;
    }

    protected boolean processReceivedDataHeader() {
        if (this.mReceivedDataSize > 7) {
            int n2 = 0;
            int n3 = GLConvertUtil.getInt(this.mReceivedDataBuffer, n2);
            if (n3 != 0) {
                this.doCancel();
                return false;
            }
            n2 += 4;
            this.mReceivedDataSize -= (n2 += 4);
            if (this.mReceivedDataSize > 0) {
                GLConvertUtil.moveArray(this.mReceivedDataBuffer, n2, this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
            }
            this.mNextImgDataLength = 0;
            this.isReceivedHeader = true;
            super.processReceivedDataV4();
            return true;
        }
        return false;
    }

    protected void putMapData(byte[] byArray, int n2, int n3, int n4, int n5, String string) {
        byte[] byArray2 = new byte[n3 + 8];
        System.arraycopy(this.mArrblayerid, 0, byArray2, 0, 4);
        System.arraycopy(this.mArrbsublayerid, 0, byArray2, 4, 4);
        System.arraycopy(byArray, n2, byArray2, 8, n3);
        if (null != this.mGLMapEngine) {
            this.mGLMapEngine.putMapData(this.mEngineID, byArray2, 0, n3 + 8, n4, n5);
            this.mGLMapEngine.resetRenderTime(this.mEngineID);
        }
    }

    protected void downLoadOver(int n2) {
        int n3 = this.mMapTiles.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            OpenLayerMapLoader.removeDownTile(this.mSubLayerid, ((MapSourceGridData)this.mMapTiles.get(i2)).getGridName());
        }
    }

    protected void processReceivedDataByType() {
        super.processReceivedDataV4();
    }

    protected void processReceivedVersion() {
    }

    public boolean isRequestValid() {
        return true;
    }

    protected boolean isNeedReturn() {
        return false;
    }

    protected class DownTilesInfor {
        String mStrTile;
        int mSubLayerID;

        protected DownTilesInfor() {
        }
    }
}

