/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.view.MotionEvent;

public abstract class BaseGestureDetector {
    protected final Context mContext;
    protected boolean mGestureInProgress;
    protected MotionEvent mPrevEvent;
    protected MotionEvent mCurrEvent;
    protected float mCurrPressure;
    protected float mPrevPressure;
    protected long mTimeDelta;
    protected static final float PRESSURE_THRESHOLD = 0.67f;

    public BaseGestureDetector(Context context) {
        this.mContext = context;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction() & 0xFF;
        if (!this.mGestureInProgress) {
            this.handleStartProgressEvent(n2, motionEvent);
        } else {
            this.handleInProgressEvent(n2, motionEvent);
        }
        return true;
    }

    protected abstract void handleStartProgressEvent(int var1, MotionEvent var2);

    protected abstract void handleInProgressEvent(int var1, MotionEvent var2);

    protected void updateStateByEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = this.mPrevEvent;
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        this.mTimeDelta = motionEvent.getEventTime() - motionEvent2.getEventTime();
        if (Build.VERSION.SDK_INT >= 8) {
            this.mCurrPressure = motionEvent.getPressure(motionEvent.getActionIndex());
            this.mPrevPressure = motionEvent2.getPressure(motionEvent2.getActionIndex());
        } else {
            this.mCurrPressure = motionEvent.getPressure(0);
            this.mPrevPressure = motionEvent2.getPressure(0);
        }
    }

    protected void resetState() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mGestureInProgress = false;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public MotionEvent getEvent() {
        return this.mCurrEvent;
    }

    public static PointF determineFocalPoint(MotionEvent motionEvent) {
        int n2 = motionEvent.getPointerCount();
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 += motionEvent.getX(i2);
            f3 += motionEvent.getY(i2);
        }
        return new PointF(f2 / (float)n2, f3 / (float)n2);
    }

    public static PointF getFocalPoint(MotionEvent motionEvent) {
        int n2 = motionEvent.getPointerCount();
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 += BaseGestureDetector.getRawX(motionEvent, i2);
            f3 += BaseGestureDetector.getRawY(motionEvent, i2);
        }
        return new PointF(f2 / (float)n2, f3 / (float)n2);
    }

    private static float getRawX(MotionEvent motionEvent, int n2) {
        if (n2 < 0) {
            return Float.MIN_VALUE;
        }
        if (n2 == 0) {
            return motionEvent.getRawX();
        }
        float f2 = motionEvent.getRawX() - motionEvent.getX();
        return motionEvent.getX(n2) + f2;
    }

    private static float getRawY(MotionEvent motionEvent, int n2) {
        if (n2 < 0) {
            return Float.MIN_VALUE;
        }
        if (n2 == 0) {
            return motionEvent.getRawY();
        }
        float f2 = motionEvent.getRawY() - motionEvent.getY();
        return motionEvent.getY(n2) + f2;
    }
}

