import * as React from 'react';
import { View } from 'react-native';
import PropTypes from 'prop-types';
import AbstractFormComponent from '../Form/AbstractFormComponent';
/**
 * @author 田尘殇Sean(sean.snow@live.com) create at 2018/3/2
 */
export class RadioGroup extends AbstractFormComponent {
    constructor(props) {
        super(props);
        this.state = {
            checked: props.defaultChecked || props.checked
        };
    }
    getChildContext() {
        return {
            onChange: this.handleChange,
            labelPosition: this.props.labelPosition,
            checked: this.state.checked
        };
    }
    componentWillReceiveProps({ checked }) {
        if (this.props.checked !== checked) {
            this.setState({ checked });
        }
    }
    handleChange(checked) {
        this.setState({ checked });
        const { onChange } = this.props;
        onChange && onChange(checked);
    }
    getValue() {
        return this.state.checked;
    }
    isValid() {
        return true;
    }
    render() {
        const { children, ...props } = this.props;
        return (<View {...props}>
        {children}
      </View>);
    }
}
RadioGroup.childContextTypes = {
    onChange: PropTypes.func,
    labelPosition: PropTypes.oneOf(['left', 'right']),
    checked: PropTypes.any
};
RadioGroup.defaultProps = {
    labelPosition: 'right'
};
