/// <reference types="react" />
import * as React from 'react';
import Component from '../AbstractComponent';
import RootManager from '../createRootNode/RootManager';
import Props from './Props';
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 16/5/24
 */
export declare class AbstractDialog extends Component<Props> {
    static defaultProps: {
        autoDisableAndroidBackPress: boolean;
        activeOpacity: number;
        visible: boolean;
        statusBarAutoHidden: boolean;
    };
    state: {
        animating: boolean;
        visible: boolean;
    };
    mounted: boolean;
    statusBarHidden: boolean;
    componentWillMount(): void;
    componentWillReceiveProps(): void;
    shounldComponentUpdate(): boolean;
    componentWillUnmount(): void;
    handleHardwareBackPress(): void;
    handlePress(): void;
    handleAnimationBegin(): void;
    handleAnimationEnd(): void;
    renderLoading({children, loadingProps}: {
        children: any;
        loadingProps: any;
    }): JSX.Element;
    render(): JSX.Element;
}
declare const _default: {
    new (props: Props, context?: any): {
        manager: RootManager;
        componentWillMount(): void;
        componentWillUpdate(nextProps: any): void;
        componentWillUnmount(): void;
        render(): JSX.Element;
        setState<K extends string>(state: any, callback?: () => void): void;
        forceUpdate(callBack?: () => void): void;
        props: Readonly<{
            children?: React.ReactNode;
        }> & Readonly<Props>;
        state: Readonly<any>;
        context: any;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidMount?(): void;
        shouldComponentUpdate?(nextProps: Readonly<Props>, nextState: Readonly<any>, nextContext: any): boolean;
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        getSnapshotBeforeUpdate?(prevProps: Readonly<Props>, prevState: Readonly<any>): any;
        componentDidUpdate?(prevProps: Readonly<Props>, prevState: Readonly<any>, snapshot?: any): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<Props>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<Props>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<Props>, nextState: Readonly<any>, nextContext: any): void;
    };
};
export default _default;
