export interface TypeProps {
    text: number;
    image: number;
    music: number;
    video: number;
    webPage: number;
}
export interface SceneProps {
    session: number;
    timeLine: number;
    favorite: number;
}
export interface Options {
    scene: SceneProps;
    type: TypeProps;
    text: String;
    description: String;
    mediaTagName: String;
    messageAction: String;
    messageExt: String;
    image: String;
    thumbImageSize: Number;
    webPageUrl: String;
}
export declare const Scene: SceneProps;
export declare const Type: TypeProps;
/**
 * @author 田尘殇Sean(sean.snow@live.com)
 * @date 2017/5/17
 */
declare class WeChat {
    /**
     * 向微信注册
     * @param appId appId
     */
    static registerApp(appId: String): any;
    /**
     * 分享
     * @param options 分享参数
     */
    static share(options: Options): any;
}
export default WeChat;
